<?php
function success_message($msg)
{
    message('success', 'Success', $msg);
}

function error_message($msg)
{
    message('error', 'Failed', $msg);
}

function warning_message($msg, $warning = 'Warning')
{
    message('warning', $warning, $msg);
}

function message($type, $title, $msg)
{
    $escapedMsg = htmlspecialchars(ucwords($msg), ENT_QUOTES);
    $escapedTitle = htmlspecialchars($title, ENT_QUOTES);

    echo "<script>
        document.addEventListener('DOMContentLoaded', function () {
            Swal.fire({
                icon: '$type',
                title: '$escapedTitle',
                text: '$escapedMsg',
                customClass: {
                    confirmButton: 'btn btn-primary'
                },
                buttonsStyling: false
            });
        });
    </script>";
}



// thinking of displaying multiple errors at once

require_once 'message.php';