<?php
require_once '../path.php';
require_once MODEL_PATH . "operations.php";

$action = (isset($_GET['action']) && $_GET['action'] != '') ? security('action', 'GET') : '';


foreach ($_GET as $key => $val) {
    $conn = connect();
    $_GET[$key] = mysqli_real_escape_string($conn, $_GET[$key]);
}
foreach ($_POST as $key => $val) {
    $conn = connect();
    if (!is_array($_POST[$key])) {
        $_POST[$key] = mysqli_real_escape_string($conn, $_POST[$key]);
    }
}


switch ($action) {
    case 'admin_login':
        get_admin_login();
        break;
    case 'user_login':
        get_user_login();
        break;
    case 'step':
        update_step();
        break;
    case 'register':
        post_user();
        break;
    case 'update_event':
        update_event();
        break;
    case 'edit_user':
        edit_user();
        break;
    case 'admin_email':
        admin_email();
        break;
    case 'admin_upload':
        admin_upload();
        break;
    case 'password':
        post_password();
        break;
    case 'email':
        post_email();
        break;
    case 'booking':
        post_booking();
        break;
    case 'chat':
        post_chat();
        break;
    case 'upload':
        post_upload();
        break;
    case 'simple':
        post_simple($_GET['table'], $_GET['url']);
        break;
}

function post_simple($table, $url)
{
    global $arr;
    global $error;
    global $success;

    $return_url = admin_url . $url;


    for_loop();


    $param = '';
    if (isset($_SESSION['edit'])) {
        $param = "?id=" . encrypt($_SESSION['edit']);
    }

    if (!empty($error)) {
        $url = $return_url . $param;
        error_checker($url);
    }

    if (isset($_SESSION['edit'])) {
        $id = $_SESSION['edit'];
        unset($_SESSION['edit']);

        if (!build_sql_edit($table, $arr, $id, $table . '_id')) {
            $error[$table] = 149;
            error_checker($return_url . '   ?id=' . encrypt($id));
        }

        $success[$table] = 221;
        render_success($return_url . '?id=' .  encrypt($id));
    }

    $id = $arr[$table . '_id'] = create_id($table, $table . '_id');
    //  var_dump($arr);
    //  var_dump($table);

    if (!build_sql_insert($table, $arr)) {
        $error[$table] = 150;
        error_checker($return_url);
    }

    $success[$table] = 220;
    render_success($return_url . '?id=' .  encrypt($id));
}


function post_user()
{
    global $arr;
    global $error;
    global $success;

    $return_url = base_url . 'register';

    for_loop();
    
    // cout($arr);
    
    if(!empty(select_rows("SELECT * FROM user WHERE user_email = '$arr[user_email]' "))){
        $error['user'] = 134;
        error_checker($return_url);
        
    }else{
        
    

    if (isset($_SESSION['edit'])) {
        $id = $_SESSION['edit'];
        unset($_SESSION['edit']);

        if (!build_sql_edit('user', $arr, $id, 'user_id')) {
            $error['user'] = 149;
            error_checker($return_url . '   ?id=' . encrypt($id));
        }

        $success['user'] = 221;
        render_success($return_url . '?id=' .  encrypt($id));
    }


    $id = $arr['user_id']   = create_id('user', 'user_id');
    $arr['user_password']   = password_hashing_hybrid_maker_checker($arr['user_password']);

    if (!build_sql_insert('user', $arr)) {
        $error['user'] = 139;
        error_checker($return_url);
    }


    $name       = APP_NAME;
    $subject    = "Account Creation";

    $body       = '<p style="font-family:Poppins, sans-serif; ">Welcome to ' . APP_NAME . ' ' . $arr['user_name'] . '  <br>';
    $body       .= 'Hi ' . $arr['user_name'] . '<br>
    Welcome to Watare Global Solutions - we\'re thrilled to have you on board!<br>
    Your account has been successfully created, and you\'re now one step closer to seamless travel, personalized experiences, and global opportunities tailored just for you.<br>
    We provide custom travel packages that match your goals, transparent pricing with no hidden costs, global expertise including UK-based knowledge, and a customer-first approach with dedicated support every step of the way.<br>
    ';
    $body       .= '</p>';
    $body       .= '<p style="font-family:Poppins, sans-serif; ">Yours,<br> ' . APP_NAME . ' Management</p>';

    $body2      = 'Welcome to Watare Global Solutions. Thrilled to have you on board';

    $status = email($arr['user_email'], $subject, $name, $body);
    email('hawklimited7@gmail.com', $subject, $name, $body2);

    $emailArray['email_id'] = create_id('email', 'email_id');
    $emailArray['email_subject'] = $subject;
    $emailArray['email_body'] = $body2;
    $emailArray['email_from'] = 'Super Admin';
    $emailArray['email_to'] = $arr['user_id'];
    $emailArray['email_source'] = 'admin';
    $emailArray['email_status'] = $status;

    if (!build_sql_insert('email', $emailArray)) {
        $error['email'] = 139;
        error_checker($return_url);
    }


    $notifArray['notification_title'] = 'New User';
    $notifArray['notification_text'] = 'A new user by the name ' . $arr['user_name'] . ' has signed up';
    $notifArray['notification_to'] = 'Admin';
    $notifArray['notification_from'] = $arr['user_id'];
    $notifArray['notification_redirect'] = 'user?id=' . encrypt($arr['user_id']);

    if (!build_sql_insert('notification', $notifArray)) {
        $error['notification'] = 139;
        error_checker($return_url);
    }

    $session_login  = array(
        'user_login'             => true,
        'user_email'        => $arr['user_email'],
        'user_id'           => $arr['user_id'],
        'success'           => array('login' => 204)
    );

    session_assignment($session_login);

    $success['user'] = 203;
    render_success($return_url);
    }
}

function edit_user()
{
    global $arr;
    global $error;
    global $success;

    $return_url = client_url . 'profile';

    $id = security('uid');
    unset($_POST['uid']);

    for_loop();

    if (!empty($_FILES['user_image']['name'])) {
        $result = upload_image('user_image');

        if (isset($result['error'])) {
            $error['user_image'] = $result['error'];
            error_checker($return_url);
        }

        $arr['user_image'] = $result['file_name'];
        if (!empty($arr['user_image']))   delete_file('user_image', 'user', 'user_id', $id);
    }

    if (!build_sql_edit('user', $arr, $id, 'user_id')) {
        $error['user'] = 149;
        error_checker($return_url);
    }

    $notifArray['notification_title'] = 'User Edited Their Details';
    $notifArray['notification_text'] = 'A new user by the name ' . $arr['user_name'] . ' has signed up';
    $notifArray['notification_to'] = 'Admin';
    $notifArray['notification_from'] = $arr['user_id'];
    $notifArray['notification_redirect'] = 'user?id=' . encrypt($arr['user_id']);

    if (!build_sql_insert('notification', $notifArray)) {
        $error['notification'] = 139;
        error_checker($return_url);
    }

    $success['user'] = 221;
    render_success($return_url);
}

function update_step()
{
    global $arr;
    global $error;
    global $success;

    $return_url = admin_url . 'view_users';

    // for_loop();
    // cout($_POST);
    $step_ids = $_POST['step_ids'] ?? [];

    $bid = security('booking_id');
    $uid = security('user_id');
    $maxStep = max($step_ids);
    $arr['booking_status'] = $maxStep;

    // Validate: must have at least 1 step
    if (empty($step_ids) || !is_array($step_ids)) {
        $error['step'] = "No steps provided.";
        error_checker($return_url . '?id=' . encrypt($uid));
    }


    if (!build_sql_edit('booking', $arr, $bid, 'booking_id')) {
        $error['booking'] = 149;
        error_checker($return_url . '   ?id=' . encrypt($uid));
    }
    unset($arr);

    $arr['progress_id'] = create_id('progress', 'progress_id');
    $arr['user_id'] = $uid;
    $arr['booking_id'] = $bid;
    $arr['step_id'] = $maxStep;

    if (!build_sql_insert('progress', $arr)) {
        $error['progress'] = 139;
        error_checker($return_url);
    }

    $notifArray['notification_title'] = 'Application Progress';
    $notifArray['notification_text'] = 'Your application  status has been updated';
    $notifArray['notification_to'] = $uid;
    $notifArray['notification_from'] = 'Admin';
    $notifArray['notification_redirect'] = 'progress';

    if (!build_sql_insert('notification', $notifArray)) {
        $error['notification'] = 139;
        error_checker($return_url);
    }


    $success['booking'] = 221;
    render_success($return_url . '?id=' .  encrypt($uid));
}

function post_booking()
{
    global $arr;
    global $error;
    global $success;

    $return_url = client_url . 'apply';
        $failed_url = client_url . 'calendar';
    // cout($_POST);

    $arr['booking_id']   = create_id('booking', 'booking_id');
    $arr['booking_code'] = 'WSG-' . generateRandomString(5);
    $arr['user_id'] = $_SESSION['user_id'];
    $arr['booking_props'] = security('booking_props');
    $arr['booking_description'] = security('booking_description');
    $arr['booking_title'] = security('booking_title');
    if (isset($_POST['booking_date'])) {
        $datetime = $_POST['booking_date'];
        $datetimeParts = explode(' ', $datetime); // [0] => date, [1] => time

        $jour = $arr['booking_date'] = $datetimeParts[0]; // '2025-05-09'
        $temps = $arr['booking_time'] = $datetimeParts[1]; // '14:05'
    }
    
    $today = date('Y-m-d');
    if ($jour <= $today) {
       $error['booking'] = 155;
        error_checker($failed_url);
    }else{
        
  

    if (isset($_POST['eventId']) && $_POST['eventId'] !== '') {
        $id = security('eventId');
        if (!build_sql_edit('booking', $arr, $id, 'booking_id')) {
            $error['booking'] = 149;
            error_checker($failed_url);
        }

        $success['booking'] = 221;
        render_success($return_url . '?id=' .  encrypt($id));
    } else {
        $scheduleCount = sizeof(select_rows("SELECT * FROM booking WHERE booking_date = '$jour' and booking_time = '$temps' "));

        if ($scheduleCount >= 2) {
            $error['booking'] = 150;
            error_checker($failed_url);
        } else {
            if (!build_sql_insert('booking', $arr)) {
                $error['booking'] = 139;
                error_checker($return_url);
            }

            $name       = APP_NAME;
            $subject    = "Appointment Booked";

            $body       = '<p style="font-family:Poppins, sans-serif; ">Welcome to ' . APP_NAME . ' ' . $arr['user_name'] . '  <br>';
            $body       .= 'Hi ' . $arr['user_name'] . '<br>
            Thank you for booking with Watare Global Solutions - your appointment has been successfully scheduled!<br>
            🗓️ Date: ' . $arr['booking_date'] . '<br>
            ⏰ Time: ' . $arr['booking_time'] . '<br>
            ';
            $body       .= '</p>';
            $body       .= '<p style="font-family:Poppins, sans-serif; ">Yours,<br> ' . APP_NAME . ' Management</p>';

            $body2      = '<p style="font-family:Poppins, sans-serif; ">A new user has signed up to ' . APP_NAME . ' with the details: <br> <b>USERNAME: </b> ' . $arr['user_name'] . ' <br>';
            $body2      .= ' <b>EMAIL: </b> ' . $arr['user_email'] . ' <br> ';
            $body2      .= '</p>';

            $status = email($arr['user_email'], $subject, $name, $body);

            $emailArray['email_id'] = create_id('email', 'email_id');
            $emailArray['email_subject'] = $subject;
            $emailArray['email_body'] = $body;
            $emailArray['email_from'] = 'Super Admin';
            $emailArray['email_to'] = $arr['user_id'];
            $emailArray['email_source'] = 'admin';
            $emailArray['email_status'] = $status;

            if (!build_sql_insert('email', $emailArray)) {
                $error['email'] = 139;
                error_checker($failed_url);
            }

            $notifArray['notification_title'] = 'Appointment Booked';
            $notifArray['notification_text'] = 'A user by the name ' . $arr['user_name'] . ' has booked their appointment';
            $notifArray['notification_to'] = 'Admin';
            $notifArray['notification_from'] = $arr['user_id'];
            $notifArray['notification_redirect'] = 'user?id=' . encrypt($arr['user_id']);

            if (!build_sql_insert('notification', $notifArray)) {
                $error['notification'] = 139;
                error_checker($failed_url);
            }

            $success['booking'] = 203;
            render_success($return_url);
        }
    }
    }
}

function update_event()
{
    global $arr;
    global $error;
    global $success;

    $return_url = client_url . 'calendar';
    $failed_url = client_url . 'calendar';

    cout($_POST);

    for_loop();


    if (!build_sql_edit('booking', $arr, $_SESSION['booking_id'], 'booking_id')) {
        $error['booking'] = 149;
        error_checker($failed_url);
    }

    $name       = APP_NAME;
    $subject    = APP_NAME . " Sign Up";


    $body       = '<p style="font-family:Poppins, sans-serif; ">Welcome  <br>';
    $body       .= 'Booking on Watare  <br>';
    $body      .= '</p>';

    // email('pmanyara97@gmail.com', $subject, $name, $body);


    $success['booking'] = 203;
    render_success($return_url);
}


function post_upload()
{
    global $arr;
    global $error;
    global $success;

    $return_url = client_url . 'view_uploads';
    $failed_url = client_url . 'apply';

    $bid = security('booking_id');
    $country = security('country');
    $jobs = $_POST['jobs'];
    if (is_array($jobs)) {
        $job = implode(',', $jobs);
    } else {
        $job = $jobs;
    }

    unset($_POST['country']);
    unset($_POST['booking_id']);
    unset($_POST['jobs']);

    for_loop();

    if (!build_sql_edit('user', $arr, $_SESSION['user_id'], 'user_id')) {
        $error['user'] = 149;
        error_checker($failed_url);
    }

    unset($arr);

    // Array of file fields in your form
    $file_fields = ['upload_cv', 'upload_file', 'upload_bio'];

    foreach ($file_fields as $field) {
        if (!empty($_FILES[$field]['name'])) {
            $result = upload_file($field);

            if (isset($result['error'])) {
                $error[$field] = $result['error'];
                error_checker($failed_url);
            }

            $array[$field] = $result['file_name'];
        }
    }

    $image_fields = ['upload_passport', 'upload_full'];

    foreach ($image_fields as $img) {
        if (!empty($_FILES[$img]['name'])) {
            $res = upload_image($img);

            if (isset($res['error'])) {
                $error[$img] = $res['error'];
                error_checker($failed_url);
            }

            $array[$img] = $res['file_name'];
        }
    }

    $user = get_by_id('user', $_SESSION['user_id']);

    $array['upload_id']   = create_id('upload', 'upload_id');
    $array['user_id']     = $user['user_id'];
    $array['booking_id']     = $bid;
    $array['country']     = $country;
    $array['job']         = $job;
    $array['added_by']         = 'client';
    $array['upload_code'] = 'FILE-' . generateRandomString('8');

    if (!build_sql_insert('upload', $array)) {
        $error['upload'] = 139;
        error_checker($return_url);
    }

    $name       = APP_NAME;
    $subject    = "Uploads Successful";

    $body       = '<p style="font-family:Poppins, sans-serif; ">
    Great news - your documents have been successfully uploaded to Watare Global Solutions.

    Our team is now reviewing them to ensure everything is in order. We\'ll reach out shortly if anything else is needed or once the next steps are ready.

    What\'s Next?
    You can sit back while we handle the rest. Whether it\'s for travel arrangements, relocation, or placement services, you\'re one step closer to your goal.

    If you have any questions or need assistance, feel free to contact us.
    ';
    $body       .= '</p>';
    $body       .= '<p style="font-family:Poppins, sans-serif; ">Yours,<br> ' . APP_NAME . ' Management</p>';

    email($_SESSION['user_email'], $subject, $name, $body);


    $notifArray['notification_title'] = 'Uploaded Documents';
    $notifArray['notification_text'] = 'A user by the name ' . $user['user_name'] . ' has uploaded their documents';
    $notifArray['notification_to'] = 'Admin';
    $notifArray['notification_from'] = $user['user_id'];
    $notifArray['notification_redirect'] = 'user?id=' . encrypt($user['user_id']);

    if (!build_sql_insert('notification', $notifArray)) {
        $error['notification'] = 139;
        error_checker($return_url);
    }

    $success['upload'] = 206;
    render_success($return_url);
}

function admin_upload()
{
    global $arr;
    global $error;
    global $success;
    $uid = security('user_id');

    $return_url = $failed_url = admin_url . 'user?id=' . encrypt($uid);

    $file_fields = ['upload_cv', 'upload_letter', 'upload_cert', 'upload_file'];

    foreach ($file_fields as $field) {
        if (!empty($_FILES[$field]['name'])) {
            $result = upload_file($field);

            if (isset($result['error'])) {
                $error[$field] = $result['error'];
                error_checker($failed_url);
            }

            $arr[$field] = $result['file_name'];
        }
    }


    $booking = select_rows("SELECT * FROM upload WHERE added_by = 'client' AND user_id = '$uid' ORDER BY upload_date_created DESC")[0];
    $user = get_by_id('user', $uid);

    $arr['upload_id']     = create_id('upload', 'upload_id');
    $arr['user_id']       = $uid;
    $arr['booking_id']    = $booking['booking_id'];
    $arr['country']       = $booking['country'];
    $arr['job']           = $booking['job'];
    $arr['added_by']      = 'admin';
    $arr['upload_code']   = 'FILE-' . generateRandomString('8');

    if (!build_sql_insert('upload', $arr)) {
        $error['upload'] = 139;
        error_checker($return_url);
    }

    $name       = APP_NAME;
    $subject    = "Uploads Successful";

    $body       = '<p style="font-family:Poppins, sans-serif; ">
    Great news - your documents have been successfully uploaded to Watare Global Solutions.

    If you have any questions or need assistance, feel free to contact us.
    ';
    $body       .= '</p>';
    $body       .= '<p style="font-family:Poppins, sans-serif; ">Yours,<br> ' . APP_NAME . ' Management</p>';

    email($user['user_email'], $subject, $name, $body);

    //Update Progress
    $progArray['progress_id'] = create_id('progress', 'progress_id');
    $progArray['user_id'] = $uid;
    $progArray['booking_id'] = $arr['booking_id'];
    $progArray['step_id'] = '5';

    if (!build_sql_insert('progress', $progArray)) {
        $error['progress'] = 139;
        error_checker($return_url);
    }

    //Send notif
    $notifArray['notification_title']   = 'Uploaded Documents';
    $notifArray['notification_text']    = 'The admin has uploaded your documents';
    $notifArray['notification_to']      = $user['user_id'];
    $notifArray['notification_from']    = 'Admin';
    $notifArray['notification_redirect'] = 'view_uploads';

    if (!build_sql_insert('notification', $notifArray)) {
        $error['notification'] = 139;
        error_checker($return_url);
    }

    $success['upload'] = 205;
    render_success($return_url);
}

function post_email()
{
    global $arr;
    global $error;
    global $success;

    $return_url = client_url . 'email';

    for_loop();

    $arr['email_id'] = create_id('email', 'email_id');
    $arr['email_from'] = $_SESSION['user_id'];
    $arr['email_body'] = $_POST['email_body'];

    $name       = APP_NAME;

    $body       = '<p style="font-family:Poppins, sans-serif; "><br>';
    $body       .= $arr['email_body'];
    $body       .= '<p style="font-family:Poppins, sans-serif; ">Yours,<br> ' . APP_NAME . ' Management</p>';

    $arr['email_status'] = email('ayubimanarakoze@gmail.com', $arr['email_subject'], $name, $body);


    if (!build_sql_insert('email', $arr)) {
        $error['email'] = 139;
        error_checker($return_url);
    }

    $notifArray['notification_title'] = 'New Email';
    $notifArray['notification_text'] = 'The admin has responded to your email';
    $notifArray['notification_to'] = 'Admin';
    $notifArray['notification_from'] = $_SESSION['user_id'];
    $notifArray['notification_redirect'] = 'email';

    if (!build_sql_insert('notification', $notifArray)) {
        $error['notification'] = 139;
        error_checker($return_url);
    }

    $success['user'] = 203;
    render_success($return_url);
}

function admin_email()
{
    global $arr;
    global $error;
    global $success;

    $return_url = admin_url . 'email';

    for_loop();

    $arr['email_id'] = create_id('email', 'email_id');
    $arr['email_from'] = 'Super Admin';
    $uid = $arr['email_to'] = security('email_to');
    $arr['email_body'] = $_POST['email_body'];

    $user = get_by_id('user', $uid);

    $name       = APP_NAME;

    $body       = '<p style="font-family:Poppins, sans-serif; "><br>';
    $body       .= $arr['email_body'];
    $body       .= '<p style="font-family:Poppins, sans-serif; ">Yours,<br> ' . APP_NAME . ' Management</p>';

    $arr['email_status'] = email($user['user_email'], $arr['email_subject'], $name, $body);


    if (!build_sql_insert('email', $arr)) {
        $error['email'] = 139;
        error_checker($return_url);
    }

    $notifArray['notification_title'] = 'New Email';
    $notifArray['notification_text'] = 'The admin has responded to your email';
    $notifArray['notification_to'] = $user['user_id'];
    $notifArray['notification_from'] = 'Super Admin';
    $notifArray['notification_redirect'] = 'email';

    if (!build_sql_insert('notification', $notifArray)) {
        $error['notification'] = 139;
        error_checker($return_url);
    }

    $success['user'] = 203;
    render_success($return_url);
}


function post_password()
{
    global $arr;
    global $error;
    global $success;
    $return_url = client_url . 'password';

    $current_password = security('current_password');
    $new_password = security('new_password');

    // cout($_POST);
    $user = get_by_id('user', $_SESSION['user_id']);

    if (!password_hashing_hybrid_maker_checker($current_password, $user['user_password'])) {
        $error['user'] = 157;
        error_checker($return_url);
    }

    $arr['user_password'] = password_hashing_hybrid_maker_checker($new_password);

    if (!build_sql_edit('user', $arr, $_SESSION['user_id'], 'user_id')) {
        $error['user'] = 160;
        error_checker($return_url);
    }

    $success['user'] = 226;
    render_success($return_url);
}


function post_new_password()
{
    global $arr;
    global $error;
    global $success;
    $return_url =  'profile';

    // 	$password = md5($_POST['password']);

    $arr['user_password']       = password_hashing_hybrid_maker_checker($_POST['user_password']);

    if (!build_sql_edit('user', $arr, $_SESSION['user_id'], 'user_id')) {
        $error['user'] = 153;
        error_checker($return_url . '?failed');
    }


    $subject    = APP_NAME . ' Password Change';
    $name       = APP_NAME;
    $body       = '<p style="font-family:Poppins, sans-serif;"> ';
    $body       .= 'Hello, <b> ' . $_SESSION['user_name'] . ' </b> <br>';
    $body       .= 'Your account\'s password has been successfully changed.';
    $body       .= '<br>';
    $body       .= 'You may log in to your account in the future with these new credentials';
    $body       .= '<br>';
    $body       .= '<b>EMAIL:</b> ' . $_SESSION['user_email'] . ' <br>';
    $body       .= '<br>';
    $body       .= '<b>PASSWORD:</b> ' . $_POST['user_password'] . ' <br>';
    $body       .= '<br>';
    $body       .= '</p>';

    email($_SESSION['user_email'], $subject, $name, $body);

    $success['user'] = 224;
    render_success($return_url);
}


function post_chat()
{

    foreach ($_POST as $key => $val) {
        $_POST[$key] = security($key);
    }
    $_POST['date_created'] = date("Y-m-d H:i:s");
    build_sql_insert("messages", $_POST);
}



function create_id($table, $id)
{
    $date_today = date('Ymd');

    $table_prefix = array(
        'admin'         => 'ADM' . $date_today,
        'booking'       => 'BKG' . $date_today,
        'chat'          => 'CHT' . $date_today,
        'email'         => 'EML' . $date_today,
        'progress'      => 'PRG' . $date_today,
        'user'          => 'USR' . $date_today,
        'upload'        => 'UPD' . $date_today
    );

    $random_str = $table_prefix[$table] . rand_str();

    $get_id     = get_ids($table, $id, $random_str);

    while ($get_id == true) {
        $random_str = $table_prefix[$table] . rand_str();
        $get_id     = get_ids($table, $id, $random_str);
    }
    return $random_str;
}

function delete_file($image, $table, $id_name, $id_value)
{
    $sql = "select $image from $table where $id_name = '$id_value'";
    $row = select_rows($sql)[0];

    return unlink(TARGET_DIR  . 'images/' . $row[$image]);
}

function delete_upload($image, $table, $id_name, $id_value)
{
    $sql = "select $image from $table where $id_name = '$id_value'";
    $row = select_rows($sql)[0];

    return unlink(TARGET_DIR  . 'files/' . $row[$image]);
}

function for_loop()
{
    global $arr;

    foreach ($_POST as $key => $value) {
        $arr[$key] = security($key);
    }
}
