<?php 
$page = 'home';
include_once 'header.php'; ?>
<!-- Start Slider -->
<section class="tr_slider_wrap text-center wow fadeInUp">
    <div class="tr_slider">
        <div class="swiper-wrapper">
            <div class="swiper-slide">
                <div class="slider_item" style="background-image:url(asset/img/slider/slider6.jpg);">
                    <div class="container">
                        <h1 class="heading active_animation">We Are Your Destiny Connector</h1>
                        <p class="active_animation">Begin your journey today. Start your application process to Malta, Germany, and other top destinations through our expert recruitment and visa services.</p>
                        <a href="login" class="yellow_btn active_animation"><span>Start your application <i class="ph ph-arrow-right"></i></span></a>
                    </div>
                </div>
            </div><!-- End swiper-slide -->

            <div class="swiper-slide">
                <div class="slider_item" style="background-image:url(asset/img/slider/slider7.jpg);">
                    <div class="container">
                        <h1 class="heading active_animation">Over 250+ lives changed. Yours could be next.</h1>
                        <p class="active_animation">Our global placement and tracking system has successfully helped hundreds secure overseas jobs and visas — be the next success story.</p>
                        <a href="login" class="yellow_btn active_animation"><span>Book a consultation <i class="ph ph-arrow-right"></i></span></a>
                    </div>
                </div>
            </div><!-- End swiper-slide -->

            <div class="swiper-slide">
                <div class="slider_item" style="background-image:url(asset/img/slider/slider8.jpg);">
                    <div class="container">
                        <h1 class="heading active_animation">Secure a job before you fly!</h1>
                        <p class="active_animation">Browse verified jobs in Malta and Europe. Apply with ease and track your application in real time.</p>
                        <a href="login" class="yellow_btn active_animation"><span>View jobs <i class="ph ph-arrow-right"></i></span></a>
                    </div>
                </div>
            </div><!-- End swiper-slide -->

        </div>

        <div class="hs_prev_arrow harrow"><i class="ph ph-caret-left"></i></div>
        <div class="hs_next_arrow harrow"><i class="ph ph-caret-right"></i></div>

        <!--<img src="asset/img/icons/airplane-big.png" class="bplane wow fadeInUp" alt="plane">-->
    </div>
</section>
<!-- End Slider -->

<?php
$sql2 = "SELECT * 
FROM job
ORDER BY 
  CASE 
    WHEN job_id = 79 THEN 1
    WHEN job_id = 80 THEN 2
    WHEN job_id = 81 THEN 3
    WHEN job_id = 82 THEN 4
    ELSE 5
  END,
  RAND()
LIMIT 8;
";
$jobs = select_rows($sql2);
?>
<!-- Start Tour Category -->
<section class="travel_category pb100 wow fadeInUp" style="padding-top: 60px;">
    <div class="container">
        <div class="row">
            <div class="col-lg-7 col-md-8">
                <div class="section-heading">
                    <span>Live Job Openings</span>
                    <h2>Currently Available Jobs</h2>
                </div>
            </div>

            <div class="col-lg-5 col-md-4 text-md-end text-start mb-md-0 mb-5 align-self-center">
                <a href="jobs" class="yellow_btn AlCe"><span>Browse All</span></a>
            </div>
        </div>


        <div class="row g-4">

            <?php
            foreach ($jobs as $job) {
                $Title = $job['job_name'];
                $Image = $job['job_image'];
                $Country = $job['job_country'];
            ?>

                <div class="col-xl-3 col-md-6 col-12">
                    <a href="client/">
                        <div class="category_item text-center">
                            <img class="MyImage" src="asset/img/jobs/<?= $Image ?>" alt="">
                            <!-- <div class="t_number"><strong>40</strong><span>Trips</span></div> -->
                            <div class="tcat_content">
                                <span><?= $Country ?></span>
                                <h4><?= $Title ?></h4>
                            </div>
                        </div>
                    </a>
                </div><!-- End Col -->

            <?php
            }
            ?>
        </div>
    </div>
</section>
<!-- End Tour Category -->

<!-- Start About -->
<section class="tr_about">
    <div class="container">
        <div class="row">
            <div class="col-xl-6 wow fadeInLeft ">
                <div class="section-heading HiddenOnDesktop">
                    <span>About Us</span>
                    <h2>Trusted. Transparent. Tested.</h2>
                </div>
                <div>
                    <img src="asset/img/about/madam.jpg" style="border-radius: 10px;" />
                </div>
            </div><!-- End Col -->

            <div class="col-xl-6 align-self-center wow fadeInRight">
                <div class="about_content">
                    <div class="section-heading mb-3 HiddenOnMobile">
                        <span>About Us</span>
                        <h2>Trusted. Transparent. Tested.</h2>
                    </div>

                    <p>
                        At Watare Global Solutions, we specialize in helping Kenyans unlock global job opportunities through ethical recruitment, expert visa processing, and personalized support. With over 250 successful relocations in just one year, we’ve become a trusted bridge between local talent and international employers — especially in Malta, our flagship destination.
                    </p>
                    <p>
                        Whether you’re seeking greener pastures in Europe, applying for a work or study visa, or simply exploring new career horizons, we walk with you every step of the journey. Our team works hand-in-hand with clients to ensure their applications are complete, their documents are in order, and they are fully prepared for success abroad.
                    </p>

                    <div class="row mt-4 short_features">
                        <div class="col-xl-12 col-md-12 col-12">
                            <div class="sfeature_item">
                                <i class="ph ph-check-circle"></i>
                                <div class="sfcontent">
                                    <h4>250+ successful placements</h4>
                                    <p>Clients placed in jobs abroad through our recruitment process.</p>
                                </div>
                            </div>
                        </div><!-- End Col -->

                        <div class="col-xl-12 col-md-12 col-12">
                            <div class="sfeature_item">
                                <i class="ph ph-clock"></i>
                                <div class="sfcontent">
                                    <h4>6–9 month process timeline</h4>
                                    <p>Clear and transparent steps from consultation to relocation.</p>
                                </div>
                            </div>
                        </div><!-- End Col -->

                        <div class="col-xl-12 col-md-12 col-12">
                            <div class="sfeature_item">
                                <i class="ph ph-globe-stand"></i>
                                <div class="sfcontent">
                                    <h4>Global tracking system</h4>
                                    <p>Real-time updates throughout your visa or job application.</p>
                                </div>
                            </div>
                        </div><!-- End Col -->

                        <div class="col-xl-12 col-md-12 col-12">
                            <div class="sfeature_item">
                                <i class="ph ph-briefcase"></i>
                                <div class="sfcontent">
                                    <h4>Verified job listings</h4>
                                    <p>Access to real job openings through trusted employers.</p>
                                </div>
                            </div>
                        </div><!-- End Col -->

                        <div class="col-xl-12 col-md-12 col-12">
                            <div class="sfeature_item">
                                <i class="ph ph-currency-circle-dollar"></i>
                                <div class="sfcontent">
                                    <h4>Affordable consultation</h4>
                                    <p>Only Ksh. 2,000 to begin your journey with expert advice.</p>
                                </div>
                            </div>
                        </div><!-- End Col -->
                    </div><!-- End Row -->

                    <p class="mt-3">
                        We believe in honest processes, clear communication, and real results — because your future deserves more than promises.
                    </p>

                    <a href="about" class="yellow_btn mt-4  AlCe"><span>Discover More</span></a>
                </div>
            </div><!-- End Col -->

        </div>
    </div>
</section>
<!-- End About -->

<!-- Start Tour Packages -->
<section class="tour_packages fadeInUp">
    <div class="container">
        <div class="row">
            <div class="col-xl-12 text-center wow fadeInUp">
                <div class="section-heading" style="margin-bottom: 10px;">
                    <span>What We Offer</span>
                    <h2>Our Services</h2>
                </div>
            </div><!-- End Col -->

            <div class="col-xl-12">
                <div class="text-center">
                    <p>
                        We go beyond recruitment — we provide a complete support system that ensures your journey abroad is smooth, secure, and successful. Whether you're looking for a job, a visa, or long-term settlement, our team is here to walk with you every step of the way.
                    </p>

                </div>

                <div class="packages_wrap  wow fadeInUp">
                    <div class="row g-4 tour_items">

                        <!-- 1. Visa Consultation & Processing -->
                        <div class="col-xl-4 col-lg-6 col-12 mix new featured">
                            <div class="package_item">
                                <div class="pack_image">
                                    <img src="asset/img/tour/vs1.jpg" alt="Visa Consultation">

                                </div>
                                <div class="pack_content">
                                    <h3>1. Visa Consultation & Processing</h3>
                                    <p>We offer professional visa guidance and application support for:</p>
                                    <div class="pac_meta d-flex gap-2">
                                        <ul class="pmeta_item">
                                            <li>Work Visas</li>
                                            <li>Visit/Travel Visas</li>
                                            <li>Student Visas</li>
                                            <li>Temporary Residency Visas</li>
                                        </ul>
                                    </div>
                                    <p>We simplify the complex application process and ensure that all your documents are in order for a higher chance of approval.</p>

                                </div>
                            </div>
                        </div><!-- End Col -->

                        <!-- 2. Ethical Job Placement Abroad -->
                        <div class="col-xl-4 col-lg-6 col-12 mix new featured">
                            <div class="package_item">
                                <div class="pack_image">
                                    <img src="asset/img/tour/vs2.jpg" alt="Job Placement">

                                </div>
                                <div class="pack_content">
                                    <h3>2. Ethical Job Placement Abroad</h3>
                                    <p>We connect you to legitimate and verified job opportunities across Europe—especially in Malta, Germany, Croatia, and more.</p>
                                    <div class="pac_meta d-flex gap-2">
                                        <ul class="pmeta_item">
                                            <li>Hospitality</li>
                                            <li>Construction</li>
                                            <li>Warehouse roles</li>
                                            <li>And more</li>
                                        </ul>
                                    </div>
                                    <p>We match your skills to the right job with the right employer.</p>

                                </div>
                            </div>
                        </div><!-- End Col -->

                        <!-- 3. Interview Preparation -->
                        <div class="col-xl-4 col-lg-6 col-12 mix new featured">
                            <div class="package_item">
                                <div class="pack_image">
                                    <img src="asset/img/tour/vs3.jpg" alt="Interview Preparation">

                                </div>
                                <div class="pack_content">
                                    <h3>3. Interview Preparation</h3>
                                    <p>We train you on how to succeed in job interviews with foreign employers through:</p>
                                    <div class="pac_meta d-flex gap-2">
                                        <ul class="pmeta_item">
                                            <li>One-on-one coaching</li>
                                            <li>Mock interviews</li>
                                            <li>CV reviews and formatting</li>
                                        </ul>
                                    </div>
                                    <p>This boosts your confidence and increases your chances of getting hired.</p>

                                </div>
                            </div>
                        </div><!-- End Col -->

                        <!-- 4. Travel & Relocation Support -->
                        <div class="col-xl-4 col-lg-6 col-12 mix new featured">
                            <div class="package_item">
                                <div class="pack_image">
                                    <img src="asset/img/tour/vs4.jpg" alt="Travel Support">

                                </div>
                                <div class="pack_content">
                                    <h3>4. Travel & Relocation Support</h3>
                                    <p>Once your visa is approved and job secured, we assist you with:</p>
                                    <div class="pac_meta d-flex gap-2">
                                        <ul class="pmeta_item">
                                            <li>Pre-departure orientation</li>
                                            <li>Travel bookings and flight coordination</li>
                                            <li>Arrival planning and accommodation advice</li>
                                        </ul>
                                    </div>
                                    <p>We make sure your transition to a new country is stress-free.</p>

                                </div>
                            </div>
                        </div><!-- End Col -->

                        <!-- 5. Global Tracking Portal Access -->
                        <div class="col-xl-4 col-lg-6 col-12 mix new featured">
                            <div class="package_item">
                                <div class="pack_image">
                                    <img src="asset/img/tour/vs5.jpg" alt="Tracking Portal">

                                </div>
                                <div class="pack_content">
                                    <h3>5. Global Tracking Portal Access</h3>
                                    <p>Once you sign up, you gain access to our Global Tracking System, where you can:</p>
                                    <div class="pac_meta d-flex gap-2">
                                        <ul class="pmeta_item">
                                            <li>Apply for available jobs</li>
                                            <li>Track your visa and job application status</li>
                                            <li>Get notified on required documents or next steps</li>
                                            <li>Stay updated with real-time progress reports</li>
                                        </ul>
                                    </div>
                                    <p>This level of transparency gives you full control of your journey.</p>

                                </div>
                            </div>
                        </div><!-- End Col -->

                        <!-- 6. Post-Arrival Guidance & Community Support -->
                        <div class="col-xl-4 col-lg-6 col-12 mix new featured">
                            <div class="package_item">
                                <div class="pack_image">
                                    <img src="asset/img/tour/vs6.jpg" alt="Post Arrival Support">

                                </div>
                                <div class="pack_content">
                                    <h3>6. Post-Arrival Guidance & Community Support</h3>
                                    <p>Even after you've landed, we continue to support you with:</p>
                                    <div class="pac_meta d-flex gap-2">
                                        <ul class="pmeta_item">
                                            <li>Settlement tips</li>
                                            <li>Language or cultural orientation</li>
                                            <li>Emergency contacts in your destination</li>
                                            <li>Networking with other Kenyans abroad</li>
                                        </ul>
                                    </div>
                                    <p>We care about your success, not just your placement.</p>

                                </div>
                            </div>
                        </div><!-- End Col -->

                    </div>
                </div>

            </div>
        </div>
    </div>
</section>
<!-- End Tour Packages -->


<section class="crm-overview-section py-5">
    <div class="container">
        <div class="section-title text-center mb-4">
            <h2>Quick Software Overview</h2>
            <p class="text-muted">Take a quick look at our CRM in action</p>
        </div>

        <!-- Slider wrapper -->
        <div class="swiper crmSwiper">
            <div class="swiper-wrapper">
                <!-- Slide 1 -->
                <div class="swiper-slide">
                    <img src="asset/img/slider/sys4.png" class="img-fluid rounded shadow" alt="CRM Screenshot 1">
                </div>

                <!-- Slide 2 -->
                <div class="swiper-slide">
                    <img src="asset/img/slider/sys3.png" class="img-fluid rounded shadow" alt="CRM Screenshot 2">
                </div>

                <div class="swiper-slide">
                    <img src="asset/img/slider/sys6.png" class="img-fluid rounded shadow" alt="CRM Screenshot 2">
                </div>

                <div class="swiper-slide">
                    <img src="asset/img/slider/sys1.png" class="img-fluid rounded shadow" alt="CRM Screenshot 2">
                </div>

                <div class="swiper-slide">
                    <img src="asset/img/slider/sys2.png" class="img-fluid rounded shadow" alt="CRM Screenshot 2">
                </div>

                <div class="swiper-slide">
                    <img src="asset/img/slider/sys5.png" class="img-fluid rounded shadow" alt="CRM Screenshot 2">
                </div>

                <div class="swiper-slide">
                    <img src="asset/img/slider/sys7.png" class="img-fluid rounded shadow" alt="CRM Screenshot 2">
                </div>

                <!-- Add more slides as needed -->
            </div>

            <!-- Swiper Navigation -->
            <div class="swiper-button-next"></div>
            <div class="swiper-button-prev"></div>

            <!-- Optional Pagination -->
            <div class="swiper-pagination"></div>
        </div>
    </div>
</section>


<!-- Start Features -->
<section class="features section-padding wow fadeInUp">
    <div class="container">
        <div class="row">
            <div class="col-12 wow fadeInUp">
                <div class="section-heading text-center">
                    <span>Special Features</span>
                    <h2>Global Tracking System</h2>
                    <h5>Stay informed. Stay empowered. Stay in control.</h5>
                    <p>
                        Transparency is one of our core values — and that’s why we’ve invested in a powerful Global Tracking System that gives every client direct access to their journey in real time. Whether you’re applying for a visa, securing a job, or submitting documents, our tracking system ensures you always know what stage you're at, what is pending, and what comes next.
                    </p>

                </div>
            </div>
        </div>

        <div class="row g-4">
            <!-- 1. Track Your Visa & Job Application Progress -->
            <div class="col-xl-4 col-md-6 col-12 wow fadeInUp">
                <div class="feature_item ">
                    <i class="ph ph-check-circle"></i>
                    <div class="feature_content">
                        <h3>Track your visa & job application progress</h3>
                        <p>No more guessing games or waiting for updates. From submission to approval, you can view each stage of your visa or job application — including timelines and what actions are required on your end.</p>
                    </div>
                </div>
            </div><!-- End Col -->

            <!-- 2. Browse & Apply for Jobs Instantly -->
            <div class="col-xl-4 col-md-6 col-12 wow fadeInUp">
                <div class="feature_item ">
                    <i class="ph ph-briefcase"></i>
                    <div class="feature_content">
                        <h3>Browse & apply for jobs instantly</h3>
                        <p>Get access to verified and up-to-date job listings across Malta, Germany, and other European countries. Apply directly through the portal and see your application status anytime.</p>
                    </div>
                </div>
            </div><!-- End Col -->

            <!-- 3. Upload & Manage Required Documents -->
            <div class="col-xl-4 col-md-6 col-12 wow fadeInUp">
                <div class="feature_item ">
                    <i class="ph ph-folder-simple-plus"></i>
                    <div class="feature_content">
                        <h3>Upload & manage required documents</h3>
                        <p>Easily upload your passport, CV, certificates, police clearance, and other necessary documents. You'll also be alerted if anything is missing or needs correction.</p>
                    </div>
                </div>
            </div><!-- End Col -->

            <!-- 4. Get Real-Time Notifications -->
            <div class="col-xl-4 col-md-6 col-12 wow fadeInUp">
                <div class="feature_item ">
                    <i class="ph ph-bell-ringing"></i>
                    <div class="feature_content">
                        <h3>Get real-time notifications</h3>
                        <p>You’ll receive SMS and email updates when your visa application is submitted, a job interview is scheduled, additional documents are needed, or your application status changes.</p>
                    </div>
                </div>
            </div><!-- End Col -->

            <!-- 5. Secure Messaging & Support -->
            <div class="col-xl-4 col-md-6 col-12 wow fadeInUp">
                <div class="feature_item ">
                    <i class="ph ph-chat-centered-dots"></i>
                    <div class="feature_content">
                        <h3>Secure messaging & support</h3>
                        <p>Communicate directly with our processing team within the portal if you need help, updates, or clarifications.</p>
                    </div>
                </div>
            </div><!-- End Col -->

            <!-- 6. View Payment Records & Receipts -->
            <div class="col-xl-4 col-md-6 col-12 wow fadeInUp">
                <div class="feature_item ">
                    <i class="ph ph-receipt"></i>
                    <div class="feature_content">
                        <h3>View payment records & receipts</h3>
                        <p>Track your consultation fee payment, document processing fees, and any service payments you’ve made — with official downloadable receipts for every transaction.</p>
                    </div>
                </div>
            </div><!-- End Col -->

        </div>
    </div>
</section>
<!-- End Features -->

<section class="py-5">
    <div class="container">
        <div class="text-center mb-4">
            <h2 class="fw-bold" style="color:#2d286a">Frequently Asked Questions (FAQs)</h2>
            <p class="lead">Everything you need to know before you begin your journey abroad</p>
            <p>We've compiled answers to the most common questions asked by clients planning to work or travel abroad. If you’re just starting out, this section will guide you through what to expect — from visa processing to job placement, timelines, and more.</p>
        </div>
        <div class="row">
            <div class="col-lg-6 col-md-6 col-sm-12 col-12">
                <h4 style="text-align: center;color:#2d286a">
                    Visa Application FAQs
                </h4>

                <div class="accordion" id="faqAccordion">
                    <!-- FAQ 1 -->
                    <div class="accordion-item" style="background-color: #e0f0ff;">
                        <h2 class="accordion-header" id="headingOne">
                            <button class="accordion-button collapsed fw-semibold" type="button" data-bs-toggle="collapse" data-bs-target="#collapseOne">
                                <i class="ph ph-question text-danger me-2"></i>
                                What types of visas can I apply for through your agency?
                            </button>
                        </h2>
                        <div id="collapseOne" class="accordion-collapse collapse" data-bs-parent="#faqAccordion">
                            <div class="accordion-body">
                                We assist clients with a wide range of visa categories, including:
                                <ul>
                                    <li>Work Visas</li>
                                    <li>Student Visas</li>
                                    <li>Visit/Travel Visas</li>
                                    <li>Temporary Residence Visas</li>
                                    <li>Internship or Training Visas</li>
                                </ul>
                                Our team will guide you on which visa suits your goals and profile.
                            </div>
                        </div>
                    </div>

                    <!-- FAQ 2 -->
                    <div class="accordion-item mt-3" style="background-color: #e0f0ff;">
                        <h2 class="accordion-header" id="headingTwo">
                            <button class="accordion-button collapsed fw-semibold" type="button" data-bs-toggle="collapse" data-bs-target="#collapseTwo">
                                <i class="ph ph-question text-danger me-2"></i>
                                How long does it take to process a visa to Malta?
                            </button>
                        </h2>
                        <div id="collapseTwo" class="accordion-collapse collapse" data-bs-parent="#faqAccordion">
                            <div class="accordion-body">
                                On average, the Malta visa process takes 6 to 9 working months, depending on the job type, document readiness, and embassy timelines. We keep you updated at every stage.
                            </div>
                        </div>
                    </div>

                    <!-- FAQ 3 -->
                    <div class="accordion-item mt-3" style="background-color: #e0f0ff;">
                        <h2 class="accordion-header" id="headingThree">
                            <button class="accordion-button collapsed fw-semibold" type="button" data-bs-toggle="collapse" data-bs-target="#collapseThree">
                                <i class="ph ph-question text-danger me-2"></i>
                                Do I need a job offer before I apply for a visa?
                            </button>
                        </h2>
                        <div id="collapseThree" class="accordion-collapse collapse" data-bs-parent="#faqAccordion">
                            <div class="accordion-body">
                                Yes. For work visa processing, a valid job offer or employment contract is required. We assist in connecting you to legitimate job opportunities before the visa process begins.
                            </div>
                        </div>
                    </div>

                    <!-- FAQ 4 -->
                    <div class="accordion-item mt-3" style="background-color: #e0f0ff;">
                        <h2 class="accordion-header" id="headingFour">
                            <button class="accordion-button collapsed fw-semibold" type="button" data-bs-toggle="collapse" data-bs-target="#collapseFour">
                                <i class="ph ph-question text-danger me-2"></i>
                                Will you help me with the visa interview?
                            </button>
                        </h2>
                        <div id="collapseFour" class="accordion-collapse collapse" data-bs-parent="#faqAccordion">
                            <div class="accordion-body">
                                Absolutely. We provide full visa interview preparation, including mock sessions, expected questions, and tips on how to present yourself professionally.
                            </div>
                        </div>
                    </div>

                    <!-- FAQ 5 -->
                    <div class="accordion-item mt-3" style="background-color: #e0f0ff;">
                        <h2 class="accordion-header" id="headingFive">
                            <button class="accordion-button collapsed fw-semibold" type="button" data-bs-toggle="collapse" data-bs-target="#collapseFive">
                                <i class="ph ph-question text-danger me-2"></i>
                                Can I apply for a visa if I don't have a passport yet?
                            </button>
                        </h2>
                        <div id="collapseFive" class="accordion-collapse collapse" data-bs-parent="#faqAccordion">
                            <div class="accordion-body">
                                You need a valid Kenyan passport to begin the visa application. If you don’t have one, we can guide you on how to apply for it at your nearest immigration office.
                            </div>
                        </div>
                    </div>

                    <!-- FAQ 6 -->
                    <div class="accordion-item mt-3" style="background-color: #e0f0ff;">
                        <h2 class="accordion-header" id="headingSix">
                            <button class="accordion-button collapsed fw-semibold" type="button" data-bs-toggle="collapse" data-bs-target="#collapseSix">
                                <i class="ph ph-question text-danger me-2"></i>
                                Do you offer visa services for countries outside of Malta?
                            </button>
                        </h2>
                        <div id="collapseSix" class="accordion-collapse collapse" data-bs-parent="#faqAccordion">
                            <div class="accordion-body">
                                Yes. While Malta is our flagship destination, we also assist clients applying for visas to countries such as Germany, Croatia, Montenegro, Belgium, and more.
                            </div>
                        </div>
                    </div>

                    <!-- FAQ 7 -->
                    <div class="accordion-item mt-3" style="background-color: #e0f0ff;">
                        <h2 class="accordion-header" id="headingSeven">
                            <button class="accordion-button collapsed fw-semibold" type="button" data-bs-toggle="collapse" data-bs-target="#collapseSeven">
                                <i class="ph ph-question text-danger me-2"></i>
                                What if my visa is denied?
                            </button>
                        </h2>
                        <div id="collapseSeven" class="accordion-collapse collapse" data-bs-parent="#faqAccordion">
                            <div class="accordion-body">
                                We review each case individually. If denied, we help you understand the reason and offer guidance on reapplication, appeal, or alternative opportunities.
                            </div>
                        </div>
                    </div>

                    <!-- FAQ 8 -->
                    <div class="accordion-item mt-3" style="background-color: #e0f0ff;">
                        <h2 class="accordion-header" id="headingEight">
                            <button class="accordion-button collapsed fw-semibold" type="button" data-bs-toggle="collapse" data-bs-target="#collapseEight">
                                <i class="ph ph-question text-danger me-2"></i>
                                What is the consultation fee, and what does it cover?
                            </button>
                        </h2>
                        <div id="collapseEight" class="accordion-collapse collapse" data-bs-parent="#faqAccordion">
                            <div class="accordion-body">
                                We charge a Ksh. 2,000 consultation fee, which covers:
                                <ul>
                                    <li>One-on-one eligibility assessment</li>
                                    <li>Career and visa pathway guidance</li>
                                    <li>Introduction to available jobs</li>
                                    <li>Access to our tracking portal</li>
                                    <li>Documentation checklist and next steps</li>
                                </ul>
                            </div>
                        </div>
                    </div>

                </div>
            </div>
            <div class="col-lg-6 col-md-6 col-sm-12 col-12">

                <h4 class="FAQh" style="text-align: center;color:#2d286a">
                    Working Abroad FAQs
                </h4>

                <div class="accordion">
                    <!-- FAQ - Terms and Conditions with Host -->
<div class="accordion-item mt-3" style="background-color: #e0f0ff;">
    <h2 class="accordion-header" id="headingHostTerms">
        <button class="accordion-button collapsed fw-semibold" type="button" data-bs-toggle="collapse" data-bs-target="#collapseHostTerms">
            <i class="ph ph-question text-danger me-2"></i>
            What are the terms and conditions with the host once I arrive?
        </button>
    </h2>
    <div id="collapseHostTerms" class="accordion-collapse collapse" data-bs-parent="#faqAccordion">
        <div class="accordion-body">
            The terms and conditions depend on the mutual agreement between you and your host. The amount you pay is valid for one month, as it's expected that you will begin working within the first few days of arrival. The job typically includes in-house accommodation.
            <br><br>
            However, if your situation is different and you are unable to start work immediately, rest assured — the host will not evict you. Instead, you will come to a mutual agreement regarding how to split household bills or create a payment plan once you begin earning.
        </div>
    </div>
</div>

<!-- FAQ - Job Guarantee and Documentation -->
<div class="accordion-item mt-3" style="background-color: #e0f0ff;">
    <h2 class="accordion-header" id="headingJobGuarantee">
        <button class="accordion-button collapsed fw-semibold" type="button" data-bs-toggle="collapse" data-bs-target="#collapseJobGuarantee">
            <i class="ph ph-question text-danger me-2"></i>
            Are the jobs guaranteed? Will I receive ID cards and proper documentation to stay legal?
        </button>
    </h2>
    <div id="collapseJobGuarantee" class="accordion-collapse collapse" data-bs-parent="#faqAccordion">
        <div class="accordion-body">
            Yes, the “chini ya maji” (informal) jobs are guaranteed. However, maintaining the job will also depend on your work ethic, personality, and adaptability. Your host will support your initial settlement and help you integrate.
            <br><br>
            As for documentation, please refer to FAQ 1 regarding your initial setup. While formal work permits may not be part of these roles, your host will provide local guidance to ensure you're not exposed to unnecessary risks.
        </div>
    </div>
</div>

<!-- FAQ - UK Immigrant Restrictions -->
<div class="accordion-item mt-3" style="background-color: #e0f0ff;">
    <h2 class="accordion-header" id="headingUKRestrictions">
        <button class="accordion-button collapsed fw-semibold" type="button" data-bs-toggle="collapse" data-bs-target="#collapseUKRestrictions">
            <i class="ph ph-question text-danger me-2"></i>
            We’ve heard of immigrants in the UK who cannot leave the country. Why is that?
        </button>
    </h2>
    <div id="collapseUKRestrictions" class="accordion-collapse collapse" data-bs-parent="#faqAccordion">
        <div class="accordion-body">
            This can happen for a few reasons, especially for those who entered or are working without proper documentation. In such cases, leaving the country voluntarily may lead to complications, or re-entry bans, and returning legally becomes difficult.
            <br><br>
            That’s why we emphasize understanding the risks and responsibilities involved in informal work arrangements — and we do our best to prepare and support you with accurate information before your departure.
        </div>
    </div>
</div>

                    <!-- FAQ 1 -->
                    <div class="accordion-item mt-3" style="background-color: #e0f0ff;">
                        <h2 class="accordion-header" id="headingJobOne">
                            <button class="accordion-button collapsed fw-semibold" type="button" data-bs-toggle="collapse" data-bs-target="#collapseJobOne">
                                <i class="ph ph-question text-danger me-2"></i>
                                What countries do you place candidates in?
                            </button>
                        </h2>
                        <div id="collapseJobOne" class="accordion-collapse collapse" data-bs-parent="#faqAccordion">
                            <div class="accordion-body">
                                Currently, we recruit for job opportunities in Malta, the UK, and other European countries — with more destinations being added regularly.
                            </div>
                        </div>
                    </div>

                    <!-- FAQ 2 -->
                    <div class="accordion-item mt-3" style="background-color: #e0f0ff;">
                        <h2 class="accordion-header" id="headingJobTwo">
                            <button class="accordion-button collapsed fw-semibold" type="button" data-bs-toggle="collapse" data-bs-target="#collapseJobTwo">
                                <i class="ph ph-question text-danger me-2"></i>
                                Do I need experience to get a job abroad?
                            </button>
                        </h2>
                        <div id="collapseJobTwo" class="accordion-collapse collapse" data-bs-parent="#faqAccordion">
                            <div class="accordion-body">
                                Not always. Some jobs (e.g., warehouse, general cleaning) require little to no prior experience, while others (like hospitality or healthcare) may require relevant work history or certifications.
                            </div>
                        </div>
                    </div>

                    <!-- FAQ 3 -->
                    <div class="accordion-item mt-3" style="background-color: #e0f0ff;">
                        <h2 class="accordion-header" id="headingJobThree">
                            <button class="accordion-button collapsed fw-semibold" type="button" data-bs-toggle="collapse" data-bs-target="#collapseJobThree">
                                <i class="ph ph-question text-danger me-2"></i>
                                Can I go abroad with my family?
                            </button>
                        </h2>
                        <div id="collapseJobThree" class="accordion-collapse collapse" data-bs-parent="#faqAccordion">
                            <div class="accordion-body">
                                In some cases, yes. For long-term or skilled work visas, family reunification may be possible after you’ve settled abroad. We'll guide you through what’s allowed by the destination country.
                            </div>
                        </div>
                    </div>

                    <!-- FAQ 4 -->
                    <div class="accordion-item mt-3" style="background-color: #e0f0ff;">
                        <h2 class="accordion-header" id="headingJobFour">
                            <button class="accordion-button collapsed fw-semibold" type="button" data-bs-toggle="collapse" data-bs-target="#collapseJobFour">
                                <i class="ph ph-question text-danger me-2"></i>
                                Are the jobs permanent or temporary?
                            </button>
                        </h2>
                        <div id="collapseJobFour" class="accordion-collapse collapse" data-bs-parent="#faqAccordion">
                            <div class="accordion-body">
                                Most opportunities are contract-based, typically lasting 6 months to 2 years, with the possibility of renewal or permanent placement depending on employer performance reviews.
                            </div>
                        </div>
                    </div>

                    <!-- FAQ 5 -->
                    <div class="accordion-item mt-3" style="background-color: #e0f0ff;">
                        <h2 class="accordion-header" id="headingJobFive">
                            <button class="accordion-button collapsed fw-semibold" type="button" data-bs-toggle="collapse" data-bs-target="#collapseJobFive">
                                <i class="ph ph-question text-danger me-2"></i>
                                Do you offer jobs to both men and women?
                            </button>
                        </h2>
                        <div id="collapseJobFive" class="accordion-collapse collapse" data-bs-parent="#faqAccordion">
                            <div class="accordion-body">
                                Yes. We recruit both male and female candidates. Some roles, such as hospitality and cleaning, are open to women, while others like construction or logistics are typically male-dominated — but all roles are based on skill, not gender.
                            </div>
                        </div>
                    </div>

                    <!-- FAQ 6 -->
                    <div class="accordion-item mt-3" style="background-color: #e0f0ff;">
                        <h2 class="accordion-header" id="headingJobSix">
                            <button class="accordion-button collapsed fw-semibold" type="button" data-bs-toggle="collapse" data-bs-target="#collapseJobSix">
                                <i class="ph ph-question text-danger me-2"></i>
                                Is accommodation provided for the jobs abroad?
                            </button>
                        </h2>
                        <div id="collapseJobSix" class="accordion-collapse collapse" data-bs-parent="#faqAccordion">
                            <div class="accordion-body">
                                Most of our partnered employers offer accommodation or a housing allowance. Specific details vary from job to job, and we share this information during the application process.
                            </div>
                        </div>
                    </div>

                    <!-- FAQ 7 -->
                    <div class="accordion-item mt-3" style="background-color: #e0f0ff;">
                        <h2 class="accordion-header" id="headingJobSeven">
                            <button class="accordion-button collapsed fw-semibold" type="button" data-bs-toggle="collapse" data-bs-target="#collapseJobSeven">
                                <i class="ph ph-question text-danger me-2"></i>
                                Will I be assisted after I travel?
                            </button>
                        </h2>
                        <div id="collapseJobSeven" class="accordion-collapse collapse" data-bs-parent="#faqAccordion">
                            <div class="accordion-body">
                                Yes. We provide post-arrival guidance, connect you to local communities, and remain available for support even after you’ve left Kenya.
                            </div>
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </div>
</section>



<style>
    .pack_content p {
        color: white;
    }

    .pmeta_item {
        color: white;
    }

    .feature_item {
        height: 320px;
    }

    .package_item {
        height: 650px;
    }

    @media screen and (max-width:600px) {
        .feature_item {
            height: auto;
        }

        .package_item {
            height: auto;
            margin-top: 20px;
        }

        .FAQh {
            margin-top: 40px;
        }
    }

    .crm-overview-section {
        background-color: #f9f9f9;
        margin-top: 60px;
    }

    .crmSwiper .swiper-wrapper .swiper {
        width: 100%;
        max-width: 900px;
        margin: auto;
    }

    .crmSwiper .swiper-wrapper .swiper-slide img {
        width: 80%;
        height: auto;
        object-fit: contain;
        border-radius: 8px;
        display: block;
        margin: auto;
    }

    .swiper-button-next:after,
    .swiper-rtl .swiper-button-prev:after {
        color: #2d286a;
    }
    

</style>

<script>
    const swiper = new Swiper('.crmSwiper', {
        slidesPerView: 1,
        spaceBetween: 30,
        loop: true,
        pagination: {
            el: '.swiper-pagination',
            clickable: true,
        },
        navigation: {
            nextEl: '.swiper-button-next',
            prevEl: '.swiper-button-prev',
        },
    });
</script>


<?php include_once 'footer.php'; ?>