<?php
$page        = 'uploads';
$header_name = 'Uploads';

require_once '../path.php';
require_once 'header.php';



$column_indexes = range(0, $num_columns - 1);

$upload = $uploads[0];
// Create an array of column definition objects

$column_defs = array(
    array('data' => 'user_email', 'title' => 'Unique Code'),
    array('data' => 'col1_' . $i, 'title' => 'CV'),
    array('data' => 'col2_' . $i, 'title' => 'Passport Photo'),
    array('data' => 'col4_' . $i, 'title' => 'Full photo'),
    array('data' => 'col3_' . $i, 'title' => 'Passport bio page'),
    array('data' => 'col5_' . $i, 'title' => 'Actions'),
);

$num_columns = sizeof($column_defs);
$column_indexes = range(0, $num_columns - 1);


?>
<div class="container-xxl flex-grow-1 container-p-y">
    <h4 class="fw-bold py-3 mb-4"><span class="text-muted fw-light">Your</span> Documents</h4>

    <!--  -->
    <div class="card">
        <div class="card-datatable table-responsive">
            <table class="datatables-basic table border-top">
                <thead>
                    <tr>
                        <?php foreach ($column_defs as $col): ?>
                            <th><?= htmlspecialchars($col['title']) ?></th>
                        <?php endforeach; ?>
                    </tr>
                </thead>
                <tbody>
                    <?php
                    if (!empty($upload)) { ?>
                        <tr>
                            <td> <?= $upload['upload_code'] ?> </td>
                            <td>
                                <a href="<?= file_url . $upload['upload_cv'] ?>" target="_blank">
                                    <img
                                        src="<?= base_url ?>assets/img/icons/misc/pdf.png"
                                        alt="PDF image"
                                        width="15"
                                        class="me-2" />
                                    <span class="fw-bold text-body">Download CV</span>
                                </a>
                            </td>
                            <td>
                                <img
                                    src="<?= image_url . $upload['upload_passport'] ?>"
                                    alt="PDF image"
                                    style="width: 80px;border-radius:10px;"
                                    class="me-2" />
                            </td>
                            <td>
                                <img
                                    src="<?= image_url . $upload['upload_full'] ?>"
                                    alt="PDF image"
                                    style="width: 80px;border-radius:10px;"
                                    class="me-2" />
                            </td>
                            <td>
                                <a href="<?= file_url . $upload['upload_bio'] ?>" target="_blank">
                                    <img
                                        src="<?= base_url ?>assets/img/icons/misc/pdf.png"
                                        alt="PDF image"
                                        width="15"
                                        class="me-2" />
                                    <span class="fw-bold text-body">Download This File</span>
                                </a>
                            </td>

                            <td>
                                <a href="#" class="btn btn-info">
                                    <i class="fa-solid fa-eye"></i>
                                </a>

                                <a href="#" class="btn btn-danger">
                                    <i class="fa-solid fa-trash-can-arrow-up"></i>
                                </a>
                            </td>
                        </tr>
                    <?php
                    } else {
                        echo '<tr>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td></td>
                        </tr>';
                    }
                    ?>
                </tbody>

            </table>
        </div>
    </div>
</div>
<!-- container-fluid -->

<!-- End of Main Content -->
<?php include_once 'footer.php'; ?>