<?php
$page        = 'docs';
$header_name = 'Clients';

require_once '../path.php';
require_once 'header.php';

$bookings = get_all('booking');

$column_indexes = range(0, $num_columns - 1);

// Create an array of column definition objects

$column_defs = array(
    array('data' => '', 'title' => 'S.no'),
    array('data' => 'col_' . $i, 'title' => 'S.no'),
    array('data' => 'user_name', 'title' => 'Name'),
    array('data' => 'user_emailx', 'title' => 'Email'),
    array('data' => 'user_phones', 'title' => 'Phone'),
    array('data' => 'user_phoness', 'title' => 'Date'),
    array('data' => '', 'title' => 'Action')
);

$num_columns = sizeof($column_defs);
$column_indexes = range(0, $num_columns - 1);

?>
<div class="container-xxl flex-grow-1 container-p-y">
    <h4 class="fw-bold py-3 mb-4"><span class="text-muted fw-light">View</span> Bookings</h4>

    <!--  -->
    <div class="card">
        <div class="card-datatable table-responsive">
            <table class="datatables-basic table border-top">
                <thead>
                    <tr>
                        <?php foreach ($column_defs as $col): ?>
                            <th><?= htmlspecialchars($col['title']) ?></th>
                        <?php endforeach; ?>
                    </tr>
                </thead>
                <tbody>
                    <?php
                    $cnt = 1;
                    foreach ($bookings as $booking) {
                        $booking_id = encrypt($booking['booking_id']);
                        $user = get_by_id('user', $booking['user_id']);
                    ?>
                        <tr>
                            <td></td>
                            <td><?= $cnt ?></td>

                            <td> <?= $user['user_name'] ?> </td>
                            <td> <?= $user['user_email'] ?> </td>
                            <td> <?= $user['user_phone'] ?> </td>
                            <td> <?= get_ordinal_day_month_year($booking['booking_date']) ?> </td>

                            <td>
                                <a href="user?id=<?= encrypt($user['user_id']) ?>" class="btn btn-info">
                                    <i class="fa-solid fa-eye"></i>
                                </a>

                                <a href="#" class="btn btn-danger">
                                    <i class="fa-solid fa-trash-can-arrow-up"></i>
                                </a>
                            </td>

                        </tr>
                    <?php
                        $cnt++;
                    }
                    ?>
                </tbody>

            </table>
        </div>
    </div>
</div>
<!-- container-fluid -->

<!-- End of Main Content -->
<?php include_once 'footer.php'; ?>