<?php
$page = 'start';
include_once 'header.php' ?>
<div class="container-xxl flex-grow-1 container-p-y">
    <div class="faq-header d-flex flex-column justify-content-center align-items-center">
        <h3 class="text-center" style="color:black;font-weight:800;">Hello, start your application here</h3>

        <p class="text-center mb-0 px-3">Read through the steps on how to apply to Watare Global below or simply press Start Your Application</p>

        <a href="apply" class="btn rounded-pill btn-outline-primary" style="width: 200px;margin-top:20px;">
            Start Your Application
        </a>
    </div>

    <div class="row mt-4">
        <!-- Navigation -->
        <div class="col-lg-3 col-md-4 col-12 mb-md-0 mb-3">
            <div class="d-flex justify-content-between flex-column mb-2 mb-md-0">
                <ul class="nav nav-align-left nav-pills flex-column">
                    <li class="nav-item">
                        <button class="nav-link active" data-bs-toggle="tab" data-bs-target="#product">
                            <i class="bx bx-cog faq-nav-icon me-1"></i>
                            <span class="align-middle">Getting Started</span>
                        </button>
                    </li>
                    <li class="nav-item">
                        <button class="nav-link" data-bs-toggle="tab" data-bs-target="#payment">
                            <i class="bx bx-credit-card faq-nav-icon me-1"></i>
                            <span class="align-middle">Payment</span>
                        </button>
                    </li>
                    <li class="nav-item">
                        <button class="nav-link" data-bs-toggle="tab" data-bs-target="#cancellation">
                            <i class="bx bx-rotate-left faq-nav-icon me-1"></i>
                            <span class="align-middle">Tracking Progress
                            </span>
                        </button>
                    </li>
                    <li class="nav-item">
                        <button class="nav-link" data-bs-toggle="tab" data-bs-target="#delivery">
                            <i class="bx bx-shopping-bag faq-nav-icon me-1"></i>
                            <span class="align-middle">Travel Arrangements</span>
                        </button>
                    </li>


                </ul>
                <div class="d-none d-md-block">
                    <div class="mt-5">
                        <img
                            src="<?= base_url ?>assets/img/illustrations/sitting-girl-with-laptop-light.png"
                            class="img-fluid w-px-200"
                            alt="FAQ Image"
                            data-app-light-img="illustrations/sitting-girl-with-laptop-light.png"
                            data-app-dark-img="illustrations/sitting-girl-with-laptop-dark.png" />
                    </div>
                </div>
            </div>
        </div>
        <!-- /Navigation -->

        <!-- FAQ's -->
        <div class="col-lg-9 col-md-8 col-12">
            <div class="tab-content py-0">
                <div class="tab-pane fade  show active" id="product" role="tabpanel">
                    <div class="d-flex mb-3 gap-3">
                        <div>
                            <span class="badge bg-label-primary rounded-2">
                                <i class="bx bx-camera bx-md"></i>
                            </span>
                        </div>
                        <div>
                            <h4 class="mb-0">
                                <span class="align-middle">Getting Started</span>
                            </h4>
                            <span>Begin your journey with us in just a few steps.</span>
                        </div>
                    </div>
                    <div id="accordionProduct" class="accordion">
                        <div class="card">
                            <div id="accordionProduct-1" class="accordion-collapse collapse show">
                                <div class="accordion-body">
                                    <p>
                                        Create an account or log in, fill out your application form with accurate details, and choose the service package that fits your needs—be it travel, accommodation, or career placement.
                                        Ensure you have your valid identification, travel documents (like a passport), academic or professional certificates (if applying for jobs), and any other relevant materials.
                                        We'll let you know exactly what’s needed based on your chosen service.
                                    </p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="tab-pane fade" id="payment" role="tabpanel">
                    <div class="d-flex mb-3 gap-3">
                        <div>
                            <span class="badge bg-label-primary rounded-2">
                                <i class="bx bx-credit-card bx-md"></i>
                            </span>
                        </div>
                        <div>
                            <h4 class="mb-0">
                                <span class="align-middle">Payment</span>
                            </h4>
                            <span>Secure and flexible payment options.</span>
                        </div>
                    </div>
                    <div id="accordionPayment" class="accordion">
                        <div class="card accordion-item">

                            <div id="accordionPayment-1" class="accordion-collapse collapse show">
                                <div class="accordion-body">
                                    <p>
                                        Once your application is reviewed, you’ll receive an invoice. You can pay via mobile money. A confirmation will be sent once payment is verified.
                                        Copy the M-Pesa or Airtel Money message and paste it in the appropriate form.
                                    </p>
                                </div>
                            </div>
                        </div>

                    </div>
                </div>

                <div class="tab-pane fade" id="cancellation" role="tabpanel">
                    <div class="d-flex mb-3 gap-3">
                        <div>
                            <span class="badge bg-label-primary rounded-2">
                                <i class="bx bx-revision bx-md"></i>
                            </span>
                        </div>
                        <div>
                            <h4 class="mb-0"><span class="align-middle">Tracking Progress</span></h4>
                            <span>Stay updated every step of the way.</span>
                        </div>
                    </div>
                    <div id="accordionCancellation" class="accordion">
                        <div class="card accordion-item">


                            <div id="accordionCancellation-1" class="accordion-collapse collapse show">
                                <div class="accordion-body">
                                    <p>
                                        Log into your dashboard anytime to check your application status, receive updates, or chat with a Watare support agent if you have questions. We believe in full transparency.
                                    </p>
                                </div>
                            </div>
                        </div>

                    </div>
                </div>

                <div class="tab-pane fade" id="delivery" role="tabpanel">
                    <div class="d-flex mb-3 gap-3">
                        <div>
                            <span class="badge bg-label-primary rounded-2">
                                <i class="bx bx-cart bx-md"></i>
                            </span>
                        </div>
                        <div>
                            <h4 class="mb-0">
                                <span class="align-middle">Travel & Accommodation Arrangements</span>
                            </h4>
                            <span>Let us handle the logistics.</span>
                        </div>
                    </div>
                    <div id="accordionDelivery" class="accordion">
                        <div class="card accordion-item">


                            <div id="accordionDelivery-1" class="accordion-collapse collapse show">
                                <div class="accordion-body">
                                    <p>
                                        If your service includes job placement, we offer interview coaching, CV reviews, and personalized tips to help you shine in your interviews with international employers.
                                        Once approved, we’ll coordinate your flights, visas, and accommodation bookings. All details will be shared in advance, and support remains available throughout your transition.
                                    </p>
                                </div>
                            </div>
                        </div>

                    </div>
                </div>

            </div>
        </div>
        <!-- /FAQ's -->
        <a href="apply" class="btn rounded-pill btn-outline-primary" style="width: 200px;margin-top:20px;">
            Get Started Now
        </a>
    </div>


</div>
<!-- / Content -->

<?php include_once 'footer.php' ?>