<?php
$page = 'email';
include_once 'header.php';
$emails = select_rows("SELECT * FROM email WHERE email_from = '$uid' ");

?>

<div class="container-xxl flex-grow-1 container-p-y">
    <div class="app-email card">
        <div class="border-0">
            <div class="row g-0">
                <!-- Email Sidebar -->
                <div class="col app-email-sidebar border-end flex-grow-0" id="app-email-sidebar">
                    <div class="btn-compost-wrapper d-grid">
                        <button
                            class="btn btn-primary btn-compose"
                            data-bs-toggle="modal"
                            data-bs-target="#emailComposeSidebar"
                            id="emailComposeSidebarLabel">
                            Compose
                        </button>
                    </div>
                    <!-- Email Filters -->
                    <div class="email-filters py-2">
                        <!-- Email Filters: Folder -->
                        <ul class="email-filter-folders list-unstyled pb-1">
                            <li class="active d-flex justify-content-between" data-target="inbox">
                                <a href="email" class="d-flex flex-wrap align-items-center">
                                    <i class="bx bx-envelope"></i>
                                    <span class="align-middle ms-2">Inbox</span>
                                </a>
                                <div class="badge bg-label-primary rounded-pill"><?= sizeof($emails) ?></div>
                            </li>
                            <li class="d-flex" data-target="sent">
                                <a href="#" class="d-flex flex-wrap align-items-center">
                                    <i class="bx bx-send"></i>
                                    <span class="align-middle ms-2">Sent</span>
                                </a>
                            </li>
                        </ul>

                        <!-- Email Filters: Labels -->
                        <div class="email-filter-labels">
                            <!-- <small class="mx-4 text-uppercase text-muted">Labels</small> -->
                            <ul class="list-unstyled mb-0">
                                <li data-target="work">
                                    <a href="javascript:void(0);">
                                        <i class="badge badge-dot bg-success"></i>
                                        <span class="align-middle ms-2"></span>
                                    </a>
                                </li>

                            </ul>
                        </div>
                        <!--/ Email Filters -->
                    </div>
                </div>
                <!--/ Email Sidebar -->

                <!-- Emails List -->
                <div class="col app-emails-list">
                    <div class="card shadow-none border-0">
                        <div class="card-body emails-list-header p-3 py-lg-3 py-2">
                            <!-- Email List: Search -->
                            <div class="d-flex justify-content-between align-items-center">
                                <div class="d-flex align-items-center w-100">
                                    <i
                                        class="bx bx-menu bx-sm cursor-pointer d-block d-lg-none me-3"
                                        data-bs-toggle="sidebar"
                                        data-target="#app-email-sidebar"
                                        data-overlay></i>
                                    <div class="mb-0 mb-lg-2 w-100">
                                        <div class="input-group input-group-merge shadow-none">
                                            <span class="input-group-text border-0 ps-0 py-0" id="email-search">
                                                <i class="bx bx-search fs-4 text-muted"></i>
                                            </span>
                                            <input
                                                type="text"
                                                class="form-control email-search-input border-0 py-0"
                                                placeholder="Search mail"
                                                aria-label="Search..."
                                                aria-describedby="email-search" />
                                        </div>
                                    </div>
                                </div>
                                <div class="d-flex align-items-center mb-0 mb-md-2">
                                    <i
                                        class="bx bx-refresh scaleX-n1-rtl cursor-pointer email-refresh me-2 bx-sm text-muted"></i>
                                    <div class="dropdown">
                                        <button
                                            class="btn p-0"
                                            type="button"
                                            id="emailsActions"
                                            data-bs-toggle="dropdown"
                                            aria-haspopup="true"
                                            aria-expanded="false">
                                            <i class="bx bx-dots-vertical-rounded bx-sm text-muted"></i>
                                        </button>
                                        <div class="dropdown-menu dropdown-menu-end" aria-labelledby="emailsActions">
                                            <a class="dropdown-item" href="javascript:void(0)">Mark as read</a>
                                            <a class="dropdown-item" href="javascript:void(0)">Mark as unread</a>
                                            <a class="dropdown-item" href="javascript:void(0)">Delete</a>
                                            <a class="dropdown-item" href="javascript:void(0)">Archive</a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <hr class="mx-n3 emails-list-header-hr" />
                            <!-- Email List: Actions -->
                            <div class="d-flex justify-content-between align-items-center">
                                <div class="d-flex align-items-center">
                                    <div class="form-check me-2">
                                        <input class="form-check-input" type="checkbox" id="email-select-all" />
                                        <label class="form-check-label" for="email-select-all"></label>
                                    </div>
                                    <i class="bx bx-trash-alt email-list-delete cursor-pointer me-3 fs-4"></i>
                                    <i class="bx bx-envelope email-list-read cursor-pointer me-3 fs-4"></i>
                                    <div class="dropdown">
                                        <button
                                            class="btn p-0"
                                            type="button"
                                            id="dropdownMenuFolderOne"
                                            data-bs-toggle="dropdown"
                                            aria-haspopup="true"
                                            aria-expanded="false">
                                            <i class="bx bx-folder bx bx-folder fs-4 me-3"></i>
                                        </button>
                                        <div class="dropdown-menu dropdown-menu-end" aria-labelledby="dropdownMenuFolderOne">
                                            <a class="dropdown-item" href="javascript:void(0)">
                                                <i class="bx bx-error-circle me-1"></i>
                                                <span class="align-middle">Spam</span>
                                            </a>
                                            <a class="dropdown-item" href="javascript:void(0)">
                                                <i class="bx bx-edit me-1"></i>
                                                <span class="align-middle">Draft</span>
                                            </a>
                                            <a class="dropdown-item" href="javascript:void(0)">
                                                <i class="bx bx-trash-alt me-1"></i>
                                                <span class="align-middle">Trash</span>
                                            </a>
                                        </div>
                                    </div>
                                    <div class="dropdown">
                                        <button
                                            class="btn p-0"
                                            type="button"
                                            id="dropdownLabelOne"
                                            data-bs-toggle="dropdown"
                                            aria-haspopup="true"
                                            aria-expanded="false">
                                            <i class="bx bx-label fs-4 me-3"></i>
                                        </button>
                                        <div class="dropdown-menu dropdown-menu-end" aria-labelledby="dropdownLabelOne">
                                            <a class="dropdown-item" href="javascript:void(0)">
                                                <i class="badge badge-dot bg-success me-1"></i>
                                                <span class="align-middle">Workshop</span>
                                            </a>
                                            <a class="dropdown-item" href="javascript:void(0)">
                                                <i class="badge badge-dot bg-primary me-1"></i>
                                                <span class="align-middle">Company</span>
                                            </a>
                                            <a class="dropdown-item" href="javascript:void(0)">
                                                <i class="badge badge-dot bg-warning me-1"></i>
                                                <span class="align-middle">Important</span>
                                            </a>
                                            <a class="dropdown-item" href="javascript:void(0)">
                                                <i class="badge badge-dot bg-danger me-1"></i>
                                                <span class="align-middle">Private</span>
                                            </a>
                                        </div>
                                    </div>
                                </div>
                                <div
                                    class="email-pagination d-sm-flex d-none align-items-center flex-wrap justify-content-between justify-sm-content-end">
                                    <span class="d-sm-block d-none mx-3 text-muted">1-10 of 653</span>
                                    <i
                                        class="email-prev bx bx-chevron-left scaleX-n1-rtl cursor-pointer text-muted me-4 fs-4"></i>
                                    <i class="email-next bx bx-chevron-right scaleX-n1-rtl cursor-pointer fs-4"></i>
                                </div>
                            </div>
                        </div>
                        <hr class="container-m-nx m-0" />
                        <!-- Email List: Items -->
                        <div class="email-list pt-0">
                            <ul class="list-unstyled m-0">
                                <?php
                                if (!empty($emails)) {
                                    foreach ($emails as $email) {
                                        $sender = 'Admin';
                                        $limited = limit_text($email['email_body']);
                                        $emailTime = get_hours_mins($email['email_date_created']);
                                ?>
                                        <li
                                            class="email-list-item email-marked-read"
                                            data-sent="true"
                                            data-email-id="<?= $email['email_id'] ?>"
                                            data-bs-toggle="sidebar"
                                            data-target="#app-email-view">
                                            <div class="d-flex align-items-center">
                                                <div class="form-check">
                                                    <input class="email-list-item-input form-check-input" type="checkbox" id="email-2" />
                                                    <label class="form-check-label" for="email-2"></label>
                                                </div>
                                                <i
                                                    class="email-list-item-bookmark bx bx-star d-sm-inline-block d-none cursor-pointer mx-4 bx-sm"></i>
                                                <img
                                                    src="<?= base_url ?>assets/img/illustrations/admin.png"
                                                    alt="user-avatar"
                                                    class="d-block flex-shrink-0 rounded-circle me-sm-3 me-0"
                                                    height="32"
                                                    width="32" />
                                                <div class="email-list-item-content ms-2 ms-sm-0 me-2">
                                                    <span class="email-list-item-username me-2 h6"><?= $sender ?></span>
                                                    <span class="email-list-item-subject d-xl-inline-block d-block">
                                                        <?= $limited ?>
                                                    </span>
                                                </div>
                                                <div class="email-list-item-meta ms-auto d-flex align-items-center">
                                                    <span
                                                        class="email-list-item-label badge badge-dot bg-danger d-none d-md-inline-block me-2"
                                                        data-label="private"></span>
                                                    <small class="email-list-item-time text-muted"><?= $emailTime ?></small>
                                                    <ul class="list-inline email-list-item-actions">
                                                        <li class="list-inline-item email-delete"><i class="bx bx-trash-alt fs-4"></i></li>
                                                        <li class="list-inline-item email-unread"><i class="bx bx-envelope fs-4"></i></li>
                                                        <li class="list-inline-item"><i class="bx bx-error-circle fs-4"></i></li>
                                                    </ul>
                                                </div>
                                            </div>
                                        </li>
                                <?php
                                    }
                                }
                                ?>
                            </ul>
                        </div>
                    </div>
                    <div class="app-overlay"></div>
                </div>
                <!-- /Emails List -->

                <!-- Email View -->
                <div class="col app-email-view flex-grow-0 bg-body" id="app-email-view">
                    <div class="app-email-view-header p-3 py-md-3 py-2 rounded-0">
                        <!-- Email View : Title  bar-->
                        <div class="d-flex justify-content-between align-items-center">
                            <div class="d-flex align-items-center overflow-hidden">
                                <i
                                    class="bx bx-chevron-left bx-sm cursor-pointer me-2"
                                    data-bs-toggle="sidebar"
                                    data-target="#app-email-view"></i>
                                <h6 class="text-truncate mb-0 me-2">Subject</h6>
                            </div>
                            <!-- Email View : Action  bar-->
                            <div class="d-flex">
                                <i class="bx bx-printer d-sm-block d-none fs-4"></i>
                                <div class="dropdown ms-3">
                                    <button
                                        class="btn p-0"
                                        type="button"
                                        id="dropdownMoreOptions"
                                        data-bs-toggle="dropdown"
                                        aria-haspopup="true"
                                        aria-expanded="false">
                                        <i class="bx bx-dots-vertical-rounded fs-4"></i>
                                    </button>
                                </div>
                            </div>
                        </div>
                        <hr class="app-email-view-hr mx-n3 mb-2" />

                    </div>
                    <hr class="m-0" />
                    <!-- Email View : Content-->
                    <div class="app-email-view-content py-4">
                        <!-- Email View : Last mail-->
                        <div class="card email-card-last mx-sm-4 mx-3 mt-4 border">
                            <div
                                class="card-header d-flex justify-content-between align-items-center flex-wrap border-bottom">
                                <div class="d-flex align-items-center mb-sm-0 mb-3">
                                    <img
                                        src="<?= base_url ?>assets/img/illustrations/admin.png"
                                        alt="user-avatar"
                                        class="flex-shrink-0 rounded-circle me-2"
                                        height="38"
                                        width="38" />
                                    <div class="flex-grow-1 ms-1">
                                        <h6 class="m-0"> </h6>
                                    </div>
                                </div>
                                <div class="d-flex align-items-center">
                                    <small class="mb-0 me-3 text-muted">June 20th 2020, 08:10 AM</small>
                                    <i class="bx bx-paperclip cursor-pointer me-2 bx-sm"></i>
                                    <i class="email-list-item-bookmark bx bx-star cursor-pointer me-2 bx-sm"></i>
                                    <div class="dropdown me-3">
                                        <button
                                            class="btn p-0"
                                            type="button"
                                            id="dropdownEmailTwo"
                                            data-bs-toggle="dropdown"
                                            aria-haspopup="true"
                                            aria-expanded="false">
                                            <i class="bx bx-dots-vertical-rounded bx-sm"></i>
                                        </button>
                                        <div class="dropdown-menu dropdown-menu-end" aria-labelledby="dropdownEmailTwo">
                                            <a class="dropdown-item scroll-to-reply" href="javascript:void(0)">
                                                <i class="bx bx-share me-1"></i>
                                                <span class="align-middle">Reply</span>
                                            </a>
                                            <a class="dropdown-item" href="javascript:void(0)">
                                                <i class="bx bx-share me-1 scaleX-n1 scaleX-n1-rtl"></i>
                                                <span class="align-middle">Forward</span>
                                            </a>
                                            <a class="dropdown-item" href="javascript:void(0)">
                                                <i class="bx bx-info-circle me-1"></i>
                                                <span class="align-middle">Report</span>
                                            </a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="card-body pt-3">
                                <p>

                                </p>
                            </div>
                        </div>
                       
                    </div>
                </div>
                <!-- Email View -->
            </div>
        </div>

        <!-- Compose Email -->
        <div
            class="app-email-compose modal"
            id="emailComposeSidebar"
            tabindex="-1"
            aria-labelledby="emailComposeSidebarLabel"
            aria-hidden="true">
            <div class="modal-dialog m-0 me-md-4 mb-4 modal-lg">
                <div class="modal-content p-0">
                    <div class="modal-header py-3 bg-body">
                        <h5 class="modal-title fs-5">Compose Mail</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body flex-grow-1 pb-sm-0 p-4 py-2">
                        <form class="email-compose-form" method="POST" enctype="multipart/form-data" action="<?= model_url ?>email">
                            <input type="hidden" name="email_source" value="client">
                            <div class="email-compose-to d-flex justify-content-between align-items-center">
                                <label class="form-label mb-2 text-muted" for="emailContacts">To:</label>
                                <div class="select2-primary border-0 shadow-none flex-grow-1 mx-2">
                                    <select
                                        class="select2 select-email-contacts form-select"
                                        id="emailContacts"
                                        name="email_to">
                                        <option data-avatar="1.png" value="Super Admin">Super Admin</option>
                                        <option data-avatar="3.png" value="Admin">Admin</option>
                                    </select>
                                </div>
                                <div class="email-compose-toggle-wrapper mb-2">
                                    <a class="email-compose-toggle-cc text-body" href="javascript:void(0);">Cc |</a>
                                    <a class="email-compose-toggle-bcc text-body" href="javascript:void(0);">Bcc</a>
                                </div>
                            </div>

                            <div class="email-compose-cc d-none">
                                <hr class="mx-n4 my-2" />
                                <div class="d-flex align-items-center">
                                    <label for="email-cc" class="form-label mb-0">Cc:</label>
                                    <input
                                        type="text"
                                        class="form-control border-0 shadow-none flex-grow-1 mx-2"
                                        id="email-cc"
                                        name="email_cc"
                                        placeholder="someone@email.com" />
                                </div>
                            </div>
                            <div class="email-compose-bcc d-none">
                                <hr class="mx-n4 my-2" />
                                <div class="d-flex align-items-center">
                                    <label for="email-bcc" class="form-label mb-0">Bcc:</label>
                                    <input
                                        type="text"
                                        class="form-control border-0 shadow-none flex-grow-1 mx-2"
                                        id="email-bcc"
                                        name="email_bcc"
                                        placeholder="someone@email.com" />
                                </div>
                            </div>
                            <hr class="mx-n4 my-0" />
                            <div class="email-compose-subject d-flex align-items-center my-1">
                                <label for="email-subject" class="form-label mb-0 text-muted">Subject:</label>
                                <input
                                    type="text"
                                    name="email_subject"
                                    class="form-control border-0 shadow-none flex-grow-1 mx-2"
                                    id="email-subject" />
                            </div>
                            <div class="email-compose-message mx-n4">
                                <div class="d-flex justify-content-end">
                                    <div class="email-editor-toolbar border-bottom-0 w-100">
                                        <span class="ql-formats me-0">
                                            <button class="ql-bold"></button>
                                            <button class="ql-italic"></button>
                                            <button class="ql-underline"></button>
                                            <button class="ql-list" value="ordered"></button>
                                            <button class="ql-list" value="bullet"></button>
                                            <button class="ql-link"></button>
                                            <button class="ql-image"></button>
                                        </span>
                                    </div>
                                </div>
                                <input type="hidden" name="email_body" id="email-body">
                                <div class="email-editor"></div>
                            </div>
                            <hr class="mx-n4 mt-0 mb-2" />
                            <div
                                class="email-compose-actions d-flex justify-content-between align-items-center my-2 py-1">
                                <div class="d-flex align-items-center">
                                    <div class="btn-group">
                                        <button id="btnFormSubmit" type="submit" class="btn btn-primary">
                                            Send
                                        </button>
                                        <button
                                            type="button"
                                            class="btn btn-primary dropdown-toggle dropdown-toggle-split"
                                            data-bs-toggle="dropdown"
                                            aria-haspopup="true"
                                            aria-expanded="false">
                                            <span class="visually-hidden">Toggle Dropdown</span>
                                        </button>
                                        <ul class="dropdown-menu">
                                            <li><a class="dropdown-item" href="javascript:void(0);">Schedule send</a></li>
                                            <li><a class="dropdown-item" href="javascript:void(0);">Save draft</a></li>
                                        </ul>
                                    </div>
                                    <label for="attach-file"><i class="bx bx-paperclip cursor-pointer ms-2"></i></label>
                                    <input type="file" name="file-input" class="d-none" id="attach-file" />
                                </div>
                                <div class="d-flex align-items-center">
                                    <div class="dropdown">
                                        <button
                                            class="btn p-0"
                                            type="button"
                                            id="dropdownMoreActions"
                                            data-bs-toggle="dropdown"
                                            aria-haspopup="true"
                                            aria-expanded="false">
                                            <i class="bx bx-dots-vertical-rounded"></i>
                                        </button>
                                        <ul class="dropdown-menu" aria-labelledby="dropdownMoreActions">
                                            <li><button type="button" class="dropdown-item">Add Label</button></li>
                                            <li><button type="button" class="dropdown-item">Plain text mode</button></li>
                                            <li>
                                                <hr class="dropdown-divider" />
                                            </li>
                                            <li><button type="button" class="dropdown-item">Print</button></li>
                                            <li><button type="button" class="dropdown-item">Check Spelling</button></li>
                                        </ul>
                                    </div>
                                    <button type="reset" class="btn" data-bs-dismiss="modal" aria-label="Close">
                                        <i class="bx bx-trash-alt"></i>
                                    </button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
        <!-- /Compose Email -->
    </div>
</div>

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script>
    $(document).ready(function() {
        $('.email-list-item').on('click', function() {
            const emailId = $(this).data('email-id');
            console.log(emailId);

            $.ajax({
                url: 'get_email.php',
                method: 'POST',
                data: {
                    email_id: emailId
                },
                success: function(response) {
                    console.log(response);
                    const email = JSON.parse(response);
                    $('#app-email-view .text-truncate').text(email.email_subject);
                    $('#app-email-view .card-header h6').text(email.email_from);
                    $('#app-email-view .card-body p').html(email.email_body);
                    $('#app-email-view .email-reply h6').text("Reply to " + email.email_from);
                    $('#app-email-view .card-header small.text-muted').text(formatAMPM(new Date(email.email_date_created)));


                }
            });
        });
    });
</script>

<script>
    document.addEventListener('DOMContentLoaded', function() {
        let quill;

        (function() {
            const emailList = document.querySelector('.email-list'),
                emailListItemInputs = [].slice.call(document.querySelectorAll('.email-list-item-input')),
                emailView = document.querySelector('.app-email-view-content'),
                emailFilters = document.querySelector('.email-filters'),
                emailFilterByFolders = [].slice.call(document.querySelectorAll('.email-filter-folders li')),
                emailEditor = document.querySelector('.email-editor'),
                appEmailSidebar = document.querySelector('.app-email-sidebar'),
                appOverlay = document.querySelector('.app-overlay'),
                emailReplyEditor = document.querySelector('.email-reply-editor'),
                bookmarkEmail = [].slice.call(document.querySelectorAll('.email-list-item-bookmark')),
                selectAllEmails = document.getElementById('email-select-all'),
                emailSearch = document.querySelector('.email-search-input'),
                toggleCC = document.querySelector('.email-compose-toggle-cc'),
                toggleBCC = document.querySelector('.email-compose-toggle-bcc'),
                emailCompose = document.querySelector('.app-email-compose'),
                emailListDelete = document.querySelector('.email-list-delete'),
                emailListRead = document.querySelector('.email-list-read'),
                refreshEmails = document.querySelector('.email-refresh'),
                emailViewContainer = document.getElementById('app-email-view'),
                emailFilterFolderLists = [].slice.call(document.querySelectorAll('.email-filter-folders li')),
                emailListItemActions = [].slice.call(document.querySelectorAll('.email-list-item-actions li'));

            // Initialize PerfectScrollbar
            // ------------------------------
            // Email list scrollbar
            if (emailList) {
                let emailListInstance = new PerfectScrollbar(emailList, {
                    wheelPropagation: false,
                    suppressScrollX: true
                });
            }

            // Sidebar tags scrollbar
            if (emailFilters) {
                new PerfectScrollbar(emailFilters, {
                    wheelPropagation: false,
                    suppressScrollX: true
                });
            }

            // Email view scrollbar
            if (emailView) {
                new PerfectScrollbar(emailView, {
                    wheelPropagation: false,
                    suppressScrollX: true
                });
            }

            // Initialize Quill Editor
            // ------------------------------

            if (emailEditor) {
                quill = new Quill('.email-editor', {
                    modules: {
                        toolbar: '.email-editor-toolbar'
                    },
                    placeholder: 'Message... ',
                    theme: 'snow'
                });
            }


            // Search email based on searched text
            if (emailSearch) {
                emailSearch.addEventListener('keyup', e => {
                    let searchValue = e.currentTarget.value.toLowerCase(),
                        searchEmailListItems = {},
                        selectedFolderFilter = document.querySelector('.email-filter-folders .active').getAttribute('data-target');

                    // Filter emails based on selected folders
                    if (selectedFolderFilter != 'inbox') {
                        searchEmailListItems = [].slice.call(
                            document.querySelectorAll('.email-list-item[data-' + selectedFolderFilter + '="true"]')
                        );
                    } else {
                        searchEmailListItems = [].slice.call(document.querySelectorAll('.email-list-item'));
                    }

                    // console.log(searchValue);
                    searchEmailListItems.forEach(searchEmailListItem => {
                        let searchEmailListItemText = searchEmailListItem.textContent.toLowerCase();
                        if (searchValue) {
                            if (-1 < searchEmailListItemText.indexOf(searchValue)) {
                                searchEmailListItem.classList.add('d-block');
                            } else {
                                searchEmailListItem.classList.add('d-none');
                            }
                        } else {
                            searchEmailListItem.classList.remove('d-none');
                        }
                    });
                });
            }



            // Toggle CC/BCC input
            if (toggleBCC) {
                toggleBCC.addEventListener('click', e => {
                    Helpers._toggleClass(document.querySelector('.email-compose-bcc'), 'd-block', 'd-none');
                });
            }

            if (toggleCC) {
                toggleCC.addEventListener('click', e => {
                    Helpers._toggleClass(document.querySelector('.email-compose-cc'), 'd-block', 'd-none');
                });
            }

            // Empty compose email message inputs when modal is hidden
            emailCompose.addEventListener('hidden.bs.modal', event => {
                document.querySelector('.email-editor .ql-editor').innerHTML = '';
                $('#emailContacts').val('');
                document.getElementById('email-body').value = '';
                initSelect2();
            });

            const formSubmit = document.querySelector('.email-compose-form');
            formSubmit.addEventListener('submit', function(e) {
                const emailBodyInput = document.getElementById('email-body');
                if (quill && emailBodyInput) {
                    emailBodyInput.value = quill.root.innerHTML;
                    console.log(emailBodyInput.value);
                } else {
                    console.log('Nothing here');
                }
            });


            // Mark as read
            if (emailListRead) {
                emailListRead.addEventListener('click', e => {
                    emailListItemInputs.forEach(emailListItemInput => {
                        if (emailListItemInput.checked) {
                            emailListItemInput.checked = false;
                            emailListItemInput.parentNode.closest('li.email-list-item').classList.add('email-marked-read');
                            let emailItemEnvelop = emailListItemInput.parentNode
                                .closest('li.email-list-item')
                                .querySelector('.email-list-item-actions li');

                            if (Helpers._hasClass('email-read', emailItemEnvelop)) {
                                emailItemEnvelop.classList.remove('email-read');
                                emailItemEnvelop.classList.add('email-unread');
                                emailItemEnvelop.querySelector('i').classList.remove('bx-envelope-open');
                                emailItemEnvelop.querySelector('i').classList.add('bx-envelope');
                            }
                        }
                    });
                    selectAllEmails.indeterminate = false;
                    selectAllEmails.checked = false;
                });
            }


            // Earlier msgs
            // ? Using jquery vars due to jQuery animation (slideToggle) dependency
            let earlierMsg = $('.email-earlier-msgs');
            if (earlierMsg.length) {
                earlierMsg.on('click', function() {
                    let $this = $(this);
                    $this.parents().find('.email-card-last').addClass('hide-pseudo');
                    $this.next('.email-card-prev').slideToggle();
                    $this.remove();
                });
            }


            // Scroll to bottom on reply click
            // ? Using jquery vars due to jQuery animation dependency
            let emailViewContent = $('.app-email-view-content');
            emailViewContent.find('.scroll-to-reply').on('click', function() {
                if (emailViewContent[0].scrollTop === 0) {
                    emailViewContent.animate({
                            scrollTop: emailViewContent[0].scrollHeight
                        },
                        1500
                    );
                }
            });

            // Close view on email filter folder list click
            if (emailFilterFolderLists) {
                emailFilterFolderLists.forEach(emailFilterFolderList => {
                    emailFilterFolderList.addEventListener('click', e => {
                        emailViewContainer.classList.remove('show');
                    });
                });
            }


        })();
    });
</script>

<?php include_once 'footer.php' ?>