<?php
require_once '../model/create.php';

$user_id = $_SESSION['user_id'] ?? 0;
if (!$user_id) {
  echo json_encode(['error' => 'User not logged in']);
  exit;
}

$admin_id = 'ADM20220830AS7yer1'; // fixed admin ID

$message = $_POST['message'] ?? '';
if (!$message) {
  echo json_encode(['error' => 'Empty message']);
  exit;
}

$arr['chat_id'] = create_id('chat', 'chat_id');
$arr['chat_sender_role'] = 'client';
$arr['chat_sender_id'] = $user_id;
$arr['chat_receiver_role'] = 'admin';
$arr['chat_receiver_id'] = $admin_id;
$arr['chat_message'] = $message;

if (!build_sql_insert('chat', $arr)) {
  echo json_encode(['error' => 'Failed to send message']);
  exit;
}

//Send notif
$notifArray['notification_title']   = 'New Message';
$notifArray['notification_text']    = 'A client has messaged you';
$notifArray['notification_to']      = 'Admin';
$notifArray['notification_from']    = $user_id;
$notifArray['notification_redirect'] = 'chat';

if (!build_sql_insert('notification', $notifArray)) {
  $error['notification'] = 139;
  error_checker($return_url);
}

echo json_encode(['success' => true]);
