<?php
$page = 'progress';
include_once 'header.php';


?>

<div class="container-xxl flex-grow-1 container-p-y">
    <h4 class="fw-bold py-3 mb-2">
        <span class="text-muted fw-light">Application</span> Progress
    </h4>

    <div class="row overflow-hidden">
        <div class="col-12">
            <?php
            $direction = 'fade-right';
            ?>
            <?php
            // find the highest completed step id
            $maxCompletedStepId = !empty($completed_step_ids) ? max($completed_step_ids) : 0;
            ?>

            <ul class="timeline timeline-center mt-5">
                <?php foreach ($steps as $index => $step): ?>
                    <?php
                    // ✅ check if current step_id is <= max completed
                    $isCompleted = $step['step_id'] <= $maxCompletedStepId;
                    $completedClass = $isCompleted ? 'Completed' : '';
                    $month = date('M Y', strtotime($step['step_date_created']));
                    $direction = $index % 2 == 0 ? 'fade-right' : 'fade-left';
                    ?>
                    <li class="timeline-item mb-md-4 mb-5">
                        <span class="timeline-indicator timeline-indicator-primary" data-aos="zoom-in" data-aos-delay="200">
                            <i class="bx bx-calendar"></i>
                        </span>
                        <div class="timeline-event card p-0 <?= $completedClass ?>" data-aos="<?= $direction ?>">
                            <div class="card-header d-flex justify-content-between align-items-center flex-wrap">
                                <div>
                                    <h6 class="MyDate"><?= $month ?></h6>
                                    <h6 class="MyCardTitle card-title mb-0"><?= $step['step_name'] ?></h6>
                                </div>
                            </div>
                            <div class="card-body">
                                <span class="CBspan"><?= $step['step_subtitle'] ?></span>
                                <p class="mb-2"><?= $step['step_text'] ?></p>
                            </div>
                        </div>
                    </li>
                <?php endforeach; ?>
            </ul>


        </div>
    </div>
</div>

<style>
    .Completed {
        background-color: #002777 !important;
    }

    .Completed h6,
    .Completed .card-header h6,
    .Completed .card-body .CBspan,
    .Completed .card-body p {
        color: white;
    }

    .Completed::before {
        border-left-color: #002777 !important;
        border-right-color: #002777 !important;
    }

    .Completed::after {
        border-left-color: #002777 !important;
        border-right-color: #002777 !important;
    }

    .CBspan {
        font-style: italic;
        font-size: 0.8em;
    }
</style>

<?php include_once 'footer.php' ?>