<?php
$page = 'profile';
include_once 'header.php';

?>

<head>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
</head>

<div class="container-xxl flex-grow-1 container-p-y">
    <h4 class="fw-bold py-3 mb-4"><span class="text-muted fw-light">Your </span> Profile</h4>

    <!-- Header -->
    <div class="row">
        <div class="col-12">
            <div class="card mb-4">
                <div class="user-profile-header-banner">
                    <img src="<?= base_url ?>assets/img/pages/profile-banner.png" alt="Banner image" class="rounded-top" />
                </div>
                <div class="user-profile-header d-flex flex-column flex-sm-row text-sm-start text-center mb-4">
                    <div class="flex-shrink-0 mt-n2 mx-sm-0 mx-auto">
                        <img
                            src="<?= image_url . $userImg ?>"
                            alt="user image"
                            style="object-fit: cover;"
                            class="d-block h-auto ms-0 ms-sm-4 rounded user-profile-img" />
                    </div>
                    <div class="flex-grow-1 mt-3 mt-sm-5">
                        <div
                            class="d-flex align-items-md-end align-items-sm-start align-items-center justify-content-md-between justify-content-start mx-4 flex-md-row flex-column gap-4">
                            <div class="user-profile-info">
                                <h4><?= $user['user_name'] ?></h4>
                                <ul
                                    class="list-inline mb-0 d-flex align-items-center flex-wrap justify-content-sm-start justify-content-center gap-2">
                                    <li class="list-inline-item fw-semibold">
                                        <i class="bx bx-calendar-alt"></i> Joined <?= get_ordinal_month($user['user_date_created']) ?>
                                    </li>
                                </ul>
                            </div>
                            <a href="javascript:void(0)" data-bs-target="#editUser"
                                data-bs-toggle="modal" class="btn btn-primary text-nowrap">
                                <i class="bx bx-user-check me-1"></i>Edit
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!--/ Header -->


    <!-- User Profile Content -->
    <div class="row">
        <div class="col-xl-4 col-lg-5 col-md-5">
            <!-- About User -->
            <div class="card mb-4">
                <div class="card-body">
                    <small class="text-muted text-uppercase">Biodata</small>
                    <ul class="list-unstyled mb-4 mt-3">
                        <li class="d-flex align-items-center mb-3">
                            <i class="bx bx-user"></i><span class="fw-semibold mx-2">Full Name:</span>
                            <span><?= $user['user_name'] ?></span>

                        </li>
                        <li class="d-flex align-items-center mb-3">
                            <i class="bx bx-check"></i><span class="fw-semibold mx-2">Status:</span> <span>Active</span>
                        </li>
                        <li class="d-flex align-items-center mb-3">
                            <i class="fa-solid fa-id-card"></i><span class="fw-semibold mx-2">ID/Passport Number:</span> <span><?= $user['user_passport'] ?></span>
                        </li>

                    </ul>
                    <small class="text-muted text-uppercase">Contacts</small>
                    <ul class="list-unstyled mb-4 mt-3">
                        <li class="d-flex align-items-center mb-3">
                            <i class="bx bx-phone"></i><span class="fw-semibold mx-2">Phone Number:</span>
                            <span><?= $user['user_phone'] ?></span>

                        </li>

                        <li class="d-flex align-items-center mb-3">
                            <i class="bx bx-envelope"></i><span class="fw-semibold mx-2">Email:</span>
                            <span><?= $user['user_email'] ?></span>
                        </li>
                    </ul>
                    <small class="text-muted text-uppercase">Bookings</small>
                    <ul class="list-unstyled mt-3 mb-0">
                        <li class="d-flex align-items-center mb-3">
                            <i class="fa-solid fa-calendar-check  text-info me-2"></i>
                            <div class="d-flex flex-wrap">
                                <span class="fw-semibold me-2">Appointments:</span><span><?= sizeof($bookings) ?></span>
                            </div>
                        </li>
                        <li class="d-flex align-items-center">
                            <i class="bx bxl-react text-info me-2"></i>
                            <div class="d-flex flex-wrap">
                                <span class="fw-semibold me-2">Uploads</span><span><?= sizeof($uploads) ?></span>
                            </div>
                        </li>
                    </ul>
                </div>
            </div>
            <!--/ About User -->

        </div>
        <div class="col-xl-8 col-lg-7 col-md-7">
            <!-- Activity Timeline -->
            <div class="card card-action mb-4">
                <div class="card-header align-items-center">
                    <h5 class="card-action-title mb-0"><i class="bx bx-list-ul me-2"></i>Activity Timeline</h5>
                    <div class="card-action-element">
                        <div class="dropdown">
                            <button
                                type="button"
                                class="btn dropdown-toggle hide-arrow p-0"
                                data-bs-toggle="dropdown"
                                aria-expanded="false">
                                <i class="bx bx-dots-vertical-rounded"></i>
                            </button>
                            <ul class="dropdown-menu dropdown-menu-end">
                                <li><a class="dropdown-item" href="javascript:void(0);">Share timeline</a></li>
                                <li><a class="dropdown-item" href="javascript:void(0);">Suggest edits</a></li>
                                <li>
                                    <hr class="dropdown-divider" />
                                </li>
                                <li><a class="dropdown-item" href="javascript:void(0);">Report bug</a></li>
                            </ul>
                        </div>
                    </div>
                </div>
                <div class="card-body">
                    <!-- Activity Timeline -->
                    <ul class="timeline">
                        <li class="timeline-item timeline-item-transparent">
                            <span class="timeline-point timeline-point-primary"></span>
                            <div class="timeline-event">
                                <div class="timeline-header mb-1">
                                    <h6 class="mb-0">Signed Up To WSG</h6>
                                    <small class="text-muted">May 2025</small>
                                </div>

                            </div>
                        </li>
                        <?php foreach ($completed_step_ids as $in => $st):
                            $s = get_by_id('step', $st);
                        ?>

                            <li class="timeline-item timeline-item-transparent">
                                <span class="timeline-point timeline-point-warning"></span>
                                <div class="timeline-event">
                                    <div class="timeline-header mb-1">
                                        <h6 class="mb-0"><?= $s['step_name'] ?></h6>
                                        <small class="text-muted">May 2025</small>
                                    </div>

                                </div>
                            </li>
                        <?php endforeach; ?>

                        <li class="timeline-end-indicator">
                            <i class="bx bx-check-circle"></i>
                        </li>
                    </ul>
                    <!-- /Activity Timeline -->
                </div>
            </div>
            <!--/ Activity Timeline -->
        </div>
    </div>
    <!--/ User Profile Content -->

    <!-- Edit User Modal -->
    <div class="modal fade" id="editUser" tabindex="-1" aria-hidden="true">
        <div class="modal-dialog modal-lg modal-simple modal-edit-user">
            <div class="modal-content p-3 p-md-5">
                <div class="modal-body">
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    <div class="text-center mb-4">
                        <h3>Edit User Information</h3>
                    </div>
                    <form method="POST" class="row g-3" enctype="multipart/form-data" action="<?= model_url ?>edit_user">
                        <input hidden name="uid" value="<?= $user['user_id'] ?>" />
                        <div>
                            <div class="d-flex align-items-start align-items-sm-center gap-4">
                                <img src="<?= image_url . $userImg ?>" alt="user-avatar" class="d-block rounded" height="100" width="100" id="img_loader" />
                                <div class="button-wrapper">
                                    <label for="my_img" class="btn btn-primary me-2 mb-4" tabindex="0">
                                        <span class="d-none d-sm-block">Upload new photo</span>
                                        <i class="bx bx-upload d-block d-sm-none"></i>
                                        <input type="file" id="my_img" class="account-file-input" name="user_image" hidden accept="image/png, image/jpeg" />
                                    </label>
                                    <p class="text-muted mb-0">Allowed JPG, GIF or PNG. Max size of 800K</p>
                                </div>
                            </div>
                        </div>
                        <div class="col-12 col-md-12">
                            <label class="form-label" for="modalEditUserFirstName">First Name</label>
                            <input
                                type="text"
                                id="modalEditUserFirstName"
                                name="user_name"
                                disabled
                                value="<?= $user['user_name'] ?>"
                                class="form-control" />
                        </div>

                        <div class="col-12 col-md-6">
                            <label class="form-label" for="modalEditUserEmail">Email</label>
                            <input
                                type="text"
                                id="modalEditUserEmail"
                                name="user_email"
                                disabled
                                class="form-control"
                                value="<?= $user['user_email'] ?>" />
                        </div>

                        <div class="col-12 col-md-6">
                            <label class="form-label" for="modalEditTaxID">ID/Passport Number</label>
                            <input
                                type="text"
                                id="modalEditTaxID"
                                name="user_passport"
                                class="form-control modal-edit-tax-id"
                                value="<?= $user['user_passport'] ?>" />
                        </div>
                        <div class="col-12 col-md-6">
                            <label class="form-label" for="modalEditUserPhone">Phone Number</label>
                            <div class="input-group input-group-merge">
                                <input
                                    type="text"
                                    id="modalEditUserPhone"
                                    name="user_phone"
                                    class="form-control phone-number-mask"
                                    value="<?= $user['user_phone'] ?>" />
                            </div>
                        </div>

                        <div class="col-12 col-md-6">
                            <label class="form-label" for="modalEditUserdob">Date: <?= $user['user_dob'] ?></label>
                            <div class="input-group input-group-merge">
                                <input
                                    type="date"
                                    id="modalEditUserdob"
                                    name="user_dob"
                                    class="form-control dob-number-mask"
                                    value="<?= $user['user_dob'] ?>" />
                            </div>
                        </div>

                        <div class="col-12 text-center">
                            <button type="submit" class="btn btn-primary me-sm-3 me-1">Submit</button>
                            <button
                                type="reset"
                                class="btn btn-label-secondary"
                                data-bs-dismiss="modal"
                                aria-label="Close">
                                Cancel
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
    <!--/ Edit User Modal -->
</div>
<!-- / Content -->
<?php include_once 'footer.php' ?>