<?php
$page = 'home';

require_once '../path.php';
require_once MODEL_PATH . "operations.php";
$_SESSION['page'] = $page;
if (!isset($_SESSION) || $_SESSION['user_login'] == false) {
    $warning['login'] = 300;
    render_warning('../login');
}
if (isset($_SESSION['edit'])) {
    unset($_SESSION['edit']);
}
if (!empty($_SESSION['error'])) {
    foreach ($_SESSION['error'] as $err) {
        error_message(ERROR_DEFINITION[$err]) . PHP_EOL;
    }
}

if (!empty($_SESSION['success'])) {
    foreach ($_SESSION['success'] as $success) {
        success_message(SUCCESS_DEFINITION[$success]) . PHP_EOL;
    }
}

if (!empty($_SESSION['warning'])) {
    foreach ($_SESSION['warning'] as $warning) {
        warning_message(WARNING_DEFINITION[$warning]) . PHP_EOL;
    }
}

unset_session_error();
unset_session_success();
unset_session_warning();

$user = get_by_id('user', $_SESSION['user_id']);
if (isset($user['user_image'])) {
    $userImg = $user['user_image'];
} else {
    $userImg = 'avt.png';
}
$uid = $user['user_id'];

$bookings = select_rows("SELECT * FROM booking WHERE user_id = '$user[user_id]' ORDER BY booking_date_created DESC ");
$uploads = select_rows("SELECT * FROM upload WHERE user_id = '$user[user_id]' AND added_by ='client' ORDER BY upload_date_created DESC  ");
$docs = select_rows("SELECT * FROM upload WHERE user_id = '$user[user_id]' AND added_by ='admin' ORDER BY upload_date_created DESC  ");
$progress = select_rows("SELECT * FROM progress WHERE user_id = '$user[user_id]'");
$steps = select_rows("SELECT * FROM step ORDER BY step_id ASC");

if (!empty($bookings)) {
    $completed_step_ids = array_column($progress, 'step_id');
    $completed_step_ids[] = 1; // Ensure step 1 is always included
    $completed_step_ids = array_unique($completed_step_ids); // Avoid duplicates
} else {
    $completed_step_ids = array_column($progress, 'step_id');
}

$upload = $uploads[0];
$doc = $docs[0];
?>
<!DOCTYPE html>

<html
    lang="en"
    class="light-style layout-navbar-fixed layout-menu-fixed"
    dir="ltr"
    data-theme="theme-default"
    data-assets-path="<?= base_url ?>assets/"
    data-template="vertical-menu-template-no-customizer">

<head>
    <meta charset="utf-8" />
    <meta
        name="viewport"
        content="width=device-width, initial-scale=1.0, user-scalable=no, minimum-scale=1.0, maximum-scale=1.0" />

    <title><?= APP_NAME ?></title>

    <meta name="description" content="" />

    <!-- Favicon -->
    <link rel="icon" type="image/x-icon" href="<?= base_url ?>assets/img/logos/favicon.png" />

    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com" />
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin />
    <link
        href="https://fonts.googleapis.com/css2?family=Inter:ital,wght@0,300;0,400;0,500;0,600;0,700;1,300;1,400;1,500;1,600;1,700;1,800;1,900&display=swap"
        rel="stylesheet" />

    <!-- Icons -->
    <link rel="stylesheet" href="<?= base_url ?>assets/vendor/fonts/boxicons.css" />
    <link rel="stylesheet" href="<?= base_url ?>assets/vendor/fonts/fontawesome.css" />
    <link rel="stylesheet" href="<?= base_url ?>assets/vendor/fonts/flag-icons.css" />

    <!-- Core CSS -->
    <link rel="stylesheet" href="<?= base_url ?>assets/vendor/css/rtl/core.css" />
    <link rel="stylesheet" href="<?= base_url ?>assets/vendor/css/rtl/theme-default.css" />
    <link rel="stylesheet" href="<?= base_url ?>assets/css/demo.css" />

    <!-- Vendors CSS -->
    <link rel="stylesheet" href="<?= base_url ?>assets/vendor/libs/perfect-scrollbar/perfect-scrollbar.css" />
    <link rel="stylesheet" href="<?= base_url ?>assets/vendor/libs/typeahead-js/typeahead.css" />
    <link rel="stylesheet" href="<?= base_url ?>assets/vendor/libs/apex-charts/apex-charts.css" />
    <link rel="stylesheet" href="<?= base_url ?>assets/vendor/libs/fullcalendar/fullcalendar.css" />
    <link rel="stylesheet" href="<?= base_url ?>assets/vendor/libs/flatpickr/flatpickr.css" />
    <link rel="stylesheet" href="<?= base_url ?>assets/vendor/libs/select2/select2.css" />
    <link rel="stylesheet" href="<?= base_url ?>assets/vendor/libs/quill/editor.css" />
    <link rel="stylesheet" href="<?= base_url ?>assets/vendor/libs/quill/katex.css" />


    <link rel="stylesheet" href="<?= base_url ?>assets/vendor/libs/formvalidation/dist/css/formValidation.min.css" />

    <link rel="stylesheet" href="<?= base_url ?>assets/vendor/libs/tagify/tagify.css" />
    <link rel="stylesheet" href="<?= base_url ?>assets/vendor/libs/bootstrap-select/bootstrap-select.css" />

    <!-- Page CSS -->
    <link rel="stylesheet" href="<?= base_url ?>assets/vendor/libs/sweetalert2/sweetalert2.css" />
    <link rel="stylesheet" href="<?= base_url ?>assets/vendor/css/pages/page-profile.css" />
    <link rel="stylesheet" href="<?= base_url ?>assets/vendor/css/pages/page-account-settings.css" />
    <link rel="stylesheet" href="<?= base_url ?>assets/vendor/libs/datatables-bs5/datatables.bootstrap5.css" />
    <link rel="stylesheet" href="<?= base_url ?>assets/vendor/libs/datatables-responsive-bs5/responsive.bootstrap5.css" />
    <link rel="stylesheet" href="<?= base_url ?>assets/vendor/libs/datatables-checkboxes-jquery/datatables.checkboxes.css" />
    <link rel="stylesheet" href="<?= base_url ?>assets/vendor/libs/datatables-buttons-bs5/buttons.bootstrap5.css" />
    <link rel="stylesheet" href="<?= base_url ?>assets/vendor/libs/datatables-rowgroup-bs5/rowgroup.bootstrap5.css" />

    <link rel="stylesheet" href="shepherd.css" />
    <script src="shepherd.mjs"></script>
    <!-- Helpers -->
    <script src="<?= base_url ?>assets/vendor/js/helpers.js"></script>

    <!-- Config -->
    <script src="<?= base_url ?>assets/js/config.js"></script>

    <style>
        body {
            font-family: "Inter", sans-serif !important;
            font-size: 0.9em !important;
        }
    </style>

    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.6.1/jquery.min.js"></script>

    <script>
        function loadNotifications() {
            $.get('fetch_notifications.php', function(data) {
                let notifs = JSON.parse(data);
                let notifList = '';

                if (notifs.length) {
                    notifs.forEach(notif => {
                        notifList += `
                    <li class="list-group-item list-group-item-action dropdown-notifications-item">
                        <div class="d-flex">
                            <a style="text-decoration: none;display:flex;" class="mark-as-read" href="${notif.notification_redirect}" data-id="${notif.notification_id}">
                                <div class="flex-shrink-0 me-3">
                                    <div class="avatar">
                                        <span class="avatar-initial rounded-circle bg-label-danger"></span>
                                    </div>
                                </div>
                                <div class="flex-grow-1">
                                    <h6 class="mb-1">${notif.notification_title}</h6>
                                    <p class="mb-0">${notif.notification_text}</p>
                                    <small class="text-muted">${notif.notification_date_created}</small>
                                </div>
                                <div class="flex-shrink-0 dropdown-notifications-actions">
                                    <span class="badge badge-dot"></span>
                                    <span class="bx bx-x"></span>
                                </div>
                            </a>
                        </div>
                    </li>`;
                    });
                } else {
                    notifList = '<li class="list-group-item">No new notifications</li>';
                }

                $('.dropdown-notifications-list ul').html(notifList);
                $('.badge-notifications').text(notifs.length);
            });
        }

        // Poll every 10 seconds
        setInterval(loadNotifications, 10000);
        loadNotifications();
    </script>

    <script>
        $(document).on('click', '.mark-as-read', function(e) {
            const notifId = $(this).data('id');

            // Mark as read before redirect
            $.post('mark_as_read.php', {
                id: notifId
            }, function(response) {
                if (response === 'success') {
                    // Continue to redirect
                    window.location.href = $('.mark-as-read[data-id="' + notifId + '"]').attr('href');
                }
            });

            e.preventDefault(); // Prevent immediate redirect
        });
    </script>

</head>

<body>
    <!-- Layout wrapper -->
    <div class="layout-wrapper layout-content-navbar">
        <div class="layout-container">
            <!-- Menu -->

            <aside id="layout-menu" class="layout-menu menu-vertical menu bg-menu-theme">
                <div class="app-brand demo">
                    <a href="index" class="app-brand-link">
                        <img src="<?= base_url ?>assets/img/logos/logo.png" style="width: 80px;" />
                    </a>

                    <a href="javascript:void(0);" class="layout-menu-toggle menu-link text-large ms-auto">
                        <i class="bx bx-chevron-left bx-sm align-middle"></i>
                    </a>
                </div>

                <div class="menu-inner-shadow"></div>

                <ul class="menu-inner py-1" id="sidebar">
                    <!-- Dashboards -->
                    <li class="menu-item <?= $_SESSION['page'] == 'home' ? 'active' : '' ?>">
                        <a href="index" class="menu-link">
                            <i class="menu-icon tf-icons bx bx-home-circle"></i>
                            <div data-i18n="Home">Home</div>
                        </a>
                    </li>

                    <!-- Components -->
                    <li class="menu-header small text-uppercase"><span class="menu-header-text">Management</span></li>



                    <li id="calendar-section" class="menu-item <?= $_SESSION['page'] == 'start' || $_SESSION['page'] == 'appointments' ? 'active' : '' ?>">
                        <a href="javascript:void(0);" class="menu-link menu-toggle">
                            <i class="menu-icon fa-regular fa-folder-open"></i>

                            <div data-i18n="Appointments">Appointments</div>
                        </a>
                        <ul class="menu-sub">
                            <li class="menu-item <?= $_SESSION['page'] == 'appointments' ? 'active' : '' ?>">
                                <a href="calendar" class="menu-link">
                                    <div data-i18n="Book Appointment">Book Appointment</div>
                                </a>
                            </li>
                            <li class="menu-item <?= $_SESSION['page'] == 'start' ? 'active' : '' ?>">
                                <a href="apply" class="menu-link">
                                    <div data-i18n="Start Application">Start Application</div>
                                </a>
                            </li>
                        </ul>

                    </li>

                    <li class="menu-item  <?= $_SESSION['page'] == 'uploads' ? 'active' : '' ?>">
                        <a href="view_uploads" class="menu-link">
                            <i class="menu-icon tf-icons bx bx-food-menu"></i>
                            <div data-i18n="Documents">Documents</div>
                        </a>
                    </li>


                    <li class="menu-item <?= $_SESSION['page'] == 'progress' ? 'active' : '' ?>">
                        <a href="progress" class="menu-link">
                            <i class="menu-icon tf-icons bx bx-calendar"></i>
                            <div data-i18n="Progress Tracker">Progress Tracker</div>
                        </a>
                    </li>



                    <li class="menu-item  <?= $_SESSION['page'] == 'email' ? 'active' : '' ?>">
                        <a href="email" class="menu-link">
                            <i class="menu-icon fa-regular fa-envelope"></i>
                            <div data-i18n="Email">Email</div>
                        </a>
                    </li>
                    <li id="messages-section" class="menu-item  <?= $_SESSION['page'] == 'chat' ? 'active' : '' ?>">
                        <a href="chat" class="menu-link">
                            <i class="menu-icon tf-icons bx bx-chat"></i>
                            <div data-i18n="Chat">Chat</div>
                        </a>
                    </li>

                    <!-- Components -->
                    <li class="menu-header small text-uppercase"><span class="menu-header-text">Your Profile</span></li>
                    <li class="menu-item <?= $_SESSION['page'] == 'profile' ? 'active' : '' ?>">
                        <a href="profile" class="menu-link">
                            <!-- <i class="menu-icon tf-icons bx bx-grid"></i> -->
                            <i class="menu-icon fa-regular fa-circle-user"></i>
                            <div data-i18n="Profile">Profile</div>
                        </a>
                    </li>

                    <li class="menu-item <?= $_SESSION['page'] == 'password' ? 'active' : '' ?>">
                        <a href="password" class="menu-link">
                            <i class="menu-icon fa-solid fa-unlock-keyhole"></i>
                            <div data-i18n="Change Password">Change Password</div>
                        </a>
                    </li>

                    <li class="menu-item">
                        <a href="?logout" class="menu-link">
                            <i class="menu-icon fa-solid fa-arrow-right-from-bracket"></i>
                            <div data-i18n="Logout">Logout</div>
                        </a>
                    </li>


                    <!-- Misc -->
                    <li class="menu-header small text-uppercase"><span class="menu-header-text">Misc</span></li>
                    <li class="menu-item">
                        <a href="#" target="_blank" class="menu-link">
                            <i class="menu-icon tf-icons bx bx-support"></i>
                            <div data-i18n="Support">Support</div>
                        </a>
                    </li>
                    <li class="menu-item">
                        <a href="?logout" target="_blank" class="menu-link">
                            <i class="menu-icon fa-solid fa-globe"></i>
                            <div data-i18n="Back To Web">Back To Web</div>
                        </a>
                    </li>
                </ul>
            </aside>
            <!-- / Menu -->

            <div class="layout-page">

                <nav
                    class="layout-navbar container-xxl navbar navbar-expand-xl navbar-detached align-items-center bg-navbar-theme"
                    id="layout-navbar">
                    <div class="layout-menu-toggle navbar-nav align-items-xl-center me-3 me-xl-0 d-xl-none">
                        <a class="nav-item nav-link px-0 me-xl-4" href="javascript:void(0)">
                            <i class="bx bx-menu bx-sm"></i>
                        </a>
                    </div>

                    <div class="navbar-nav-right d-flex align-items-center" id="navbar-collapse">
                        <!-- Search -->
                        <div class="navbar-nav align-items-center">
                            <div class="nav-item navbar-search-wrapper mb-0">
                                <a class="nav-item nav-link search-toggler px-0" href="javascript:void(0);">
                                    <i class="bx bx-search bx-sm"></i>
                                    <span class="d-none d-md-inline-block text-muted">Search (Ctrl+/)</span>
                                </a>
                            </div>
                        </div>
                        <!-- /Search -->

                        <ul class="navbar-nav flex-row align-items-center ms-auto">
                            <!-- Language -->
                            <li class="nav-item dropdown-language dropdown me-2 me-xl-0">
                                <a class="nav-link dropdown-toggle hide-arrow" href="javascript:void(0);" data-bs-toggle="dropdown">
                                    <i class="fi fi-ke fis rounded-circle fs-3 me-1"></i>
                                </a>
                                <ul class="dropdown-menu dropdown-menu-end">
                                    <li>
                                        <a class="dropdown-item" href="javascript:void(0);" data-language="en">
                                            <i class="fi fi-ke fis rounded-circle fs-4 me-1"></i>
                                            <span class="align-middle">English</span>
                                        </a>
                                    </li>
                                    <li>
                                        <a class="dropdown-item" href="javascript:void(0);" data-language="fr">
                                            <i class="fi fi-fr fis rounded-circle fs-4 me-1"></i>
                                            <span class="align-middle">France</span>
                                        </a>
                                    </li>
                                    <li>
                                        <a class="dropdown-item" href="javascript:void(0);" data-language="de">
                                            <i class="fi fi-de fis rounded-circle fs-4 me-1"></i>
                                            <span class="align-middle">German</span>
                                        </a>
                                    </li>
                                    <li>
                                        <a class="dropdown-item" href="javascript:void(0);" data-language="pt">
                                            <i class="fi fi-pt fis rounded-circle fs-4 me-1"></i>
                                            <span class="align-middle">Portuguese</span>
                                        </a>
                                    </li>
                                </ul>
                            </li>
                            <!--/ Language -->

                            <!-- Style Switcher -->
                            <li class="nav-item me-2 me-xl-0">
                                <a class="nav-link style-switcher-toggle hide-arrow" href="javascript:void(0);">
                                    <i class="bx bx-sm"></i>
                                </a>
                            </li>
                            <!--/ Style Switcher -->


                            <!-- Notification -->
                            <li class="nav-item dropdown-notifications navbar-dropdown dropdown me-3 me-xl-1">
                                <a
                                    class="nav-link dropdown-toggle hide-arrow"
                                    href="javascript:void(0);"
                                    data-bs-toggle="dropdown"
                                    data-bs-auto-close="outside"
                                    aria-expanded="false">
                                    <i class="bx bx-bell bx-sm"></i>
                                    <span class="badge bg-danger rounded-pill badge-notifications"></span>
                                </a>
                                <ul class="dropdown-menu dropdown-menu-end py-0">
                                    <li class="dropdown-menu-header border-bottom">
                                        <div class="dropdown-header d-flex align-items-center py-3">
                                            <h5 class="text-body mb-0 me-auto">Notification</h5>
                                            <a
                                                href="javascript:void(0)"
                                                class="dropdown-notifications-all text-body"
                                                data-bs-toggle="tooltip"
                                                data-bs-placement="top"
                                                title="Mark all as read"><i class="bx fs-4 bx-envelope-open"></i></a>
                                        </div>
                                    </li>
                                    <li class="dropdown-notifications-list scrollable-container">
                                        <ul class="list-group list-group-flush">

                                        </ul>
                                    </li>

                                </ul>
                            </li>
                            <!--/ Notification -->

                            <!-- User -->
                            <li class="nav-item navbar-dropdown dropdown-user dropdown">
                                <a class="nav-link dropdown-toggle hide-arrow" href="javascript:void(0);" data-bs-toggle="dropdown">
                                    <div class="avatar avatar-online">
                                        <img src="<?= image_url . $userImg ?>" alt style="height:40px;object-fit:cover;" class="w-px-40 rounded-circle" />
                                    </div>
                                </a>
                                <ul class="dropdown-menu dropdown-menu-end">
                                    <li>
                                        <a class="dropdown-item" href="pages-account-settings-account.html">
                                            <div class="d-flex">
                                                <div class="flex-shrink-0 me-3">
                                                    <div class="avatar avatar-online">
                                                        <img src="<?= image_url . $userImg ?>" alt style="height:40px;object-fit:cover;" class="w-px-40 rounded-circle" />
                                                    </div>
                                                </div>
                                                <div class="flex-grow-1">
                                                    <span class="fw-semibold d-block"><?= $user['user_name'] ?></span>
                                                    <small class="text-muted">User</small>
                                                </div>
                                            </div>
                                        </a>
                                    </li>
                                    <li>
                                        <div class="dropdown-divider"></div>
                                    </li>
                                    <li>
                                        <a class="dropdown-item" href="profile">
                                            <i class="bx bx-user me-2"></i>
                                            <span class="align-middle">My Profile</span>
                                        </a>
                                    </li>
                                    <li>
                                        <a class="dropdown-item" href="pages-account-settings-account.html">
                                            <i class="bx bx-cog me-2"></i>
                                            <span class="align-middle">Change Password</span>
                                        </a>
                                    </li>
                                    <li>
                                        <a class="dropdown-item" href="pages-account-settings-billing.html">
                                            <span class="d-flex align-items-center align-middle">
                                                <i class="flex-shrink-0 bx bx-credit-card me-2"></i>
                                                <span class="flex-grow-1 align-middle">All Notifications</span>
                                            </span>
                                        </a>
                                    </li>
                                    <li>
                                        <div class="dropdown-divider"></div>
                                    </li>
                                    <li>
                                        <a class="dropdown-item" href="#">
                                            <i class="bx bx-support me-2"></i>
                                            <span class="align-middle">Help</span>
                                        </a>
                                    </li>
                                    <li>
                                        <a class="dropdown-item" href="#">
                                            <i class="bx bx-help-circle me-2"></i>
                                            <span class="align-middle">FAQ</span>
                                        </a>
                                    </li>
                                    <li>
                                        <a class="dropdown-item" href="#">
                                            <i class="fa-solid fa-globe me-2"></i>
                                            <span class="align-middle">Webpage</span>
                                        </a>
                                    </li>
                                    <li>
                                        <div class="dropdown-divider"></div>
                                    </li>
                                    <li>
                                        <a class="dropdown-item" href="?logout" target="_blank">
                                            <i class="bx bx-power-off me-2"></i>
                                            <span class="align-middle">Log Out</span>
                                        </a>
                                    </li>
                                </ul>
                            </li>
                            <!--/ User -->
                        </ul>
                    </div>

                    <!-- Search Small Screens -->
                    <div class="navbar-search-wrapper search-input-wrapper d-none">
                        <input
                            type="text"
                            class="form-control search-input container-xxl border-0"
                            placeholder="Search..."
                            aria-label="Search..." />
                        <i class="bx bx-x bx-sm search-toggler cursor-pointer"></i>
                    </div>
                </nav>

                <!-- / Navbar -->

                <!-- Content wrapper -->
                <div class="content-wrapper">
                    <!-- Content -->

                    <!-- //HEADERENDSHERE// -->

                    <div class="container-xxl flex-grow-1 container-p-y">
                        <div class="row">
                            <div class="col-lg-12 mb-4 order-0">
                                <div class="card">
                                    <div class="d-flex align-items-end row">
                                        <div class="col-sm-7">
                                            <div class="card-body" id="profile-section">
                                                <h5 class="card-title text-primary">Welcome <?= $user['user_name'] ?> 🎉</h5>
                                                <?php
                                                if (!empty($bookings)) { ?>
                                                    <p class="mb-4">
                                                        You currently have <?= sizeof($bookings) ?> application being processed.
                                                        <br>
                                                        Click below to view its progress.
                                                    </p>
                                                    <a href="progress" class="btn btn-sm btn-label-primary">Track Progress</a>
                                                <?php
                                                } else { ?>
                                                    <p class="mb-4">
                                                        You dont have any applications yet.
                                                    </p>
                                                    <a href="calendar" class="btn btn-sm btn-label-primary">Apply Now</a>
                                                <?php
                                                }
                                                ?>

                                            </div>
                                        </div>
                                        <div class="col-sm-5 text-center text-sm-left">
                                            <div class="card-body pb-0 px-0 px-md-4">
                                                <img
                                                    src="<?= base_url ?>assets/img/bus.jpg"
                                                    height="140"
                                                    style="border-radius: 12px;margin-bottom:6px;"
                                                    alt="View Badge User"
                                                    data-app-dark-img="bus.jpg"
                                                    data-app-light-img="bus.jpg" />
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <!-- Activity Timeline -->
                            <div class="col-md-12 col-lg-12 order-4 order-lg-3">
                                <div class="card">
                                    <div class="card-header d-flex align-items-center justify-content-between">
                                        <h5 class="card-title m-0 me-2">Activity Timeline</h5>
                                        <div class="dropdown">
                                            <button
                                                class="btn p-0"
                                                type="button"
                                                id="timelineWapper"
                                                data-bs-toggle="dropdown"
                                                aria-haspopup="true"
                                                aria-expanded="false">
                                                <i class="bx bx-dots-vertical-rounded"></i>
                                            </button>
                                            <div class="dropdown-menu dropdown-menu-end" aria-labelledby="timelineWapper">
                                                <a class="dropdown-item" href="javascript:void(0);">Select All</a>
                                                <a class="dropdown-item" href="javascript:void(0);">Refresh</a>
                                                <a class="dropdown-item" href="javascript:void(0);">Share</a>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="card-body">
                                        <!-- Activity Timeline -->
                                        <ul class="timeline">
                                            <li class="timeline-item timeline-item-transparent">
                                                <span class="timeline-point timeline-point-primary"></span>
                                                <div class="timeline-event">
                                                    <div class="timeline-header mb-1">
                                                        <h6 class="mb-0">Signed Up To WSG</h6>
                                                        <small class="text-muted"><?= get_ordinal_day_month_year($user['user_date_created']) ?></small>
                                                    </div>
                                                </div>
                                            </li>

                                            <?php
                                            if (!empty($bookings)) {
                                                foreach ($bookings as $booking) { ?>
                                                    <li class="timeline-item timeline-item-transparent">
                                                        <span class="timeline-point timeline-point-info"></span>
                                                        <div class="timeline-event">
                                                            <div class="timeline-header mb-1">
                                                                <h5 class="mb-0">Appointment Booked</h5>
                                                                <small class="text-muted"><?= get_ordinal_day_month_year($booking['booking_date']) ?></small>
                                                            </div>
                                                            <p class="mb-2">You made an application for <?= get_ordinal_day_month_year($booking['booking_date']) ?> at <?= get_hours_mins($booking['booking_time']) ?></p>
                                                            <div class="d-flex flex-wrap">
                                                                <span style="font-weight:800;">TITLE:</span>
                                                                <span> <?= $booking['booking_title'] ?></span>
                                                            </div>

                                                        </div>
                                                    </li>

                                                    <?php
                                                    if (!empty($upload)) { ?>
                                                        <li class="timeline-item timeline-item-transparent">
                                                            <span class="timeline-point timeline-point-info"></span>
                                                            <div class="timeline-event">
                                                                <div class="timeline-header mb-1">
                                                                    <h5 class="mb-0">User Uploaded Documents</h5>
                                                                    <small class="text-muted"><?= get_ordinal_day_month_year($upload['upload_date_created']) ?></small>
                                                                </div>
                                                                <p class="mb-2">You uploaded documents at <?= get_hours_mins($upload['upload_date_created']) ?> </p>

                                                                <div class="d-table w-100" style="max-width: 600px;">
                                                                    <?php
                                                                    $files = [
                                                                        'CV' => $upload['upload_cv'],
                                                                        'Cover Letter' => $upload['upload_letter'],
                                                                        'Certificates' => $upload['upload_cert'],
                                                                        'Other' => $upload['upload_file']
                                                                    ];

                                                                    foreach ($files as $label => $filePath):
                                                                        if (!empty($filePath)):
                                                                    ?>
                                                                            <div class="d-table-row border-bottom py-2 align-middle">
                                                                                <div class="d-table-cell" style="padding-right: 20px; vertical-align: middle; width: 150px;">
                                                                                    <strong><?= $label ?></strong>
                                                                                </div>
                                                                                <div class="d-table-cell">
                                                                                    <a target="_blank" href="<?= file_url . $filePath ?>" class="d-flex align-items-center">
                                                                                        <img
                                                                                            src="<?= base_url ?>assets/img/icons/misc/pdf.png"
                                                                                            alt="PDF"
                                                                                            width="15"
                                                                                            class="me-2" />
                                                                                        <span class="fw-bold text-body">Click to download file</span>
                                                                                    </a>
                                                                                </div>
                                                                            </div>
                                                                    <?php
                                                                        endif;
                                                                    endforeach;
                                                                    ?>
                                                                </div>
                                                            </div>
                                                        </li>
                                                    <?php
                                                    }
                                                    ?>
                                            <?php
                                                }
                                            }

                                            ?>

                                            <?php
                                            if (!empty($progress)) {
                                                foreach ($progress as $p) {
                                                    $step = get_by_id('step', $p['step_id']);
                                            ?>
                                                    <li class="timeline-item timeline-item-transparent">
                                                        <span class="timeline-point timeline-point-info"></span>
                                                        <div class="timeline-event">
                                                            <div class="timeline-header mb-1">
                                                                <h5 class="mb-0"><?= $step['step_name'] ?></h5>
                                                                <small class="text-muted"><?= get_ordinal_day_month_year($p['progress_date_created']) ?></small>
                                                            </div>
                                                            <p class="mb-2">
                                                                Admin updated the application's status to <strong><?= $step['step_name'] ?></strong> at <?= get_hours_mins($p['progress_date_created'])  ?>.
                                                            </p>

                                                            <?php
                                                            if ($step['step_id'] == '5') { ?>
                                                                <div class="d-table w-100" style="max-width: 600px;">
                                                                    <?php
                                                                    $files = [
                                                                        'CV' => $doc['upload_cv'],
                                                                        'Cover Letter' => $doc['upload_letter'],
                                                                        'Certificates' => $doc['upload_cert'],
                                                                        'Other' => $doc['upload_file']
                                                                    ];

                                                                    foreach ($files as $label => $filePath):
                                                                        if (!empty($filePath)):
                                                                    ?>
                                                                            <div class="d-table-row border-bottom py-2 align-middle">
                                                                                <div class="d-table-cell" style="padding-right: 20px; vertical-align: middle; width: 150px;">
                                                                                    <strong><?= $label ?></strong>
                                                                                </div>
                                                                                <div class="d-table-cell">
                                                                                    <a target="_blank" href="<?= file_url . $filePath ?>" class="d-flex align-items-center">
                                                                                        <img
                                                                                            src="<?= base_url ?>assets/img/icons/misc/pdf.png"
                                                                                            alt="PDF"
                                                                                            width="15"
                                                                                            class="me-2" />
                                                                                        <span class="fw-bold text-body">Click to download file</span>
                                                                                    </a>
                                                                                </div>
                                                                            </div>
                                                                    <?php
                                                                        endif;
                                                                    endforeach;
                                                                    ?>
                                                                </div>
                                                            <?php
                                                            }
                                                            ?>
                                                        </div>
                                                    </li>

                                            <?php

                                                }
                                            }

                                            ?>
                                            <li class="timeline-end-indicator">
                                                <i class="bx bx-check-circle"></i>
                                            </li>
                                        </ul>
                                        <!-- /Activity Timeline -->
                                    </div>
                                </div>
                            </div>
                            <!--/ Activity Timeline -->

                        </div>
                    </div>
                    <!-- / Content -->



                    <!-- Footer -->
                    <footer class="content-footer footer bg-footer-theme">
                        <div class="container-xxl d-flex flex-wrap justify-content-between py-2 flex-md-row flex-column">
                            <div class="mb-2 mb-md-0">
                                © <?= date('Y') ?> made with ❤️ by <a href="http://www.crimsonhawkltd.co.ke/" target="_blank" class="footer-link fw-bolder">Crimson Hawk Limited</a>
                            </div>
                        </div>
                    </footer>
                    <!-- / Footer -->

                    <div class="content-backdrop fade"></div>
                </div>
                <!-- Content wrapper -->
            </div>
            <!-- / Layout page -->
        </div>

        <!-- Overlay -->
        <div class="layout-overlay layout-menu-toggle"></div>

        <!-- Drag Target Area To SlideIn Menu On Small Screens -->
        <div class="drag-target"></div>
    </div>

    <style>
        .MyDiver {
            margin-top: 100px;
            margin-bottom: 50px;
        }
    </style>
    <!-- / Layout wrapper -->
    <script>
        function image_preview(my_img, img_loader) {
            $(my_img).on("change", function(event) {
                console.log("Image selected");
                const file = event.target.files[0];
                if (file) {
                    const imgUrl = URL.createObjectURL(file);
                    $(img_loader).attr("src", imgUrl);
                    console.log("Preview URL:", imgUrl);
                }
            });
        }

        // Bind events immediately (not inside DOMContentLoaded again)
        image_preview("#my_img", "#img_loader");
        image_preview("#my_image", "#image_loader");
        image_preview("#my_image2", "#image_loader2");
        image_preview("#my_vid", "#vid_loader");
        image_preview("#menu", "#menu_loader");
        image_preview("#upload", "#uploadedAvatar");
    </script>

    <script>
        $(document).ready(function() {
            // datatable (jquery)

            console.log(<?= json_encode($column_defs) ?>);
            $(function() {
                var dt_basic_table = $('.datatables-basic');
                if (dt_basic_table.length) {
                    dt_basic = dt_basic_table.DataTable({
                        columns: <?= json_encode($column_defs) ?>,
                        columnDefs: [{
                                // For Responsive
                                className: 'control',
                                orderable: false,
                                searchable: false,
                                responsivePriority: 2,
                                targets: 0,
                                render: function(data, type, full, meta) {
                                    return '';
                                }
                            },


                            {
                                responsivePriority: 1
                            }
                        ],
                        dom: '<"card-header flex-column flex-md-row"<"head-label text-center"><"dt-action-buttons text-end pt-3 pt-md-0"B>><"row"<"col-sm-12 col-md-6"l><"col-sm-12 col-md-6 d-flex justify-content-center justify-content-md-end"f>>t<"row"<"col-sm-12 col-md-6"i><"col-sm-12 col-md-6"p>>',
                        displayLength: 10,
                        lengthMenu: [10, 25, 50, 75, 100],

                        buttons: [{
                            extend: 'collection',
                            className: 'btn btn-label-primary dropdown-toggle me-2',
                            text: '<i class="bx bx-export me-sm-1"></i> <span class="d-none d-sm-inline-block">Export</span>',
                            buttons: [{
                                    extend: 'print',
                                    text: '<i class="bx bx-printer me-1" ></i>Print',
                                    className: 'dropdown-item',
                                    exportOptions: {
                                        columns: <?php echo json_encode($column_indexes) ?>
                                    },
                                    customize: function(win) {
                                        //customize print view for dark
                                        $(win.document.body)
                                            .css('color', config.colors.headingColor)
                                            .css('border-color', config.colors.borderColor)
                                            .css('background-color', config.colors.bodyBg);
                                        $(win.document.body)
                                            .find('table')
                                            .addClass('compact')
                                            .css('color', 'inherit')
                                            .css('border-color', 'inherit')
                                            .css('background-color', 'inherit');
                                    }
                                },
                                {
                                    extend: 'csv',
                                    text: '<i class="bx bx-file me-1" ></i>Csv',
                                    className: 'dropdown-item',
                                    exportOptions: {
                                        columns: <?php echo json_encode($column_indexes) ?>
                                    }
                                },
                                {
                                    extend: 'excel',
                                    text: '<i class="bx bxs-file-export me-1"></i>Excel',
                                    className: 'dropdown-item',
                                    exportOptions: {
                                        columns: <?php echo json_encode($column_indexes) ?>
                                    }
                                },
                                {
                                    extend: 'pdf',
                                    text: '<i class="bx bxs-file-pdf me-1"></i>Pdf',
                                    className: 'dropdown-item',
                                    exportOptions: {
                                        columns: [3, 4, 5, 6, 7],
                                        // prevent avatar to be display
                                        format: {
                                            body: function(inner, coldex, rowdex) {
                                                if (inner.length <= 0) return inner;
                                                var el = $.parseHTML(inner);
                                                var result = '';
                                                $.each(el, function(index, item) {
                                                    if (item.classList !== undefined && item.classList.contains('user-name')) {
                                                        result = result + item.lastChild.firstChild.textContent;
                                                    } else if (item.innerText === undefined) {
                                                        result = result + item.textContent;
                                                    } else result = result + item.innerText;
                                                });
                                                return result;
                                            }
                                        }
                                    }
                                },
                                {
                                    extend: 'copy',
                                    text: '<i class="bx bx-copy me-1" ></i>Copy',
                                    className: 'dropdown-item',
                                    exportOptions: {
                                        columns: [3, 4, 5, 6, 7],
                                        // prevent avatar to be display
                                        format: {
                                            body: function(inner, coldex, rowdex) {
                                                if (inner.length <= 0) return inner;
                                                var el = $.parseHTML(inner);
                                                var result = '';
                                                $.each(el, function(index, item) {
                                                    if (item.classList !== undefined && item.classList.contains('user-name')) {
                                                        result = result + item.lastChild.firstChild.textContent;
                                                    } else if (item.innerText === undefined) {
                                                        result = result + item.textContent;
                                                    } else result = result + item.innerText;
                                                });
                                                return result;
                                            }
                                        }
                                    }
                                }
                            ]
                        }],
                        responsive: {
                            details: {
                                display: $.fn.dataTable.Responsive.display.modal({
                                    header: function(row) {
                                        var data = row.data();
                                        return 'Details of ' + data['full_name'];
                                    }
                                }),
                                type: 'column',
                                renderer: function(api, rowIdx, columns) {
                                    var data = $.map(columns, function(col, i) {
                                        return col.title !== '' // ? Do not show row in modal popup if title is blank (for check box)
                                            ?
                                            '<tr data-dt-row="' +
                                            col.rowIndex +
                                            '" data-dt-column="' +
                                            col.columnIndex +
                                            '">' +
                                            '<td>' +
                                            col.title +
                                            ':' +
                                            '</td> ' +
                                            '<td>' +
                                            col.data +
                                            '</td>' +
                                            '</tr>' :
                                            '';
                                    }).join('');

                                    return data ? $('<table class="table"/><tbody />').append(data) : false;
                                }
                            }
                        }
                    });
                }

                // Filter form control to default size
                // ? setTimeout used for multilingual table initialization
                setTimeout(() => {
                    $('.dataTables_filter .form-control').removeClass('form-control-sm');
                    $('.dataTables_length .form-select').removeClass('form-select-sm');
                }, 300);
            });

        });
    </script>


    <!-- Core JS -->
    <!-- build:js assets/vendor/js/core.js -->
    <script src="<?= base_url ?>assets/vendor/libs/jquery/jquery.js"></script>
    <script src="<?= base_url ?>assets/vendor/libs/popper/popper.js"></script>
    <script src="<?= base_url ?>assets/vendor/js/bootstrap.js"></script>
    <script src="<?= base_url ?>assets/vendor/libs/perfect-scrollbar/perfect-scrollbar.js"></script>

    <script src="<?= base_url ?>assets/vendor/libs/hammer/hammer.js"></script>
    <script src="<?= base_url ?>assets/vendor/libs/i18n/i18n.js"></script>
    <script src="<?= base_url ?>assets/vendor/libs/typeahead-js/typeahead.js"></script>

    <script src="<?= base_url ?>assets/vendor/js/menu.js"></script>
    <!-- endbuild -->

    <!-- Vendors JS -->
    <script src="<?= base_url ?>assets/vendor/libs/apex-charts/apexcharts.js"></script>
    <script src="<?= base_url ?>assets/vendor/libs/fullcalendar/fullcalendar.js"></script>
    <script src="<?= base_url ?>assets/vendor/libs/formvalidation/dist/js/FormValidation.min.js"></script>
    <script src="<?= base_url ?>assets/vendor/libs/formvalidation/dist/js/plugins/Bootstrap5.min.js"></script>
    <script src="<?= base_url ?>assets/vendor/libs/formvalidation/dist/js/plugins/AutoFocus.min.js"></script>
    <script src="<?= base_url ?>assets/vendor/libs/select2/select2.js"></script>
    <script src="<?= base_url ?>assets/vendor/libs/flatpickr/flatpickr.js"></script>
    <script src="<?= base_url ?>assets/vendor/libs/moment/moment.js"></script>

    <script src="<?= base_url ?>assets/vendor/libs/tagify/tagify.js"></script>
    <script src="<?= base_url ?>assets/vendor/libs/bootstrap-select/bootstrap-select.js"></script>
    <script src="<?= base_url ?>assets/vendor/libs/bloodhound/bloodhound.js"></script>
    <script src="<?= base_url ?>assets/js/forms-selects.js"></script>

    <!-- Main JS -->
    <script src="<?= base_url ?>assets/js/main.js"></script>

    <!-- Page JS -->
    <script src="<?= base_url ?>assets/js/dashboards-analytics.js"></script>
    <script src="<?= base_url ?>assets/js/pages-pricing.js"></script>

    <!-- Vendors JS -->
    <script src="<?= base_url ?>assets/vendor/libs/sweetalert2/sweetalert2.js"></script>
    <!-- Page JS -->
    <script src="<?= base_url ?>assets/js/extended-ui-sweetalert2.js"></script>
    <script src="<?= base_url ?>assets/js/extended-ui-timeline.js"></script>
    <script src="<?= base_url ?>assets/js/pages-profile.js"></script>
    <script src="<?= base_url ?>assets/vendor/libs/block-ui/block-ui.js"></script>
    <script src="<?= base_url ?>assets/vendor/libs/quill/katex.js"></script>
    <script src="<?= base_url ?>assets/vendor/libs/quill/quill.js"></script>
    <script src="<?= base_url ?>assets/js/tables-datatables-basic.js"></script>
    <script src="<?= base_url ?>assets/vendor/libs/datatables-bs5/datatables-bootstrap5.js"></script>


    <style>
        .d-table-cell {
            border: 1px solid;
            padding: 0.5em;
        }
    </style>

    <!-- //footerstartsHERE// -->
    <script>
        document.addEventListener('DOMContentLoaded', function() {

            console.log('DOMcontent Loaded');
            const tour = new Shepherd.Tour({
                defaultStepOptions: {
                    scrollTo: true,
                    cancelIcon: {
                        enabled: true
                    },
                    classes: 'shadow-md bg-purple-dark',
                    scrollToHandler: (element) => {
                        element.scrollIntoView({
                            behavior: 'smooth',
                            block: 'center'
                        });
                    }
                }
            });

            tour.addStep({
                id: 'step-1',
                text: 'Welcome to your dashboard! Let’s walk you through the features.',
                buttons: [{
                        text: 'Skip',
                        action: tour.cancel,
                        classes: 'shepherd-button-secondary'
                    },
                    {
                        text: 'Next',
                        action: tour.next
                    }
                ]
            });

            tour.addStep({
                id: 'step-2',
                text: 'This is your sidebar. Use it to navigate between sections.',
                attachTo: {
                    element: '#sidebar',
                    on: 'right'
                },
                buttons: [{
                        text: 'Back',
                        action: tour.back
                    },
                    {
                        text: 'Next',
                        action: tour.next
                    }
                ]
            });

            tour.addStep({
                id: 'step-3',
                text: 'Here’s your profile section.',
                attachTo: {
                    element: '#profile-section',
                    on: 'bottom'
                },
                buttons: [{
                        text: 'Back',
                        action: tour.back
                    },
                    {
                        text: 'Next',
                        action: tour.next
                    }
                ]
            });

            tour.addStep({
                id: 'step-4',
                text: 'This is your calendar with all your bookings.',
                attachTo: {
                    element: '#calendar-section',
                    on: 'top'
                },
                buttons: [{
                        text: 'Back',
                        action: tour.back
                    },
                    {
                        text: 'Next',
                        action: tour.next
                    }
                ]
            });

            tour.addStep({
                id: 'step-5',
                text: 'Check messages from here.',
                attachTo: {
                    element: '#messages-section',
                    on: 'left'
                },
                buttons: [{
                        text: 'Back',
                        action: tour.back
                    },
                    {
                        text: 'Finish',
                        action: tour.complete
                    }
                ]
            });

            // Start tour if first time (optional)
            if (!localStorage.getItem('hasSeenTour')) {
                tour.start();
                localStorage.setItem('hasSeenTour', 'true');
            }
        });
    </script>


</body>

</html>