<?php
$page = 'appointments';
include_once 'header.php';

// cout($bookings);
$dateCounts = [];
foreach ($bookings as $booking) {
    $date = $booking['booking_date'];
    $dateCounts[$date] = ($dateCounts[$date] ?? 0) + 1;
}

$blockedDates = [];
foreach ($dateCounts as $date => $count) {
    if ($count >= 2) {
        $blockedDates[] = $date;
    }
}
?>
<!-- Toast with Animation -->
<div
    class="bs-toast toast toast-ex animate__animated my-2"
    role="alert"
    aria-live="assertive"
    aria-atomic="true"
    data-bs-delay="2000">
    <div class="toast-header">
        <i class="bx bx-bell me-2"></i>
        <div class="me-auto fw-semibold">Invalid Date</div>
        <small></small>
        <button type="button" class="btn-close" data-bs-dismiss="toast" aria-label="Close"></button>
    </div>
    <div class="toast-body">You can't select a past date. Please choose a valid future date for booking.</div>
</div>
<!--/ Toast with Animation -->

<div class="container-xxl flex-grow-1 container-p-y">

    <div class="card mb-4 p-4">
        <div class="row mt-4">
            <!-- Navigation -->
            <div class="col-lg-3 col-md-4 col-12 mb-md-0 mb-3">
                <div class="d-flex justify-content-between flex-column mb-2 mb-md-0">
                    <ul class="nav nav-align-left nav-pills flex-column">
                        <li class="nav-item">
                            <button class="nav-link active" data-bs-toggle="tab" data-bs-target="#product">
                                <i class="bx bx-cog faq-nav-icon me-1"></i>
                                <span class="align-middle">Getting Started</span>
                            </button>
                        </li>
                        <li class="nav-item">
                            <button class="nav-link" data-bs-toggle="tab" data-bs-target="#payment">
                                <i class="bx bx-credit-card faq-nav-icon me-1"></i>
                                <span class="align-middle">Payment</span>
                            </button>
                        </li>
                        <li class="nav-item">
                            <button class="nav-link" data-bs-toggle="tab" data-bs-target="#cancellation">
                                <i class="bx bx-rotate-left faq-nav-icon me-1"></i>
                                <span class="align-middle">Tracking Progress
                                </span>
                            </button>
                        </li>
                        <li class="nav-item">
                            <button class="nav-link" data-bs-toggle="tab" data-bs-target="#delivery">
                                <i class="bx bx-shopping-bag faq-nav-icon me-1"></i>
                                <span class="align-middle">Travel Arrangements</span>
                            </button>
                        </li>


                    </ul>
                    <div class="d-none d-md-block">
                        <div class="mt-5">
                            <img
                                src="<?= base_url ?>assets/img/illustrations/sitting-girl-with-laptop-light.png"
                                class="img-fluid w-px-200"
                                alt="FAQ Image"
                                data-app-light-img="illustrations/sitting-girl-with-laptop-light.png"
                                data-app-dark-img="illustrations/sitting-girl-with-laptop-dark.png" />
                        </div>
                    </div>
                </div>
            </div>
            <!-- /Navigation -->

            <!-- FAQ's -->
            <div class="col-lg-9 col-md-8 col-12">
                <div class="tab-content py-0">
                    <div class="tab-pane fade  show active" id="product" role="tabpanel">
                        <div class="d-flex mb-3 gap-3">
                            <div>
                                <span class="badge bg-label-primary rounded-2">
                                    <i class="bx bx-camera bx-md"></i>
                                </span>
                            </div>
                            <div>
                                <h4 class="mb-0">
                                    <span class="align-middle">Getting Started</span>
                                </h4>
                                <span>Begin your journey with us in just a few steps.</span>
                            </div>
                        </div>
                        <div id="accordionProduct" class="accordion">
                            <div class="card">
                                <div id="accordionProduct-1" class="accordion-collapse collapse show">
                                    <div class="accordion-body">
                                        <p>
                                            Create an account or log in, fill out your application form with accurate details, and choose the service package that fits your needs—be it travel, accommodation, or career placement.
                                            Ensure you have your valid identification, travel documents (like a passport), academic or professional certificates (if applying for jobs), and any other relevant materials.
                                            We'll let you know exactly what's needed based on your chosen service.
                                        </p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="tab-pane fade" id="payment" role="tabpanel">
                        <div class="d-flex mb-3 gap-3">
                            <div>
                                <span class="badge bg-label-primary rounded-2">
                                    <i class="bx bx-credit-card bx-md"></i>
                                </span>
                            </div>
                            <div>
                                <h4 class="mb-0">
                                    <span class="align-middle">Payment</span>
                                </h4>
                                <span>Secure and flexible payment options.</span>
                            </div>
                        </div>
                        <div id="accordionPayment" class="accordion">
                            <div class="card accordion-item">

                                <div id="accordionPayment-1" class="accordion-collapse collapse show">
                                    <div class="accordion-body">
                                        <p>
                                            Once your application is reviewed, you'll receive an invoice. You can pay via mobile money. A confirmation will be sent once payment is verified.
                                            Copy the M-Pesa or Airtel Money message and paste it in the appropriate form.
                                        </p>
                                    </div>
                                </div>
                            </div>

                        </div>
                    </div>

                    <div class="tab-pane fade" id="cancellation" role="tabpanel">
                        <div class="d-flex mb-3 gap-3">
                            <div>
                                <span class="badge bg-label-primary rounded-2">
                                    <i class="bx bx-revision bx-md"></i>
                                </span>
                            </div>
                            <div>
                                <h4 class="mb-0"><span class="align-middle">Tracking Progress</span></h4>
                                <span>Stay updated every step of the way.</span>
                            </div>
                        </div>
                        <div id="accordionCancellation" class="accordion">
                            <div class="card accordion-item">


                                <div id="accordionCancellation-1" class="accordion-collapse collapse show">
                                    <div class="accordion-body">
                                        <p>
                                            Log into your dashboard anytime to check your application status, receive updates, or chat with a Watare support agent if you have questions. We believe in full transparency.
                                        </p>
                                    </div>
                                </div>
                            </div>

                        </div>
                    </div>

                    <div class="tab-pane fade" id="delivery" role="tabpanel">
                        <div class="d-flex mb-3 gap-3">
                            <div>
                                <span class="badge bg-label-primary rounded-2">
                                    <i class="bx bx-cart bx-md"></i>
                                </span>
                            </div>
                            <div>
                                <h4 class="mb-0">
                                    <span class="align-middle">Travel & Accommodation Arrangements</span>
                                </h4>
                                <span>Let us handle the logistics.</span>
                            </div>
                        </div>
                        <div id="accordionDelivery" class="accordion">
                            <div class="card accordion-item">


                                <div id="accordionDelivery-1" class="accordion-collapse collapse show">
                                    <div class="accordion-body">
                                        <p>
                                            If your service includes job placement, we offer interview coaching, CV reviews, and personalized tips to help you shine in your interviews with international employers.
                                            Once approved, we'll coordinate your flights, visas, and accommodation bookings. All details will be shared in advance, and support remains available throughout your transition.
                                        </p>
                                    </div>
                                </div>
                            </div>

                        </div>
                    </div>

                </div>
            </div>

        </div>
    </div>

    <div class="card app-calendar-wrapper">
        <div class="row g-0">
            <!-- Calendar Sidebar -->
            <div class="col app-calendar-sidebar" id="app-calendar-sidebar">
                <div class="border-bottom p-4 my-sm-0 mb-3">
                    <div class="d-grid">
                        <button
                            class="btn btn-primary btn-toggle-sidebar"
                            data-bs-toggle="offcanvas"
                            data-bs-target="#addEventSidebar"
                            aria-controls="addEventSidebar">
                            <i class="bx bx-plus me-1"></i>
                            <span class="align-middle">Add Booking</span>
                        </button>
                    </div>
                </div>
                <div class="p-4">
                    <!-- inline calendar (flatpicker) -->
                    <div class="ms-n2">
                        <div class="inline-calendar"></div>
                    </div>

                    <hr class="container-m-nx my-4" />
                    <!-- Filter -->
                    <div class="mb-4">
                        <small class="text-small text-muted text-uppercase align-middle">Filter</small>
                    </div>

                    <div class="form-check mb-2">
                        <input
                            class="form-check-input select-all"
                            type="checkbox"
                            id="selectAll"
                            data-value="all"
                            checked />
                        <label class="form-check-label" for="selectAll">View All</label>
                    </div>

                    <div class="app-calendar-events-filter">
                        <div class="form-check form-check-danger mb-2">
                            <input
                                class="form-check-input input-filter"
                                type="checkbox"
                                id="select-personal"
                                data-value="personal"
                                checked />
                            <label class="form-check-label" for="select-personal">Virtual</label>
                        </div>
                        <div class="form-check mb-2">
                            <input
                                class="form-check-input input-filter"
                                type="checkbox"
                                id="select-business"
                                data-value="business"
                                checked />
                            <label class="form-check-label" for="select-business">Physical</label>
                        </div>
                    </div>
                </div>
            </div>
            <!-- /Calendar Sidebar -->

            <!-- Calendar & Modal -->
            <div class="col app-calendar-content">
                <div class="card shadow-none border-0">
                    <div class="card-body pb-0">
                        <!-- FullCalendar -->
                        <div id="calendar"></div>
                    </div>
                </div>
                <div class="app-overlay"></div>
                <!-- FullCalendar Offcanvas -->
                <div
                    class="offcanvas offcanvas-end event-sidebar"
                    tabindex="-1"
                    id="addEventSidebar"
                    aria-labelledby="addEventSidebarLabel">
                    <div class="offcanvas-header border-bottom">
                        <h5 class="offcanvas-title mb-2" id="addEventSidebarLabel">Add Booking</h5>
                        <button
                            type="button"
                            class="btn-close text-reset"
                            data-bs-dismiss="offcanvas"
                            aria-label="Close"></button>
                    </div>
                    <div class="offcanvas-body">
                        <form class="event-form pt-0" method="POST" action="<?= model_url ?>booking">
                            <input type="hidden" name="eventId" id="eventId">

                            <div class="mb-3">
                                <label class="form-label" for="eventTitle">Title</label>
                                <input
                                    type="text"
                                    class="form-control"
                                    id="eventTitle"
                                    name="booking_title"
                                    placeholder="Event Title" />
                            </div>

                            <div class="mb-3">
                                <label class="form-label" for="eventLabel">Label</label>
                                <select class="select2 select-event-label form-select" id="eventLabel" name="booking_props">
                                    <option data-label="success" value="Business" selected>Physical</option>
                                    <option data-label="info" value="Personal">Virtual</option>
                                </select>
                            </div>

                            <div class="mb-3">
                                <label class="form-label" for="eventStartDate">Start Date</label>
                                <input
                                    type="text"
                                    class="form-control"
                                    id="eventStartDate"
                                    name="booking_date"
                                    placeholder="Start Date" />
                            </div>


                            <div class="mb-3">
                                <label class="form-label" for="eventDescription">M-Pesa Transaction ID</label>
                                <textarea class="form-control" name="booking_description" id="eventDescription"></textarea>
                            </div>
                            <div class="mb-3 d-flex justify-content-sm-between justify-content-start my-4">
                                <div>
                                    <button type="submit" class="btn btn-primary btn-add-event me-sm-3 me-1">Add</button>
                                    <button
                                        type="reset"
                                        class="btn btn-label-secondary btn-cancel me-sm-0 me-1"
                                        data-bs-dismiss="offcanvas">
                                        Cancel
                                    </button>
                                </div>
                                <div>
                                    <button type="button" id="deleteBookingBtn" data-id="eventId" class="btn btn-label-danger btn-delete-event d-none">Delete</button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
            <!-- /Calendar & Modal -->
        </div>
    </div>
</div>
<!-- / Content -->

<script>
    const toastAnimationExample = document.querySelector('.toast-ex'),
        toastPlacementExample = document.querySelector('.toast-placement-ex'),
        toastAnimationBtn = document.querySelector('#showToastAnimation'),
        toastPlacementBtn = document.querySelector('#showToastPlacement');
    let selectedType, selectedAnimation, selectedPlacement, toast, toastAnimation, toastPlacement;

    // Animation Button click
    if (toastAnimationBtn) {
        toastAnimationBtn.onclick = function() {
            if (toastAnimation) {
                toastDispose(toastAnimation);
            }

            toastAnimationExample.classList.add('bg-danger', 'animate__fade');
            toastAnimation = new bootstrap.Toast(toastAnimationExample);
            toastAnimation.show();
        };
    }

    function toastDispose(toast) {
        if (toast && toast._element !== null) {
            toastAnimationExample.classList.add('bg-danger', 'animate__fade');
            toast.dispose();
        }
    }
</script>

<script>
    let date = new Date();
    let nextDay = new Date(new Date().getTime() + 24 * 60 * 60 * 1000);
    // prettier-ignore
    let nextMonth = date.getMonth() === 11 ? new Date(date.getFullYear() + 1, 0, 1) : new Date(date.getFullYear(), date.getMonth() + 1, 1);
    // prettier-ignore
    let prevMonth = date.getMonth() === 11 ? new Date(date.getFullYear() - 1, 0, 1) : new Date(date.getFullYear(), date.getMonth() - 1, 1);

    let events = [
        <?php foreach ($bookings as $index => $booking): ?> {
                id: <?= json_encode($booking['booking_id']) ?>,
                url: '', // you can set this to a booking details page if needed
                title: <?= json_encode($booking['booking_title']) ?>,
                start: new Date("<?= $booking['booking_date'] . 'T' . $booking['booking_time'] ?>"),
                end: new Date("<?= $booking['booking_date'] . 'T' . $booking['booking_time'] ?>"),
                description: <?= json_encode($booking['booking_description']) ?>,
                allDay: false,
                extendedProps: {
                    calendar: <?= json_encode($booking['booking_props']) ?>,
                }
            }
            <?= $index + 1 < count($bookings) ? ',' : '' ?>
        <?php endforeach; ?>
    ];


    document.getElementById('deleteBookingBtn').addEventListener('click', function() {
        const bookingId = this.getAttribute('data-id');

        if (!bookingId) {
            alert('No event selected.');
            return;
        }

        if (confirm('Are you sure you want to delete this booking?')) {
            // Redirect to delete URL
            window.location.href = `<?= delete_url ?>id=${bookingId}&table=booking&page=calendar&method=simple_admin&isClient=true`;
        }
    });
</script>

<script>
    let direction = 'ltr';
    let blockedDates = <?= json_encode($blockedDates) ?>;

    document.addEventListener('DOMContentLoaded', function() {
        (function() {
            const calendarEl = document.getElementById('calendar'),
                appCalendarSidebar = document.querySelector('.app-calendar-sidebar'),
                addEventSidebar = document.getElementById('addEventSidebar'),
                appOverlay = document.querySelector('.app-overlay'),
                calendarsColor = {
                    Business: 'success',
                    Personal: 'info'
                },
                offcanvasTitle = document.querySelector('.offcanvas-title'),
                btnToggleSidebar = document.querySelector('.btn-toggle-sidebar'),
                btnSubmit = document.querySelector('button[type="submit"]'),
                btnDeleteEvent = document.querySelector('.btn-delete-event'),
                btnCancel = document.querySelector('.btn-cancel'),
                eventTitle = document.querySelector('#eventTitle'),
                eventStartDate = document.querySelector('#eventStartDate'),
                eventEndDate = document.querySelector('#eventEndDate'),
                eventLabel = $('#eventLabel'),
                eventDescription = document.querySelector('#eventDescription'),
                eventId = document.querySelector('#eventId'),
                selectAll = document.querySelector('.select-all'),
                filterInput = [].slice.call(document.querySelectorAll('.input-filter')),
                inlineCalendar = document.querySelector('.inline-calendar');

            let eventToUpdate,
                currentEvents = events,
                isFormValid = false,
                inlineCalInstance;

            const bsAddEventSidebar = new bootstrap.Offcanvas(addEventSidebar);

            if (eventLabel.length) {
                function renderBadges(option) {
                    if (!option.id) {
                        return option.text;
                    }
                    var $badge =
                        "<span class='badge badge-dot bg-" + $(option.element).data('label') + " me-2'> " + '</span>' + option.text;

                    return $badge;
                }
                eventLabel.wrap('<div class="position-relative"></div>').select2({
                    placeholder: 'Select value',
                    dropdownParent: eventLabel.parent(),
                    templateResult: renderBadges,
                    templateSelection: renderBadges,
                    minimumResultsForSearch: -1,
                    escapeMarkup: function(es) {
                        return es;
                    }
                });
            }

          
          

            function fetchEvents(info, successCallback) {
                let calendars = selectedCalendars();

                const backgroundBlocks = blockedDates.map(date => ({
                    start: date,
                    end: date,
                    display: 'background',
                    backgroundColor: '#ff0040',
                    rendering: 'background'
                }));

                let selectedEvents = currentEvents.filter(event =>
                    calendars.includes(event.extendedProps.calendar.toLowerCase())
                );

                successCallback([...selectedEvents, ...backgroundBlocks]);
            }

            let calendar = new Calendar(calendarEl, {
                initialView: 'dayGridMonth',
                events: fetchEvents,
                plugins: [dayGridPlugin, interactionPlugin, listPlugin, timegridPlugin],
                editable: true,
                dragScroll: true,
                dayMaxEvents: 2,
                eventResizableFromStart: true,
                customButtons: {
                    sidebarToggle: {
                        text: 'Sidebar'
                    }
                },
                headerToolbar: {
                    start: 'sidebarToggle, prev,next, title',
                    end: 'dayGridMonth,timeGridWeek,timeGridDay,listMonth'
                },
                direction: direction,
                initialDate: new Date(),
                navLinks: true,
                eventClassNames: function({
                    event: calendarEvent
                }) {
                    const colorName = calendarsColor[calendarEvent._def.extendedProps.calendar];
                    return ['fc-event-' + colorName];
                },
                dateClick: function(info) {
                    let clickedDate = moment(info.date).format('YYYY-MM-DD');

                    const normalizedBlockedDates = blockedDates.map(date => moment(date).format('YYYY-MM-DD'));

                    const today = moment().startOf('day');
                    const clicked = moment(info.date).startOf('day');

                    if (clicked.isBefore(today) || normalizedBlockedDates.includes(clicked.format('YYYY-MM-DD'))) {
                        const toastEl = document.querySelector('.toast-ex');

                        if (toastEl) {
                            toastEl.classList.remove('bg-danger');
                            toastEl.classList.add('bg-warning');
                            const toast = new bootstrap.Toast(toastEl);
                            toast.show();
                        }

                        return;
                    }

                    resetValues();
                    bsAddEventSidebar.show();

                    if (offcanvasTitle) {
                        offcanvasTitle.innerHTML = 'Add Event';
                    }
                    btnSubmit.innerHTML = 'Add';
                    btnSubmit.classList.remove('btn-update-event');
                    btnSubmit.classList.add('btn-add-event');
                    btnDeleteEvent.classList.add('d-none');
                    eventStartDate.value = clickedDate;
                    eventEndDate.value = clickedDate;
                },
                eventClick: function(info) {
                    eventClick(info);
                },
                datesSet: function() {
                    modifyToggler();
                },
                viewDidMount: function() {
                    modifyToggler();
                }
            });

            calendar.render();
            modifyToggler();

            const eventForm = document.getElementById('eventForm');
            const fv = FormValidation.formValidation(eventForm, {
                    fields: {
                        eventTitle: {
                            validators: {
                                notEmpty: {
                                    message: 'Please enter event title '
                                }
                            }
                        },
                        eventStartDate: {
                            validators: {
                                notEmpty: {
                                    message: 'Please enter start date '
                                }
                            }
                        },
                        eventEndDate: {
                            validators: {
                                notEmpty: {
                                    message: 'Please enter end date '
                                }
                            }
                        }
                    },
                    plugins: {
                        trigger: new FormValidation.plugins.Trigger(),
                        bootstrap5: new FormValidation.plugins.Bootstrap5({
                            eleValidClass: '',
                            rowSelector: function(field, ele) {
                                return '.mb-3';
                            }
                        }),
                        submitButton: new FormValidation.plugins.SubmitButton(),
                        autoFocus: new FormValidation.plugins.AutoFocus()
                    }
                })
                .on('core.form.valid', function() {
                    isFormValid = true;
                })
                .on('core.form.invalid', function() {
                    isFormValid = false;
                });

         
            function addEvent(eventData) {
                currentEvents.push(eventData);
                calendar.refetchEvents();
            }

            function updateEvent(eventData) {
                eventData.id = parseInt(eventData.id);
                currentEvents[currentEvents.findIndex(el => el.id === eventData.id)] = eventData; // Update event by id
                calendar.refetchEvents();
            }


            btnSubmit.addEventListener('click', e => {
                if (btnSubmit.classList.contains('btn-add-event')) {
                    if (isFormValid) {
                        let newEvent = {
                            id: calendar.getEvents().length + 1,
                            title: eventTitle.value,
                            start: eventStartDate.value,
                            end: eventEndDate.value,
                            startStr: eventStartDate.value,
                            endStr: eventEndDate.value,
                            description: eventDescription.value,
                            display: 'block',
                            extendedProps: {
                                calendar: eventLabel.val(),
                            }
                        };
                        addEvent(newEvent);
                        bsAddEventSidebar.hide();
                    }
                } else {
                    // Update event
                    // ------------------------------------------------
                    if (isFormValid) {
                        let eventData = {
                            id: eventToUpdate.id,
                            title: eventTitle.value,
                            start: eventStartDate.value,
                            end: eventEndDate.value,
                            description: eventDescription.value,
                            extendedProps: {
                                calendar: eventLabel.val(),
                            },
                            display: 'block'
                        };

                        updateEvent(eventData);
                        bsAddEventSidebar.hide();
                    }
                }
            });

       

            function resetValues() {
                eventTitle.value = '';
                eventStartDate.value = '';
                eventLabel.value = '';
                eventDescription.value = '';
                if (eventId) eventId.value = '';
            }


            if (selectAll) {
                selectAll.addEventListener('click', e => {
                    if (e.currentTarget.checked) {
                        document.querySelectorAll('.input-filter').forEach(c => (c.checked = 1));
                    } else {
                        document.querySelectorAll('.input-filter').forEach(c => (c.checked = 0));
                    }
                    calendar.refetchEvents();
                });
            }

            if (filterInput) {
                filterInput.forEach(item => {
                    item.addEventListener('click', () => {
                        document.querySelectorAll('.input-filter:checked').length < document.querySelectorAll('.input-filter').length ?
                            (selectAll.checked = false) :
                            (selectAll.checked = true);
                        calendar.refetchEvents();
                    });
                });
            }

      
        })();
    });
</script>


<?php include_once 'footer.php' ?>