<?php
$page = 'chat';
include_once 'header.php';
$users = get_all('user');

?>

<div class="container-xxl flex-grow-1 container-p-y">
    <div class="app-chat overflow-hidden card">
        <div class="row g-0">
     
            <!-- Chat & Contacts -->
            <div
                class="col app-chat-contacts app-sidebar flex-grow-0 overflow-hidden border-end"
                id="app-chat-contacts">
                <div class="sidebar-header pt-3 px-3 mx-1">
                    <div class="d-flex align-items-center me-3 me-lg-0">
                        <div
                            class="flex-shrink-0 avatar avatar-online me-2"
                            data-bs-toggle="sidebar"
                            data-overlay="app-overlay-ex"
                            data-target="#app-chat-sidebar-left">
                            <img
                                class="user-avatar rounded-circle cursor-pointer"
                                src="<?= base_url ?>assets/img/illustrations/admin.png"
                                alt="Avatar" />
                        </div>
                        <div class="flex-grow-1 input-group input-group-merge rounded-pill ms-1">
                            <span class="input-group-text" id="basic-addon-search31"><i class="bx bx-search fs-4"></i></span>
                            <input
                                type="text"
                                class="form-control chat-search-input"
                                placeholder="Search..."
                                aria-label="Search..."
                                aria-describedby="basic-addon-search31" />
                        </div>
                    </div>
                    <i
                        class="bx bx-x cursor-pointer position-absolute top-0 end-0 mt-2 me-1 fs-4 d-lg-none d-block"
                        data-overlay
                        data-bs-toggle="sidebar"
                        data-target="#app-chat-contacts"></i>
                </div>
                <hr class="container-m-nx mt-3 mb-0" />
                <div class="sidebar-body">
                    <!-- Chats -->
                    <ul class="list-unstyled chat-contact-list pt-1" id="chat-list">
                        <li class="chat-contact-list-item chat-contact-list-item-title">
                            <h5 class="text-primary mb-0">Chats</h5>
                        </li>
                        <!-- This is where AJAX will inject chat users -->
                        <li class="chat-contact-list-item chat-list-item-0">
                            <h6 class="text-muted mb-0">Admin</h6>
                        </li>
                    </ul>

                    <!-- Contacts -->
                    <ul class="list-unstyled chat-contact-list mb-0" id="contact-list">
                        <li class="chat-contact-list-item chat-contact-list-item-title">
                            <h5 class="text-primary mb-0">Contacts</h5>
                        </li>
                        <!-- AJAX will inject contacts here -->
                        <li class="chat-contact-list-item contact-list-item-0 d-none">
                            <h6 class="text-muted mb-0">No Contacts Found</h6>
                        </li>
                    </ul>
                </div>
            </div>
            <!-- /Chat contacts -->

            <!-- Chat History -->
            <div class="col app-chat-history">
                <div class="chat-history-wrapper">
                    <div class="chat-history-header border-bottom">
                        <div class="d-flex justify-content-between align-items-center">
                            <div class="d-flex overflow-hidden align-items-center">
                                <i
                                    class="bx bx-menu bx-sm cursor-pointer d-lg-none d-block me-2"
                                    data-bs-toggle="sidebar"
                                    data-overlay
                                    data-target="#app-chat-contacts"></i>
                                <div class="flex-shrink-0 avatar" id="chat-header-avatar">
                                    <img
                                        src="<?= base_url ?>assets/img/illustrations/admin.png"
                                        alt="Avatar"
                                        class="rounded-circle" />
                                </div>
                                <div class="chat-contact-info flex-grow-1 ms-3">
                                    <h6 class="m-0" id="chat-header-name">Admin</h6>
                                    <small class="user-status text-muted" id="chat-header-status"></small>
                                </div>
                            </div>
                            <div class="d-flex align-items-center">
                                <i class="bx bx-phone-call cursor-pointer d-sm-block d-none me-3 fs-4"></i>
                                <i class="bx bx-video cursor-pointer d-sm-block d-none me-3 fs-4"></i>
                                <i class="bx bx-search cursor-pointer d-sm-block d-none me-3 fs-4"></i>
                                <div class="dropdown">
                                    <button
                                        class="btn p-0"
                                        type="button"
                                        id="chat-header-actions"
                                        data-bs-toggle="dropdown"
                                        aria-haspopup="true"
                                        aria-expanded="false">
                                        <i class="bx bx-dots-vertical-rounded fs-4"></i>
                                    </button>
                                    <div class="dropdown-menu dropdown-menu-end" aria-labelledby="chat-header-actions">
                                        <a class="dropdown-item" href="javascript:void(0);">View Contact</a>
                                        <a class="dropdown-item" href="javascript:void(0);">Mute Notifications</a>
                                        <a class="dropdown-item" href="javascript:void(0);">Block Contact</a>
                                        <a class="dropdown-item" href="javascript:void(0);">Clear Chat</a>
                                        <a class="dropdown-item" href="javascript:void(0);">Report</a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="chat-history-body">
                        <ul class="list-unstyled chat-history mb-0" id="chat-body">
                            <!-- AJAX will inject chat messages here -->
                        </ul>
                    </div>
                    <!-- Chat message form -->
                    <div class="chat-history-footer">
                        <form class="form-send-message d-flex justify-content-between align-items-center" id="chat-message-form" onsubmit="return false;">
                            <input
                                id="chat-message-input"
                                name="chat_message"
                                class="form-control message-input border-0 me-3 shadow-none"
                                placeholder="Type your message here..."
                                autocomplete="off" />
                            <div class="message-actions d-flex align-items-center">
                                <i class="speech-to-text bx bx-microphone bx-sm cursor-pointer"></i>
                                <label for="attach-doc" class="form-label mb-0">
                                    <i class="bx bx-paperclip bx-sm cursor-pointer mx-3"></i>
                                    <input type="file" id="attach-doc" hidden />
                                </label>
                                <button type="submit" class="btn btn-primary d-flex send-msg-btn">
                                    <i class="bx bx-paper-plane me-md-1 me-0"></i>
                                    <span class="align-middle d-md-inline-block d-none">Send</span>
                                </button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
            <!-- /Chat History -->
            <div class="app-overlay"></div>
        </div>
    </div>
</div>


<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

<script>
    $(document).ready(function() {
        let pollingInterval;

        function startPolling() {
            stopPolling(); // prevent duplicates
            pollingInterval = setInterval(loadChatHistory, 3000); // every 3 seconds
        }

        function stopPolling() {
            if (pollingInterval) {
                clearInterval(pollingInterval);
            }
        }

        function formatTimestamp(datetime) {
            const date = new Date(datetime);
            const days = ['Sun', 'Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat'];
            const months = [
                'Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun',
                'Jul', 'Aug', 'Sep', 'Oct', 'Nov', 'Dec'
            ];

            const dayName = days[date.getDay()];
            const day = date.getDate();
            const suffix = (d => {
                if (d > 3 && d < 21) return 'th';
                switch (d % 10) {
                    case 1:
                        return 'st';
                    case 2:
                        return 'nd';
                    case 3:
                        return 'rd';
                    default:
                        return 'th';
                }
            })(day);
            const monthName = months[date.getMonth()];
            let hours = date.getHours();
            const minutes = date.getMinutes().toString().padStart(2, '0');
            const ampm = hours >= 12 ? 'pm' : 'am';
            hours = hours % 12 || 12;

            return `${dayName}, ${day}${suffix} ${monthName}. ${hours}:${minutes}${ampm}`;
        }


        const $chatBody = $('#chat-body');
        const $messageInput = $('#chat-message-input');
        let adminId = '1'; // or fetch dynamically if needed
        let userId = '<?= $user['user_id'] ?>'; // your logged-in user ID

        // Load chat history between user and admin
        function loadChatHistory() {
            $.get('get_chat_history.php?user_id=' + userId, function(data) {
                data = JSON.parse(data);
                $chatBody.empty();

                if (data.messages && data.messages.length) {
                    console.log(data.messages);
                    $.each(data.messages, function(i, msg) {
                        const isUser = (msg.chat_sender_role === 'client');
                        $chatBody.append(`
                            <li class="chat-message ${isUser ? ' chat-message-right' : ''}">
                                <div class="d-flex overflow-hidden">
                                    <div class="user-avatar flex-shrink-0 me-3">
                                    ${isUser ? '' : ' <div class="avatar avatar-sm"> <img src="../assets/img/illustrations/admin.png" alt="Avatar" class="rounded-circle" /></div>'}
                                    </div>
                                    <div class="chat-message-wrapper flex-grow-1">
                                        <div class="chat-message-text">
                                            <p class="mb-0">${msg.chat_message}</p>
                                        </div>
                                        <small>${formatTimestamp(msg.chat_timestamp)}</small>
                                    </div>
                                </div>
                            </li>
                        `);
                    });
                } else {
                    $chatBody.append('<li class="text-muted small">No messages yet. Say hello!</li>');
                }

                $chatBody.scrollTop($chatBody[0].scrollHeight);
            });
        }


        // Send message
        function sendMessage(message) {
            if (!message.trim()) return;

            $.post('send_user_message.php', {
                message: message
            }).done(function(response) {
                response = JSON.parse(response);
                if (response.success) {
                    $messageInput.val('');
                    loadChatHistory();
                } else {
                    alert(response.error || 'Message not sent');
                }
            }).fail(function() {
                alert('Request failed');
            });
        }

        // Initial load
        loadChatHistory();
        startPolling();

        // Submit handler
        $('#chat-message-form').on('submit', function(e) {
            e.preventDefault();
            sendMessage($messageInput.val());
        });
    });
</script>


<?php include_once 'footer.php' ?>