<?php
$page = 'start';
include_once 'header.php';
$countries = get_dropdown_data(get_all('country'), 'country_name', 'country_id');
// $jobs = get_all('job');
$jobs = select_rows("SELECT * FROM job ORDER BY job_category ASC ");

$booking = $bookings[0];

if (empty($uploads)) {
    $noDoc = true;
    $display = 'block';
} else {
    $noDoc = false;
    $display = 'none';
}

$column_indexes = range(0, $num_columns - 1);

$upload = $uploads[0];
// Create an array of column definition objects

$column_defs = array(
    array('data' => 'user_1', 'title' => ''),
    array('data' => 'user_email', 'title' => '#'),
    array('data' => 'col1_' . $i, 'title' => 'Job Title'),
    array('data' => 'col2_' . $i, 'title' => 'Category'),
    array('data' => 'col3_' . $i, 'title' => 'Location'),
);

$num_columns = sizeof($column_defs);
$column_indexes = range(0, $num_columns - 1);

?>

<div class="container-xxl flex-grow-1 container-p-y">

    <?php
    if (!empty($booking)) {
        if (!$noDoc) { ?>
            <div class="card">
                <div class="container mb-4">
                    <h2 class="text-center mb-2 mt-0 mt-md-4 ">Please Note</h2>
                    <p class="text-center pb-3">
                        You have already uploaded documents for this appointment.
                        If you choose to add new files at this stage, they will replace the previously submitted documents. Kindly ensure that the new uploads include all necessary information, as the original files will no longer be available once overwritten.
                    </p>
                    <button class="btn btn-outline-danger" style="width:300px;display:block;margin:auto;" type="button" id="openCard">
                        Overwrite Previous Docs
                    </button>
                </div>
            </div>
        <?php
        }
        ?>


        <div id="secondCard" class="card overflow-hidden mt-4" style="display:<?= $display ?>;">
            <!-- Pricing Plans -->
            <div class="pb-sm-5 pb-2 rounded-top">
                <div class="container py-5">
                    <h2 class="text-center mb-2 mt-0 mt-md-4">Start Your Application Now</h2>
                    <p class="text-center pb-3">
                        Get started with us - it's perfect for individuals and teams.
                    </p>

                </div>
            </div>
            <!--/ Pricing Plans -->
            <!-- Pricing Free Trial -->
            <div class="pricing-free-trial">
                <div class="container">
                    <div class="position-relative">
                        <div
                            class="d-flex justify-content-between flex-column-reverse flex-lg-row align-items-center py-4 px-5">
                            <div class="text-center text-lg-start mt-2 ms-3">
                                <h3 class="text-primary mb-1">Need a quick recap of the application process?</h3>
                                <p class="text-body mb-1">If you'd like to review the steps again before proceeding, you can go back and revisit the application guide at any time.</p>
                                <a href="#" class="btn btn-primary mt-4 mb-2">View Application Guide</a>

                            </div>
                            <!-- image -->
                            <img
                                src="<?= base_url ?>assets/img/woman.jpg"
                                class="img-fluid w-px-200"
                                alt="FAQ Image"
                                style="border-radius: 12px;margin-bottom:6px;"
                                data-app-light-img="woman.jpg"
                                data-app-dark-img="woman.jpg" />
                        </div>
                    </div>
                </div>
            </div>
            <!--/ Pricing Free Trial -->


            <!-- Plans Comparison -->
            <div class="pricing-plans-comparison">
                <div class="container py-5 px-lg-5">
                    <div class="row mt-0 mt-md-4">
                        <div class="col-12 text-center mb-4">
                            <h2 class="mb-2">Available Jobs</h2>

                            <table class="datatables-basic table border-top">
                                <thead>
                                    <tr>
                                        <?php foreach ($column_defs as $col): ?>
                                            <th><?= htmlspecialchars($col['title']) ?></th>
                                        <?php endforeach; ?>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php
                                    $cnt = 1;
                                    foreach ($jobs as $j) {
                                    ?>
                                        <tr>
                                            <td></td>
                                            <td><?= $cnt ?></td>

                                            <td> <?= $j['job_name'] ?> </td>
                                            <td> <?= get_by_id('category', $j['job_category'])['category_name'] ?> </td>
                                            <td> <?= $j['job_location'] ?> </td>


                                        </tr>
                                    <?php
                                        $cnt++;
                                    }
                                    ?>
                                </tbody>

                            </table>

                        </div>
                    </div>
                </div>
            </div>
            <!--/ Plans Comparison -->

            <!-- Plans Comparison -->
            <div class="pricing-plans-comparison">
                <div class="container py-5 px-lg-5">
                    <div class="row mt-0 mt-md-4">
                        <div class="col-12 text-center mb-4">
                            <h2 class="mb-2">Fill in the form below</h2>
                            <p>The documents will be attached to the appointment booked at
                                <strong> <?= get_ordinal_day_month_year($booking['booking_date_created']) ?></strong>
                                on
                                <strong><?= get_hours_mins($booking['booking_date_created']) ?></strong>
                                with the payment transaction
                                <strong><?= $booking['booking_description'] ?></strong>
                            </p>
                        </div>
                    </div>
                    <form method="POST" enctype="multipart/form-data" action="<?= model_url ?>upload">
                        <input type="hidden" name="booking_id" value="<?= $booking['booking_id'] ?>">

                        <div class="row mx-4">
                            <div class="divider MyDiver">
                                <div class="divider-text">Bio Data</div>
                            </div>
                            <div class="col-lg-12 col-sm-12 col-12">
                                <?= input_hybrid('Name', 'user_name', $user, false, '', '', '', '', true) ?>
                            </div>

                            <div class="col-lg-6 col-sm-12 col-12">
                                <?= input_hybrid('Phone Number', 'user_phone', $user, true) ?>
                                <?= input_hybrid('ID/Passport Number', 'user_phone', $user, true) ?>
                            </div>

                            <div class="col-lg-6 col-sm-12 col-12">
                                <?= input_hybrid('Email', 'user_email', $user, false, '', '', '', '', true) ?>
                                <?= input_hybrid('Date of Birth', 'user_dob', $user, true, 'date') ?>
                            </div>

                            <div class="divider MyDiver">
                                <div class="divider-text">Job Details</div>
                            </div>


                            <div class="col-lg-6 col-sm-12 col-12 mt-4">
                                <?= input_select_array('Select Destination Country', "country", $user, true, $countries, 'Click Here To Select A Country') ?>
                            </div>

                            <div class="col-lg-6 col-sm-12 col-12 mt-4">

                                <div class="form-group">
                                    <label for="job"><?= ucfirst('jobs ') ?> : </label>
                                    <select id="select2Multiple" multiple data-placeholder="Select jobs. You may choose more than 1." class="select2 form-select" name="jobs[]">

                                        <?php foreach ($jobs as $job) {
                                            $job_id = $job['job_id'];
                                        ?>
                                            <option value="<?= $job_id ?>"><?= ($job['job_name']) ?></option>
                                        <?php } ?>

                                    </select>
                                </div>

                            </div>


                            <div class="col-lg-12 col-sm-12 col-12 mt-4">
                                <?= input_hybrid('Upload Your CV  (pdf,docx)', 'upload_cv', $user, true, 'file', '', '', 'doc') ?>
                            </div>

                            <div class="col-lg-12 col-sm-12 col-12 mt-4">
                                <?= input_hybrid('Upload Your Passport (png, jpg, jpeg)', 'upload_passport', $user, true, 'file', '', '', 'img') ?>
                            </div>

                            <div class="col-lg-12 col-sm-12 col-12 mt-4">
                                <?= input_hybrid('Upload Your Full Photo (png, jpg, jpeg)', 'upload_full', $user, true, 'file', '', '', 'img') ?>
                            </div>

                            <div class="col-lg-12 col-sm-12 col-12 mt-4">
                                <?= input_hybrid('Upload Your Passport Bio (pdf,docx)', 'upload_bio', $user, true, 'file', '', '', 'doc') ?>
                            </div>

                            <div class="col-lg-12 col-sm-12 col-12 mt-4">
                                <?= input_hybrid('Upload Other Relevant Docs (pdf,docx)', 'upload_file', $user, false, 'file', '', '', 'doc') ?>
                            </div>
                        </div>
                        <button type="submit" class="btn rounded-pill btn-outline-primary mt-4" style="display: block;margin:auto;width:200px;">
                            <i class="fa-solid fa-upload"></i>
                            Upload
                        </button>
                    </form>
                </div>
            </div>
            <!--/ Plans Comparison -->

        </div>
    <?php
    } else {
    ?>
        <div class="card">
            <div class="container mb-4">
                <h2 class="text-center mb-2 mt-0 mt-md-4 ">Please Schedule An Appointment First</h2>
                <p class="text-center pb-3">
                    You have to book an appointment.
                </p>
                <a class="btn btn-outline-info" href="calendar" style="width:300px;display:block;margin:auto;">
                    Go To Appointment
                </a>
            </div>
        </div>
    <?php
    }
    ?>
</div>
<!-- / Content -->
<script>
    document.getElementById('openCard').addEventListener('click', function() {
        // Get the card element
        const card = document.getElementById('secondCard');
        // Change its display style to "block"
        card.style.display = 'block';
    });
</script>

<?php include_once 'footer.php' ?>