<?php
$page        = 'users';
$header_name = 'Clients';

require_once '../path.php';
require_once 'header.php';

$users = get_all_users();

$num_columns = 8;

$column_indexes = range(0, $num_columns - 1);

// Create an array of column definition objects
$column_defs = array();
for ($i = 0; $i < $num_columns; $i++) {
    $column_defs = array(
        array('data' => '', 'title' => 'S.no'),
        array('data' => 'col_' . $i, 'title' => 'S.no'),
        array('data' => 'user_name1', 'title' => 'Image'),
        array('data' => 'user_name', 'title' => 'Name'),
        array('data' => 'user_email', 'title' => 'Email'),
        array('data' => 'user_phone', 'title' => 'Phone'),
        array('data' => 'user_phone2', 'title' => 'Status'),
        array('data' => '', 'title' => 'Action')
    );
}

?>
<div class="container-xxl flex-grow-1 container-p-y">
    <h4 class="fw-bold py-3 mb-4"><span class="text-muted fw-light">View</span> Clients</h4>

    <!--  -->
    <div class="card">
        <div class="card-datatable table-responsive">
            <table class="datatables-basic table border-top">
                <thead>
                    <tr>
                        <th></th>

                        <th>S.no</th>
                        <th>Name</th>
                        <th>Email</th>
                        <th>Email</th>
                        <th>Email</th>
                        <th>Phone</th>
                        <th>Action</th>
                    </tr>
                </thead>
                <tbody>
                    <?php
                    $cnt = 1;
                    foreach ($users as $user) {
                        $user_id = encrypt($user['user_id']);
                        if (empty($user['user_image'])) {
                            $image = 'avt.png';
                        } else {
                            $image = $user['user_image'];
                        }
                        $booking = select_rows("SELECT * FROM booking WHERE user_id = '$user[user_id]' ORDER BY booking_date_created DESC ")[0];
                        $progress = select_rows("SELECT * FROM progress WHERE user_id = '$user[user_id]' ORDER BY step_id ASC ");

                        $steps = get_all('step');
                    ?>
                        <tr>
                            <td></td>
                            <td><?= $cnt ?></td>

                            <td> <img alt="user image" src="<?= image_url . $image ?>" style="width:100px; height:auto; border-radius:5px;object-fit:cover;" title="<?= $user['user_name'] ?>"> </td>
                            <td> <?= $user['user_name'] ?> </td>
                            <td> <?= $user['user_email'] ?> </td>
                            <td> <?= $user['user_phone'] ?> </td>
                            <td>
                                <?php
                                if (!empty($booking)) {
                                    $current_status = $booking['booking_status'];
                                ?>
                                    <div class="dropdown">
                                        <button class="btn btn-outline-info dropdown-toggle" type="button" data-bs-toggle="dropdown">
                                            Update Status
                                        </button>
                                        <ul class="dropdown-menu p-3" style="min-width: 250px;">
                                            <form method="POST" action="<?= model_url ?>step&from=view_clients">
                                                <input type="hidden" name="booking_id" value="<?= $booking['booking_id'] ?>">
                                                <input type="hidden" name="user_id" value="<?= $user['user_id'] ?>">
                                                <?php foreach ($steps as $step): ?>
                                                    <?php
                                                    $step_id = $step['step_id'];
                                                    $checked = $step_id <= $current_status ? 'checked' : '';
                                                    ?>
                                                    <li class="form-check mb-2">
                                                        <input class="form-check-input" type="checkbox" name="step_ids[]" value="<?= $step_id ?>" id="step<?= $step_id ?>" <?= $checked ?>>
                                                        <label class="form-check-label" for="step<?= $step_id ?>">
                                                            <?= htmlspecialchars($step['step_name']) ?>
                                                        </label>
                                                    </li>
                                                <?php endforeach; ?>
                                                <li class="mt-2">
                                                    <button type="submit" class="btn btn-sm btn-primary w-100">Update</button>
                                                </li>
                                            </form>
                                        </ul>
                                    </div>
                                <?php
                                } else {
                                    echo 'No Appointments';
                                }
                                ?>
                            </td>

                            <td>
                                <a href="user?id=<?= $user_id ?>" class="btn btn-info">
                                    <i class="fa-solid fa-eye"></i>
                                </a>

                                <a href="#" class="btn btn-danger">
                                    <i class="fa-solid fa-trash-can-arrow-up"></i>
                                </a>
                            </td>
                        </tr>
                    <?php
                        $cnt++;
                    }
                    ?>
                </tbody>

            </table>
        </div>
    </div>
</div>
<!-- container-fluid -->

<!-- End of Main Content -->
<?php include_once 'footer.php'; ?>