<?php
$page = 'users';
include_once 'header.php';
$user = get_by_id('user', security('id', 'GET'));
$_SESSION['edit'] = $user['user_id'];
if (isset($user['user_image'])) {
    $userImg = $user['user_image'];
} else {
    $userImg = 'avt.png';
}

$bookings = select_rows("SELECT * FROM booking WHERE user_id = '$user[user_id]'");
$upload = select_rows("SELECT * FROM upload WHERE user_id = '$user[user_id]'")[0];
$progress = select_rows("SELECT * FROM progress WHERE user_id = '$user[user_id]' ORDER BY step_id ASC ");

$steps = get_all('step');

?>
<div class="container-xxl flex-grow-1 container-p-y">
    <h4 class="fw-bold py-3 mb-4"><span class="text-muted fw-light">User / View /</span> Account</h4>
    <div class="row">
        <!-- User Sidebar -->
        <div class="col-xl-4 col-lg-5 col-md-5 order-1 order-md-0">
            <!-- User Card -->
            <div class="card mb-4">
                <div class="card-body">
                    <div class="user-avatar-section">
                        <div class="d-flex align-items-center flex-column">
                            <img
                                class="img-fluid rounded my-4"
                                src="<?= image_url . $userImg ?>"
                                height="110"
                                width="110"
                                style="object-fit: cover;"
                                alt="User avatar" />
                            <div class="user-info text-center">
                                <h4 class="mb-2"><?= $user['user_name'] ?></h4>
                            </div>
                        </div>
                    </div>
                    <h5 style="font-size: 12px;" class="pb-2 border-bottom mb-4">USER DETAILS</h5>
                    <div class="info-container">
                        <ul class="list-unstyled">
                            <li class="mb-3">
                                <span class="fw-bold me-2"><i class="fa-regular fa-user"></i></span>
                                <span><?= $user['user_name'] ?></span>
                            </li>
                            <li class="mb-3">
                                <span class="fw-bold me-2"><i class="fa-regular fa-envelope"></i></span>
                                <span><?= $user['user_email'] ?></span>
                            </li>
                            <li class="mb-3">
                                <span class="fw-bold me-2"><i class="fa-solid fa-phone"></i></span>
                                <span><?= $user['user_phone'] ?></span>
                            </li>
                            <li class="mb-3">
                                <span class="fw-bold me-2"><i class="fa-regular fa-calendar-plus"></i></span>
                                <span><?= get_ordinal_day_month_year($user['user_dob']) ?></span>
                            </li>
                            <li class="mb-3">
                                <span class="fw-bold me-2"><i class="fa-solid fa-id-card"></i></span>
                                <span><?= $user['user_passport'] ?></span>
                            </li>

                        </ul>
                        <div class="d-flex justify-content-center pt-3">
                            <a
                                href="javascript:;"
                                class="btn btn-primary me-3"
                                data-bs-target="#editUser"
                                data-bs-toggle="modal">Edit</a>
                            <a href="javascript:;" class="btn btn-label-danger suspend-user">Delete</a>
                        </div>
                    </div>
                </div>
            </div>
            <!-- /User Card -->

        </div>
        <!--/ User Sidebar -->

        <!-- User Content -->
        <div class="col-xl-8 col-lg-7 col-md-7 order-0 order-md-1">


            <!-- Activity Timeline -->
            <div class="card mb-4">

                <div class="card-body">
                    <h5 style="font-size: 12px;" class="pb-2 border-bottom mb-4">PROGRESS</h5>

                    <ul class="timeline">
                        <li class="timeline-item timeline-item-transparent">
                            <span class="timeline-point timeline-point-primary"></span>
                            <div class="timeline-event">
                                <div class="timeline-header mb-1">
                                    <h5 class="mb-0">User Signed Up</h5>
                                    <small class="text-muted"><?= get_ordinal_month($user['user_date_created']) ?></small>
                                </div>
                                <p class="mb-2"><?= $user['user_name'] ?> created their account at <?= get_hours_mins($user['user_date_created']) ?> </p>
                                <!-- <div class="d-flex">
                                    <a href="javascript:void(0)" class="me-3">
                                        <img
                                            src="<?= base_url ?>assets/img/icons/misc/pdf.png"
                                            alt="PDF image"
                                            width="15"
                                            class="me-2" />
                                        <span class="fw-bold text-body">invoices.pdf</span>
                                    </a>
                                </div> -->
                            </div>
                        </li>
                        <?php
                        if (!empty($bookings)) {
                            foreach ($bookings as $booking) { ?>
                                <li class="timeline-item timeline-item-transparent">
                                    <span class="timeline-point timeline-point-info"></span>
                                    <div class="timeline-event">
                                        <div class="timeline-header mb-1">
                                            <h5 class="mb-0">Appointment Booked</h5>
                                            <small class="text-muted"><?= get_ordinal_day_month_year($booking['booking_date']) ?></small>
                                        </div>
                                        <p class="mb-2"><?= $user['user_name'] ?> made an application for <?= get_ordinal_day_month_year($booking['booking_date']) ?> at <?= get_hours_mins($booking['booking_time']) ?></p>
                                        <div class="d-flex flex-wrap">
                                            <span style="font-weight:800;">TITLE:</span>
                                            <span> <?= $booking['booking_title'] ?></span>
                                        </div>

                                    </div>
                                </li>

                                <?php
                                if (!empty($upload)) { ?>
                                    <li class="timeline-item timeline-item-transparent">
                                        <span class="timeline-point timeline-point-info"></span>
                                        <div class="timeline-event">
                                            <div class="timeline-header mb-1">
                                                <h5 class="mb-0">User Uploaded Documents</h5>
                                                <small class="text-muted"><?= get_ordinal_day_month_year($upload['upload_date_created']) ?></small>
                                            </div>
                                            <p class="mb-2"><?= $user['user_name'] ?> uploaded documents at <?= get_hours_mins($upload['upload_date_created']) ?> </p>

                                            <div class="d-table w-100" style="max-width: 600px; margin: auto;">
                                                <?php
                                                $files = [
                                                    'CV' => $upload['upload_cv'],
                                                    'Bio' => $upload['upload_bio'],
                                                    'Other' => $upload['upload_file']
                                                ];

                                                foreach ($files as $label => $filePath):
                                                    if (!empty($filePath)):
                                                ?>
                                                        <div class="d-table-row border-bottom py-2 align-middle">
                                                            <div class="d-table-cell" style="padding-right: 20px; vertical-align: middle; width: 150px;">
                                                                <strong><?= $label ?></strong>
                                                            </div>
                                                            <div class="d-table-cell">
                                                                <a target="_blank" href="<?= file_url . $filePath ?>" class="d-flex align-items-center">
                                                                    <img
                                                                        src="<?= base_url ?>assets/img/icons/misc/pdf.png"
                                                                        alt="PDF"
                                                                        width="15"
                                                                        class="me-2" />
                                                                    <span class="fw-bold text-body">Click to download file</span>
                                                                </a>
                                                            </div>
                                                        </div>
                                                <?php
                                                    endif;
                                                endforeach;
                                                ?>
                                            </div>

                                            <div class="d-table w-100" style="max-width: 600px; margin: auto;">
                                                <?php
                                                $imagez = [
                                                    'PASSPORT' => $upload['upload_passport'],
                                                    'FULL' => $upload['upload_full']
                                                ];

                                                foreach ($imagez as $l => $fileP):
                                                    if (!empty($fileP)):
                                                ?>
                                                        <div class="d-table-row border-bottom py-2 align-middle">
                                                            <div class="d-table-cell" style="padding-right: 20px; vertical-align: middle; width: 150px;">
                                                                <strong><?= $l ?></strong>
                                                            </div>
                                                            <div class="d-table-cell">
                                                                    <img
                                                                        src="<?= image_url . $fileP ?>"
                                                                        alt="PDF"
                                                                        width="150"
                                                                        class="me-2" />
                                                            </div>
                                                        </div>
                                                <?php
                                                    endif;
                                                endforeach;
                                                ?>
                                            </div>


                                        </div>
                                    </li>
                                <?php
                                }
                                ?>
                        <?php
                            }
                        }

                        ?>

                        <?php
                        if (!empty($progress)) {
                            foreach ($progress as $p) {
                                $step = get_by_id('step', $p['step_id']);
                        ?>
                                <li class="timeline-item timeline-item-transparent">
                                    <span class="timeline-point timeline-point-info"></span>
                                    <div class="timeline-event">
                                        <div class="timeline-header mb-1">
                                            <h5 class="mb-0"><?= $step['step_name'] ?></h5>
                                            <small class="text-muted"><?= get_ordinal_day_month_year($p['progress_date_created']) ?></small>
                                        </div>
                                        <p class="mb-2">
                                            Admin updated the application's status.
                                        </p>
                                    </div>
                                </li>
                        <?php
                            }
                        }
                        ?>

                        <div>
                            <a class="btn btn-outline-info" href="javascript:;"
                                data-bs-target="#editStatus"
                                style="margin-left: 2em;"
                                data-bs-toggle="modal">
                                Update Status
                            </a>

                            <a class="btn btn-dark" href="javascript:;"
                                data-bs-target="#uploadDocs"
                                style="margin-left: 2em;"
                                data-bs-toggle="modal">
                                <!-- <i class=""></i> -->
                                <span class="fa-solid fa-file-import me-1"></span>
                                Upload Documents
                            </a>
                        </div>


                        <li class="timeline-end-indicator">
                            <i class="bx bx-check-circle"></i>
                        </li>
                    </ul>
                </div>
            </div>
            <!-- /Activity Timeline -->


        </div>
        <!--/ User Content -->
    </div>

    <!-- Modal -->
    <!-- Edit User Modal -->
    <div class="modal fade" id="editUser" tabindex="-1" aria-hidden="true">
        <div class="modal-dialog modal-lg modal-simple modal-edit-user">
            <div class="modal-content p-3 p-md-5">
                <div class="modal-body">
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    <div class="text-center mb-4">
                        <h3>Edit User Information</h3>
                    </div>
                    <form method="POST" class="row g-3" action="<?= model_url ?>register">
                        <div class="col-12 col-md-12">
                            <label class="form-label" for="modalEditUserFirstName">First Name</label>
                            <input
                                type="text"
                                id="modalEditUserFirstName"
                                name="user_name"
                                value="<?= $user['user_name'] ?>"
                                class="form-control" />
                        </div>

                        <div class="col-12 col-md-6">
                            <label class="form-label" for="modalEditUserEmail">Email</label>
                            <input
                                type="text"
                                id="modalEditUserEmail"
                                name="user_email"
                                class="form-control"
                                value="<?= $user['user_email'] ?>" />
                        </div>

                        <div class="col-12 col-md-6">
                            <label class="form-label" for="modalEditTaxID">ID/Passport Number</label>
                            <input
                                type="text"
                                id="modalEditTaxID"
                                name="user_passport"
                                class="form-control modal-edit-tax-id"
                                value="<?= $user['user_passport'] ?>" />
                        </div>
                        <div class="col-12 col-md-6">
                            <label class="form-label" for="modalEditUserPhone">Phone Number</label>
                            <div class="input-group input-group-merge">
                                <input
                                    type="text"
                                    id="modalEditUserPhone"
                                    name="user_phone"
                                    class="form-control phone-number-mask"
                                    value="<?= $user['user_phone'] ?>" />
                            </div>
                        </div>

                        <div class="col-12 col-md-6">
                            <label class="form-label" for="modalEditUserdob">Date: <?= $user['user_dob'] ?></label>
                            <div class="input-group input-group-merge">
                                <input
                                    type="date"
                                    id="modalEditUserdob"
                                    name="user_dob"
                                    class="form-control dob-number-mask"
                                    value="<?= $user['user_dob'] ?>" />
                            </div>
                        </div>

                        <div class="col-12 text-center">
                            <button type="submit" class="btn btn-primary me-sm-3 me-1">Submit</button>
                            <button
                                type="reset"
                                class="btn btn-label-secondary"
                                data-bs-dismiss="modal"
                                aria-label="Close">
                                Cancel
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
    <!--/ Edit User Modal -->

    <!-- Add New Credit Card Modal -->
    <div class="modal fade" id="editStatus" tabindex="-1" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-simple modal-upgrade-plan">
            <div class="modal-content p-3 p-md-5">
                <div class="modal-body">
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    <div class="text-center mb-4">
                        <h3>Update Progress</h3>
                    </div>
                    <?php
                    $current_status = $booking['booking_status'];
                    ?>
                    <!-- Dropdown Button -->
                    <div class="dropdown">
                        <button class="btn btn-outline-primary dropdown-toggle" style="display: block;margin:auto;" type="button" data-bs-toggle="dropdown">
                            CLICK HERE TO UPDATE STATUS
                        </button>
                        <ul class="dropdown-menu p-3" style="min-width: 250px;">
                            <form method="POST" action="<?= model_url ?>step&from=booking">
                                <input type="hidden" name="user_id" value="<?= $user['user_id'] ?>">
                                <input type="hidden" name="booking_id" value="<?= $booking['booking_id'] ?>">
                                
                                <?php foreach ($steps as $step): ?>
                                    <?php
                                    $step_id = $step['step_id'];
                                    $checked = $step_id <= $current_status ? 'checked' : '';
                                    ?>
                                    <li class="form-check mb-2">
                                        <input class="form-check-input" type="checkbox" name="step_ids[]" value="<?= $step_id ?>" id="step<?= $step_id ?>" <?= $checked ?>>
                                        <label class="form-check-label" for="step<?= $step_id ?>">
                                            <?= htmlspecialchars($step['step_name']) ?>
                                        </label>
                                    </li>
                                <?php endforeach; ?>
                                <li class="mt-2">
                                    <button type="submit" class="btn btn-sm btn-primary w-100">Update</button>
                                </li>
                            </form>
                        </ul>
                    </div>

                </div>
                <hr class="mx-md-n5 mx-n3" />
                <div class="modal-body">
                    <h6 class="mb-0">User Steps So Far</h6>
                    <?php foreach ($steps as $step): ?>
                        <div class="form-check">
                            <input
                                class="form-check-input"
                                type="checkbox"
                                name="step_id"
                                value="<?= $step['step_id'] ?>"
                                id="step_<?= $step['step_id'] ?>_booking_<?= $booking['booking_id'] ?>"
                                <?= ($step['step_id'] <= $booking['booking_status']) ? 'checked' : '' ?>
                                <?= ($step['step_id'] > $booking['booking_status']) ? 'disabled' : '' ?>>
                            <label class="form-check-label" for="step_<?= $step['step_id'] ?>_booking_<?= $booking['booking_id'] ?>">
                                <?= htmlspecialchars($step['step_name']) ?>
                            </label>
                        </div>
                    <?php endforeach; ?>
                </div>
            </div>
        </div>
    </div>
    <!--/ Add New Credit Card Modal -->

    <!-- Add New Credit Card Modal -->
    <div class="modal fade" id="uploadDocs" tabindex="-1" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-simple modal-upgrade-plan">
            <div class="modal-content p-3 p-md-5">
                <div class="modal-body">
                    <div class="text-center mb-4">
                        <h3>Upload Docs</h3>
                    </div>
                    <form method="POST" enctype="multipart/form-data" action="<?= model_url ?>admin_upload">
                        <input type="hidden" name="user_id" value="<?= $user['user_id'] ?>">
                        <div class="row">
                            <div class="col-lg-12 col-sm-12 col-12 mt-4">
                                <?= input_hybrid('Upload Client\'s Revamped CV', 'upload_cv', $user, false, 'file') ?>
                            </div>

                           
                        </div>
                        <button type="submit" class="btn rounded-pill btn-outline-primary mt-4" style="display: block;margin:auto;width:200px;">
                            <i class="fa-solid fa-upload"></i>
                            Upload
                        </button>
                    </form>

                </div>

            </div>
        </div>
    </div>
    <!--/ Add New Credit Card Modal -->

    <!-- /Modal -->
</div>
<!-- / Content -->

<style>
    .d-table-cell {
        border: 1px solid;
        padding: 0.5em;
    }
</style>
<?php include_once 'footer.php' ?>