<?php
require_once '../model/create.php';

$admin_id = $_SESSION['admin_id'] ?? 0;
if (!$admin_id) {
    echo json_encode(['error' => 'Admin not logged in']);
    exit;
}

// for_loop();
file_put_contents('debug_log.txt', print_r($_POST, true));
file_put_contents('debug_log.txt', print_r($arr, true));

// Debug (remove later)

$arr['chat_id'] = create_id('chat', 'chat_id');
$arr['chat_sender_role'] = 'admin';
$arr['chat_sender_id'] = $admin_id;
$arr['chat_receiver_role'] = 'client';
$arr['chat_receiver_id'] = security('user_id');
$arr['chat_message'] = security('message');



if (empty($arr['chat_receiver_id']) || empty($arr['chat_message'])) {
    echo json_encode(['error' => 'Missing user_id or message']);
    exit;
}

if (!build_sql_insert('chat', $arr)) {
    $error['chat'] = 152;
    echo json_encode(['error' => $arr  + 'Failed to insert chat message']);
    exit;
}

//Send notif
$notifArray['notification_title']   = 'New Message';
$notifArray['notification_text']    = 'The admin has messaged you';
$notifArray['notification_to']      = security('user_id');
$notifArray['notification_from']    = 'Admin';
$notifArray['notification_redirect'] = 'chat';

if (!build_sql_insert('notification', $notifArray)) {
    $error['notification'] = 139;
    error_checker($return_url);
}

echo json_encode(['success' => true]);
