<?php
error_reporting(E_ALL ^ E_WARNING);
require_once '../path.php';
require_once MODEL_PATH . "operations.php";

if (isset($_SESSION) && $_SESSION['login'] == true) redirect_header(client_url);

if (!empty($_SESSION['error'])) {
    foreach ($_SESSION['error'] as $err) {
        error_message(ERROR_DEFINITION[$err]) . PHP_EOL;
    }
}

if (!empty($_SESSION['success'])) {
    foreach ($_SESSION['success'] as $success) {
        success_message(SUCCESS_DEFINITION[$success]) . PHP_EOL;
    }
}

if (!empty($_SESSION['warning'])) {
    foreach ($_SESSION['warning'] as $warning) {
        warning_message(WARNING_DEFINITION[$warning]) . PHP_EOL;
    }
}

unset_session_error();
unset_session_success();
unset_session_warning();
?>
<!DOCTYPE html>

<html
    lang="en"
    class="light-style customizer-hide"
    dir="ltr"
    data-theme="theme-default"
    data-assets-path="<?= base_url ?>assets/"
    data-template="vertical-menu-template-no-customizer">

<head>
    <meta charset="utf-8" />
    <meta
        name="viewport"
        content="width=device-width, initial-scale=1.0, user-scalable=no, minimum-scale=1.0, maximum-scale=1.0" />

    <title><?= APP_NAME ?></title>

    <meta name="description" content="" />

    <!-- Favicon -->
    <link rel="icon" type="image/x-icon" href="<?= base_url ?>assets/img/logos/favicon.png" />

    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com" />
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin />
    <link
        href="https://fonts.googleapis.com/css2?family=Public+Sans:ital,wght@0,300;0,400;0,500;0,600;0,700;1,300;1,400;1,500;1,600;1,700&display=swap"
        rel="stylesheet" />

    <!-- Icons -->
    <link rel="stylesheet" href="<?= base_url ?>assets/vendor/fonts/boxicons.css" />
    <link rel="stylesheet" href="<?= base_url ?>assets/vendor/fonts/fontawesome.css" />
    <link rel="stylesheet" href="<?= base_url ?>assets/vendor/fonts/flag-icons.css" />

    <!-- Core CSS -->
    <link rel="stylesheet" href="<?= base_url ?>assets/vendor/css/rtl/core.css" />
    <link rel="stylesheet" href="<?= base_url ?>assets/vendor/css/rtl/theme-default.css" />
    <link rel="stylesheet" href="<?= base_url ?>assets/css/demo.css" />

    <!-- Vendors CSS -->
    <link rel="stylesheet" href="<?= base_url ?>assets/vendor/libs/perfect-scrollbar/perfect-scrollbar.css" />
    <link rel="stylesheet" href="<?= base_url ?>assets/vendor/libs/typeahead-js/typeahead.css" />
    <!-- Vendor -->
    <link rel="stylesheet" href="<?= base_url ?>assets/vendor/libs/formvalidation/dist/css/formValidation.min.css" />

    <!-- Page CSS -->
    <!-- Page -->
    <link rel="stylesheet" href="<?= base_url ?>assets/vendor/css/pages/page-auth.css" />
    <link rel="stylesheet" href="<?= base_url ?>assets/vendor/libs/sweetalert2/sweetalert2.css" />

    <!-- Helpers -->
    <script src="<?= base_url ?>assets/vendor/js/helpers.js"></script>

    <!--! Template customizer & Theme config files MUST be included after core stylesheets and helpers.js in the <head> section -->
    <!--? Config:  Mandatory theme config file contain global vars & default theme options, Set your preferred theme option in this file.  -->
    <script src="<?= base_url ?>assets/js/config.js"></script>
</head>

<body>
    <!-- Content -->

    <div class="authentication-wrapper authentication-cover">
        <div class="authentication-inner row m-0">
            <!-- /Left Text -->
            <div class="d-none d-lg-flex col-lg-7 col-xl-8 align-items-center p-5"
            style="background: url('<?= base_url ?>assets/img/dubai.jpg');"
            >
                <div class="w-100 d-flex justify-content-center">
                    <!-- <img
                        src="<?= base_url ?>assets/img/dubai.jpg"
                        class="img-fluid"
                        alt="Login image"
                        style="width: 100%;"
                        data-app-dark-img="dubai.jpg"
                        data-app-light-img="dubai.jpg" /> -->
                </div>
            </div>
            <!-- /Left Text -->

            <!-- Login -->
            <div class="d-flex col-12 col-lg-5 col-xl-4 align-items-center authentication-bg p-sm-5 p-4">
                <div class="w-px-400 mx-auto">
                    <!-- Logo -->
                    <div class="app-brand justify-content-center">
                        <a href="index" class="app-brand-link gap-2">
                            <img src="../assets/img/logos/logo.png" style="width: 150px;" />
                        </a>
                    </div>
                    <!-- /Logo -->
                    <p class="mb-4">Please sign-in to your account and start the adventure</p>

                    <form action="<?= model_url ?>admin_login" method="POST" class="mb-3">
                        <div class="mb-3">
                            <label for="email" class="form-label">Email</label>
                            <input
                                type="text"
                                class="form-control"
                                id="email"
                                name="admin_email"
                                placeholder="Enter your email or username"
                                autofocus />
                        </div>
                        <div class="mb-3 form-password-toggle">
                            <div class="d-flex justify-content-between">
                                <label class="form-label" for="password">Password</label>
                                <a href="auth-forgot-password-cover.html">
                                    <small>Forgot Password?</small>
                                </a>
                            </div>
                            <div class="input-group input-group-merge">
                                <input
                                    type="password"
                                    id="password"
                                    class="form-control"
                                    name="admin_password"
                                    placeholder="&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;"
                                    aria-describedby="password" />
                                <span class="input-group-text cursor-pointer"><i class="bx bx-hide"></i></span>
                            </div>
                        </div>
                        <div class="mb-3">
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" id="remember-me" />
                                <label class="form-check-label" for="remember-me"> Remember Me </label>
                            </div>
                        </div>
                        <button class="btn btn-primary d-grid w-100">Sign in</button>
                    </form>

                </div>
            </div>
            <!-- /Login -->
        </div>
    </div>

    <!-- / Content -->

    <!-- Core JS -->
    <!-- build:js assets/vendor/js/core.js -->
    <script src="<?= base_url ?>assets/vendor/libs/jquery/jquery.js"></script>
    <script src="<?= base_url ?>assets/vendor/libs/popper/popper.js"></script>
    <script src="<?= base_url ?>assets/vendor/js/bootstrap.js"></script>
    <script src="<?= base_url ?>assets/vendor/libs/perfect-scrollbar/perfect-scrollbar.js"></script>

    <script src="<?= base_url ?>assets/vendor/libs/hammer/hammer.js"></script>
    <script src="<?= base_url ?>assets/vendor/libs/i18n/i18n.js"></script>
    <script src="<?= base_url ?>assets/vendor/libs/typeahead-js/typeahead.js"></script>

    <script src="<?= base_url ?>assets/vendor/js/menu.js"></script>
    <!-- endbuild -->

    <!-- Vendors JS -->
    <script src="<?= base_url ?>assets/vendor/libs/formvalidation/dist/js/FormValidation.min.js"></script>
    <script src="<?= base_url ?>assets/vendor/libs/formvalidation/dist/js/plugins/Bootstrap5.min.js"></script>
    <script src="<?= base_url ?>assets/vendor/libs/formvalidation/dist/js/plugins/AutoFocus.min.js"></script>

    <!-- Main JS -->
    <script src="<?= base_url ?>assets/js/main.js"></script>

    <script src="<?= base_url ?>assets/vendor/libs/sweetalert2/sweetalert2.js"></script>
    <!-- Page JS -->
    <script src="<?= base_url ?>assets/js/extended-ui-sweetalert2.js"></script>
    <script src="<?= base_url ?>assets/js/pages-auth.js"></script>
</body>

</html>