<?php
$page = 'home';
include_once 'header.php';
$totalUsersCount = sizeof(select_rows("SELECT * FROM user"));
$newUserCount = sizeof(select_rows("SELECT * FROM user WHERE user_date_created >= CURDATE() - INTERVAL 7 DAY"));
$bookingCount = sizeof(select_rows("SELECT * FROM booking"));
?>
<div class="container-xxl flex-grow-1 container-p-y">
    <div class="row gy-4">
        <div class="col-xxl-12">
            <div class="row gy-4">
                <div class="col-xxl-4 col-sm-6">
                   <a href="view_users">
                        <div class="card p-3 shadow-2 radius-8 border input-form-light h-100 bg-gradient-end-1">
                        <div class="card-body p-0">
                            <div class="d-flex flex-wrap align-items-center justify-content-between gap-1 mb-8">

                                <div class="d-flex align-items-center gap-2">
                                    <span class="mb-0 MySpan  w-48-px h-48-px bg-primary-600 flex-shrink-0 text-white d-flex justify-content-center align-items-center rounded-circle h6 mb-0">
                                        <img src="<?= base_url ?>assets/img/icons/users.png" class="HomeIcons" />
                                    </span>
                                    <div>
                                        <span class="mb-2 fw-medium text-secondary-light text-sm">Total Clients</span>
                                        <h6 class="fw-semibold"><?= $totalUsersCount ?></h6>
                                    </div>
                                </div>

                                <div id="new-user-chart" class="remove-tooltip-title rounded-tooltip-value"></div>
                            </div>
                            <p class="text-sm mb-0">Increase by <span class="bg-success-focus px-1 rounded-2 fw-medium text-success-main text-sm">+200</span> this week</p>
                        </div>
                    </div>
                   </a>
                </div>

                <div class="col-xxl-4 col-sm-6">
                    <div class="card p-3 shadow-2 radius-8 border input-form-light h-100 bg-gradient-end-2">
                        <div class="card-body p-0">
                            <div class="d-flex flex-wrap align-items-center justify-content-between gap-1 mb-8">

                                <div class="d-flex align-items-center gap-2">
                                    <span class="mb-0 MySpan  w-48-px h-48-px bg-success-main flex-shrink-0 text-white d-flex justify-content-center align-items-center rounded-circle h6">
                                        <img src="<?= base_url ?>assets/img/icons/new.png" class="HomeIcons" />
                                    </span>
                                    <div>
                                        <span class="mb-2 fw-medium text-secondary-light text-sm">New Users</span>
                                        <h6 class="fw-semibold"><?= $newUserCount ?></h6>
                                    </div>
                                </div>

                                <div id="active-user-chart" class="remove-tooltip-title rounded-tooltip-value"></div>
                            </div>
                            <p class="text-sm mb-0">Increase by <span class="bg-success-focus px-1 rounded-2 fw-medium text-success-main text-sm">+200</span> this week</p>
                        </div>
                    </div>
                </div>

                <div class="col-xxl-4 col-sm-6">
                    <div class="card p-3 shadow-2 radius-8 border input-form-light h-100 bg-gradient-end-3">
                        <div class="card-body p-0">
                            <div class="d-flex flex-wrap align-items-center justify-content-between gap-1 mb-8">

                                <div class="d-flex align-items-center gap-2">
                                    <span class="mb-0 MySpan  w-48-px h-48-px bg-yellow text-white flex-shrink-0 d-flex justify-content-center align-items-center rounded-circle h6">
                                        <img src="<?= base_url ?>assets/img/icons/appointment.png" class="HomeIcons" />

                                    </span>
                                    <div>
                                        <span class="mb-2 fw-medium text-secondary-light text-sm">Appointments Booked</span>
                                        <h6 class="fw-semibold"><?= $bookingCount ?></h6>
                                    </div>
                                </div>

                                <div id="total-sales-chart" class="remove-tooltip-title rounded-tooltip-value"></div>
                            </div>
                            <p class="text-sm mb-0">Increase by <span class="bg-danger-focus px-1 rounded-2 fw-medium text-danger-main text-sm">-$10k</span> this week</p>
                        </div>
                    </div>
                </div>

                <div class="col-xxl-4 col-sm-6">
                    <div class="card p-3 shadow-2 radius-8 border input-form-light h-100 bg-gradient-end-4">
                        <div class="card-body p-0">
                            <div class="d-flex flex-wrap align-items-center justify-content-between gap-1 mb-8">

                                <div class="d-flex align-items-center gap-2">
                                    <span class="mb-0 MySpan  w-48-px h-48-px bg-purple text-white flex-shrink-0 d-flex justify-content-center align-items-center rounded-circle h6">
                                        <img src="<?= base_url ?>assets/img/icons/chat.png" class="HomeIcons" />

                                    </span>
                                    <div>
                                        <span class="mb-2 fw-medium text-secondary-light text-sm">Chats</span>
                                        <h6 class="fw-semibold">0</h6>
                                    </div>
                                </div>

                                <div id="conversion-user-chart" class="remove-tooltip-title rounded-tooltip-value"></div>
                            </div>
                            <p class="text-sm mb-0">Increase by <span class="bg-success-focus px-1 rounded-2 fw-medium text-success-main text-sm">+5%</span> this week</p>
                        </div>
                    </div>
                </div>



                <div class="col-xxl-4 col-sm-6">
                    <div class="card p-3 shadow-2 radius-8 border input-form-light h-100 bg-gradient-end-6">
                        <div class="card-body p-0">
                            <div class="d-flex flex-wrap align-items-center justify-content-between gap-1 mb-8">

                                <div class="d-flex align-items-center gap-2">
                                    <span class="mb-0 MySpan  w-48-px h-48-px bg-cyan text-white flex-shrink-0 d-flex justify-content-center align-items-center rounded-circle h6">
                                        <img src="<?= base_url ?>assets/img/icons/complete.png" class="HomeIcons" />

                                    </span>
                                    <div>
                                        <span class="mb-2 fw-medium text-secondary-light text-sm">Completed Projects</span>
                                        <h6 class="fw-semibold">0</h6>
                                    </div>
                                </div>

                                <div id="total-profit-chart" class="remove-tooltip-title rounded-tooltip-value"></div>
                            </div>
                            <p class="text-sm mb-0">Increase by <span class="bg-success-focus px-1 rounded-2 fw-medium text-success-main text-sm">+$15k</span> this week</p>
                        </div>
                    </div>
                </div>

                <div class="col-xxl-4 col-sm-6">
                    <div class="card p-3 shadow-2 radius-8 border input-form-light h-100 bg-gradient-end-5">
                        <div class="card-body p-0">
                            <div class="d-flex flex-wrap align-items-center justify-content-between gap-1 mb-8">

                                <div class="d-flex align-items-center gap-2">
                                    <span class="mb-0 MySpan  w-48-px h-48-px bg-primary-600 text-white flex-shrink-0 d-flex justify-content-center align-items-center rounded-circle h6">
                                        <img src="<?= base_url ?>assets/img/icons/project.png" class="HomeIcons" />

                                    </span>
                                    <div>
                                        <span class="mb-2 fw-medium text-secondary-light text-sm">In Progress</span>
                                        <h6 class="fw-semibold"><?= $bookingCount ?></h6>
                                    </div>
                                </div>

                                <div id="leads-chart" class="remove-tooltip-title rounded-tooltip-value"></div>
                            </div>
                            <p class="text-sm mb-0">Increase by <span class="bg-success-focus px-1 rounded-2 fw-medium text-success-main text-sm">+20</span> this week</p>
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </div>
</div>
<!-- / Content -->
<style>
    .HomeIcons {
        width: 30px;
    }
</style>
<?php include_once 'footer.php' ?>