<?php
require_once '../path.php';
require_once MODEL_PATH . "operations.php";
$_SESSION['page'] = $page;
if (!isset($_SESSION) || $_SESSION['admin_login'] == false) {
    $warning['login'] = 300;
    render_warning(admin_url . 'login');
}
if (isset($_SESSION['edit'])) {
    unset($_SESSION['edit']);
}
if (!empty($_SESSION['error'])) {
    foreach ($_SESSION['error'] as $err) {
        error_message(ERROR_DEFINITION[$err]) . PHP_EOL;
    }
}

if (!empty($_SESSION['success'])) {
    foreach ($_SESSION['success'] as $success) {
        success_message(SUCCESS_DEFINITION[$success]) . PHP_EOL;
    }
}

if (!empty($_SESSION['warning'])) {
    foreach ($_SESSION['warning'] as $warning) {
        warning_message(WARNING_DEFINITION[$warning]) . PHP_EOL;
    }
}

unset_session_error();
unset_session_success();
unset_session_warning();

?>
<!DOCTYPE html>

<html
    lang="en"
    class="light-style layout-navbar-fixed layout-menu-fixed"
    dir="ltr"
    data-theme="theme-default"
    data-assets-path="<?= base_url ?>assets/"
    data-template="vertical-menu-template-no-customizer">

<head>
    <meta charset="utf-8" />
    <meta
        name="viewport"
        content="width=device-width, initial-scale=1.0, user-scalable=no, minimum-scale=1.0, maximum-scale=1.0" />

    <title><?= APP_NAME ?></title>

    <meta name="description" content="" />

    <!-- Favicon -->
    <link rel="icon" type="image/x-icon" href="<?= base_url ?>assets/img/logos/favicon.png" />
    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com" />
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin />
    <link href="https://fonts.googleapis.com/css2?family=Public+Sans:ital,wght@0,300;0,400;0,500;0,600;0,700;1,300;1,400;1,500;1,600;1,700&display=swap" rel="stylesheet" />

    <!-- Icons -->
    <link rel="stylesheet" href="<?= base_url ?>assets/vendor/fonts/boxicons.css" />
    <link rel="stylesheet" href="<?= base_url ?>assets/vendor/fonts/fontawesome.css" />
    <link rel="stylesheet" href="<?= base_url ?>assets/vendor/fonts/flag-icons.css" />
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.2.0/css/all.min.css" integrity="sha512-xh6O/CkQoPOWDdYTDqeRdPCVd1SpvCA9XXcUnZS2FmJNp1coAFzvtCN9BmamE+4aHK8yyUHUSCcJHgXloTyT2A==" crossorigin="anonymous" referrerpolicy="no-referrer" />

    <!-- Core CSS -->
    <link rel="stylesheet" href="<?= base_url ?>assets/vendor/css/rtl/core.css" class="template-customizer-core-css" />
    <link rel="stylesheet" href="<?= base_url ?>assets/vendor/css/rtl/theme-default.css" class="template-customizer-theme-css" />
    <link rel="stylesheet" href="<?= base_url ?>assets/css/demo.css" />

    <!-- Vendors CSS -->
    <link rel="stylesheet" href="<?= base_url ?>assets/vendor/libs/perfect-scrollbar/perfect-scrollbar.css" />
    <link rel="stylesheet" href="<?= base_url ?>assets/vendor/libs/typeahead-js/typeahead.css" />
    <link rel="stylesheet" href="<?= base_url ?>assets/vendor/libs/apex-charts/apex-charts.css" />
    <link rel="stylesheet" href="<?= base_url ?>assets/vendor/libs/datatables-bs5/datatables.bootstrap5.css" />
    <link rel="stylesheet" href="<?= base_url ?>assets/vendor/libs/datatables-responsive-bs5/responsive.bootstrap5.css" />
    <link rel="stylesheet" href="<?= base_url ?>assets/vendor/libs/datatables-checkboxes-jquery/datatables.checkboxes.css" />
    <link rel="stylesheet" href="<?= base_url ?>assets/vendor/libs/datatables-buttons-bs5/buttons.bootstrap5.css" />
    <link rel="stylesheet" href="<?= base_url ?>assets/vendor/libs/datatables-rowgroup-bs5/rowgroup.bootstrap5.css" />
    <link rel="stylesheet" href="<?= base_url ?>assets/vendor/libs/formvalidation/dist/css/formValidation.min.css" />
    <link rel="stylesheet" href="<?= base_url ?>assets/vendor/libs/flatpickr/flatpickr.css" />
    <link rel="stylesheet" href="<?= base_url ?>assets/vendor/libs/select2/select2.css" />
    <link rel="stylesheet" href="<?= base_url ?>assets/vendor/libs/animate-css/animate.css" />
    <link rel="stylesheet" href="<?= base_url ?>assets/vendor/libs/sweetalert2/sweetalert2.css" />
 
    <!-- Page CSS -->
    <link rel="stylesheet" href="<?= base_url ?>assets/malta.css" />
    <link rel="stylesheet" href="<?= base_url ?>assets/vendor/css/pages/page-account-settings.css" />
    <link rel="stylesheet" href="<?= base_url ?>assets/vendor/css/pages/page-profile.css" />
    <link rel="stylesheet" href="<?= base_url ?>assets/vendor/libs/fullcalendar/fullcalendar.css" />
    <link rel="stylesheet" href="<?= base_url ?>assets/vendor/css/pages/app-calendar.css" />
    <link rel="stylesheet" href="<?= base_url ?>assets/vendor/css/pages/page-user-view.css" />
    <link rel="stylesheet" href="<?= base_url ?>assets/vendor/libs/quill/editor.css" />
    <link rel="stylesheet" href="<?= base_url ?>assets/vendor/libs/quill/katex.css" />
    <link rel="stylesheet" href="<?= base_url ?>assets/vendor/css/pages/page-faq.css" />
    <link rel="stylesheet" href="<?= base_url ?>assets/vendor/css/pages/page-pricing.css" />
    <link rel="stylesheet" href="<?= base_url ?>assets/vendor/css/pages/app-chat.css" />
    <link rel="stylesheet" href="<?= base_url ?>assets/vendor/css/pages/app-email.css" />

    <!-- Helpers -->
    <script src="<?= base_url ?>assets/vendor/js/helpers.js"></script>

    <!-- Template Customizer & Config -->
    <script src="<?= base_url ?>assets/vendor/js/template-customizer.js"></script>
    <script src="<?= base_url ?>assets/js/config.js"></script>

    <!-- External JS -->
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.6.1/jquery.min.js"></script>

    <script>
        function loadNotifications() {
            $.get('fetch_notifications.php', function(data) {
                let notifs = JSON.parse(data);
                let notifList = '';

                if (notifs.length) {
                    notifs.forEach(notif => {
                        notifList += `
                    <li class="list-group-item list-group-item-action dropdown-notifications-item">
                        <div class="d-flex">
                            <a style="text-decoration: none;display:flex;" class="mark-as-read" href="${notif.notification_redirect}" data-id="${notif.notification_id}">
                                <div class="flex-shrink-0 me-3">
                                    <div class="avatar">
                                        <span class="avatar-initial rounded-circle bg-label-danger"></span>
                                    </div>
                                </div>
                                <div class="flex-grow-1">
                                    <h6 class="mb-1">${notif.notification_title}</h6>
                                    <p class="mb-0">${notif.notification_text}</p>
                                    <small class="text-muted">${notif.notification_date_created}</small>
                                </div>
                                <div class="flex-shrink-0 dropdown-notifications-actions">
                                    <span class="badge badge-dot"></span>
                                    <span class="bx bx-x"></span>
                                </div>
                            </a>
                        </div>
                    </li>`;
                    });
                } else {
                    notifList = '<li class="list-group-item">No new notifications</li>';
                }

                $('.dropdown-notifications-list ul').html(notifList);
                $('.badge-notifications').text(notifs.length);
            });
        }

        // Poll every 10 seconds
        setInterval(loadNotifications, 10000);
        loadNotifications();
    </script>

    <script>
        $(document).on('click', '.mark-as-read', function(e) {
            const notifId = $(this).data('id');

            // Mark as read before redirect
            $.post('mark_as_read.php', {
                id: notifId
            }, function(response) {
                if (response === 'success') {
                    // Continue to redirect
                    window.location.href = $('.mark-as-read[data-id="' + notifId + '"]').attr('href');
                }
            });

            e.preventDefault(); // Prevent immediate redirect
        });
    </script>



</head>

<body>
    <!-- Layout wrapper -->
    <div class="layout-wrapper layout-content-navbar">
        <div class="layout-container">
            <!-- Menu -->

            <aside id="layout-menu" class="layout-menu menu-vertical menu bg-menu-theme">
                <div class="app-brand demo">
                    <a href="index" class="app-brand-link">
                        <img src="<?= base_url ?>assets/img/logos/logo.png" style="width: 80px;" />
                    </a>

                    <a href="javascript:void(0);" class="layout-menu-toggle menu-link text-large ms-auto">
                        <i class="bx bx-chevron-left bx-sm align-middle"></i>
                    </a>
                </div>

                <div class="menu-inner-shadow"></div>

                <ul class="menu-inner py-1">
                    <!-- Dashboards -->
                    <li class="menu-item <?= $_SESSION['page'] == 'home' ? 'active' : '' ?>">
                        <a href="index" class="menu-link">
                            <i class="menu-icon tf-icons bx bx-home-circle"></i>
                            <div data-i18n="Home">Home</div>
                        </a>

                    </li>


                    <!-- Apps & Pages -->
                    <li class="menu-header small text-uppercase">
                        <span class="menu-header-text">User Management</span>
                    </li>

                    <li class="menu-item  <?= $_SESSION['page'] == 'bookings' ? 'active' : '' ?>">
                        <a href="view_bookings" class="menu-link">
                            <i class="menu-icon fa-regular fa-folder-open"></i>
                            <div data-i18n="Appointments">Appointments</div>
                        </a>
                    </li>
                    <li class="menu-item">
                        <a href="calendar" class="menu-link">
                            <i class="menu-icon fa-regular fa-calendar-plus"></i>
                            <div data-i18n="Calendar">Calendar</div>
                        </a>
                    </li>
                    <li class="menu-item  <?= $_SESSION['page'] == 'users' ? 'active' : '' ?>">
                        <a href="view_users" class="menu-link">
                            <i class="menu-icon fa-solid fa-user-tie"></i>
                            <div data-i18n="Clients">Clients</div>
                        </a>

                    </li>

                    <li class="menu-item  <?= $_SESSION['page'] == 'email' ? 'active' : '' ?>">
                        <a href="email" class="menu-link">
                            <i class="menu-icon fa-solid fa-envelope"></i>
                            <div data-i18n="Email">Email</div>
                        </a>
                    </li>
                    <li class="menu-item  <?= $_SESSION['page'] == 'chat' ? 'active' : '' ?>">
                        <a href="chat" class="menu-link">
                            <i class="menu-icon fa-solid fa-comments"></i>
                            <div data-i18n="Chat">Chat</div>
                        </a>
                    </li>


                    <!-- Components -->
                    <li class="menu-header small text-uppercase"><span class="menu-header-text">Account Management</span></li>

                    <li class="menu-item">
                        <a href="#" class="menu-link">
                            <i class="menu-icon fa-solid fa-unlock-keyhole"></i>
                            <div data-i18n="Change Password">Change Password</div>
                        </a>
                    </li>
                    <li class="menu-item">
                        <a href="?logout" class="menu-link">
                            <i class="menu-icon fa-solid fa-arrow-right-from-bracket"></i>
                            <div data-i18n="Logout">Logout</div>
                        </a>
                    </li>


                </ul>
            </aside>
            <!-- / Menu -->

            <!-- Layout container -->
            <div class="layout-page">
                <!-- Navbar -->

                <nav
                    class="layout-navbar container-xxl navbar navbar-expand-xl navbar-detached align-items-center bg-navbar-theme"
                    id="layout-navbar">
                    <div class="layout-menu-toggle navbar-nav align-items-xl-center me-3 me-xl-0 d-xl-none">
                        <a class="nav-item nav-link px-0 me-xl-4" href="javascript:void(0)">
                            <i class="bx bx-menu bx-sm"></i>
                        </a>
                    </div>

                    <div class="navbar-nav-right d-flex align-items-center" id="navbar-collapse">
                        <!-- Search -->
                        <div class="navbar-nav align-items-center">
                            <div class="nav-item navbar-search-wrapper mb-0">
                                <a class="nav-item nav-link search-toggler px-0" href="javascript:void(0);">
                                    <i class="bx bx-search bx-sm"></i>
                                    <span class="d-none d-md-inline-block text-muted">Search (Ctrl+/)</span>
                                </a>
                            </div>
                        </div>
                        <!-- /Search -->

                        <ul class="navbar-nav flex-row align-items-center ms-auto">
                            <!-- Language -->
                            <li class="nav-item dropdown-language dropdown me-2 me-xl-0">
                                <a class="nav-link dropdown-toggle hide-arrow" href="javascript:void(0);" data-bs-toggle="dropdown">
                                    <i class="fi fi-ke fis rounded-circle fs-3 me-1"></i>
                                </a>
                                <ul class="dropdown-menu dropdown-menu-end">
                                    <li>
                                        <a class="dropdown-item" href="javascript:void(0);" data-language="en">
                                            <i class="fi fi-ke fis rounded-circle fs-4 me-1"></i>
                                            <span class="align-middle">English</span>
                                        </a>
                                    </li>
                                    <li>
                                        <a class="dropdown-item" href="javascript:void(0);" data-language="fr">
                                            <i class="fi fi-fr fis rounded-circle fs-4 me-1"></i>
                                            <span class="align-middle">France</span>
                                        </a>
                                    </li>
                                    <li>
                                        <a class="dropdown-item" href="javascript:void(0);" data-language="de">
                                            <i class="fi fi-de fis rounded-circle fs-4 me-1"></i>
                                            <span class="align-middle">German</span>
                                        </a>
                                    </li>
                                    <li>
                                        <a class="dropdown-item" href="javascript:void(0);" data-language="pt">
                                            <i class="fi fi-pt fis rounded-circle fs-4 me-1"></i>
                                            <span class="align-middle">Portuguese</span>
                                        </a>
                                    </li>
                                </ul>
                            </li>
                            <!--/ Language -->

                            <!-- Style Switcher -->
                            <li class="nav-item me-2 me-xl-0">
                                <a class="nav-link style-switcher-toggle hide-arrow" href="javascript:void(0);">
                                    <i class="bx bx-sm"></i>
                                </a>
                            </li>
                            <!--/ Style Switcher -->


                            <!-- Notification -->
                            <li class="nav-item dropdown-notifications navbar-dropdown dropdown me-3 me-xl-1">
                                <a
                                    class="nav-link dropdown-toggle hide-arrow"
                                    href="javascript:void(0);"
                                    data-bs-toggle="dropdown"
                                    data-bs-auto-close="outside"
                                    aria-expanded="false">
                                    <i class="bx bx-bell bx-sm"></i>
                                    <span class="badge bg-danger rounded-pill badge-notifications"></span>
                                </a>
                                <ul class="dropdown-menu dropdown-menu-end py-0">
                                    <li class="dropdown-menu-header border-bottom">
                                        <div class="dropdown-header d-flex align-items-center py-3">
                                            <h5 class="text-body mb-0 me-auto">Notification</h5>
                                            <a
                                                href="javascript:void(0)"
                                                class="dropdown-notifications-all text-body"
                                                data-bs-toggle="tooltip"
                                                data-bs-placement="top"
                                                title="Mark all as read"><i class="bx fs-4 bx-envelope-open"></i></a>
                                        </div>
                                    </li>
                                    <li class="dropdown-notifications-list scrollable-container">
                                        <ul class="list-group list-group-flush">

                                        </ul>
                                    </li>

                                </ul>
                            </li>
                            <!--/ Notification -->
                            <!-- User -->
                            <li class="nav-item navbar-dropdown dropdown-user dropdown">
                                <a class="nav-link dropdown-toggle hide-arrow" href="javascript:void(0);" data-bs-toggle="dropdown">
                                    <div class="avatar avatar-online">
                                        <img src="<?= base_url ?>assets/img/illustrations/admin.png" alt style="height: 40px;object-fit:cover;" class="w-px-40 rounded-circle" />
                                    </div>
                                </a>
                                <ul class="dropdown-menu dropdown-menu-end">
                                    <li>
                                        <a class="dropdown-item" href="index">
                                            <div class="d-flex">
                                                <div class="flex-shrink-0 me-3">
                                                    <div class="avatar avatar-online">
                                                        <img src="<?= base_url ?>assets/img/illustrations/admin.png" alt style="height: 40px;object-fit:cover;" class="w-px-40 rounded-circle" />
                                                    </div>
                                                </div>
                                                <div class="flex-grow-1">
                                                    <span class="fw-semibold d-block">Welcom</span>
                                                    <small class="text-muted">Admin</small>
                                                </div>
                                            </div>
                                        </a>
                                    </li>
                                    <li>
                                        <div class="dropdown-divider"></div>
                                    </li>
                                    <li>
                                        <a class="dropdown-item" href="#">
                                            <i class="bx bx-user me-2"></i>
                                            <span class="align-middle">My Profile</span>
                                        </a>
                                    </li>
                                    <li>
                                        <a class="dropdown-item" href="#">
                                            <i class="bx bx-cog me-2"></i>
                                            <span class="align-middle">Settings</span>
                                        </a>
                                    </li>
                                    <li>
                                        <div class="dropdown-divider"></div>
                                    </li>
                                    <li>
                                        <a class="dropdown-item" href="#">
                                            <i class="bx bx-support me-2"></i>
                                            <span class="align-middle">Help</span>
                                        </a>
                                    </li>
                                    <li>
                                        <a class="dropdown-item" href="#">
                                            <i class="bx bx-help-circle me-2"></i>
                                            <span class="align-middle">FAQ</span>
                                        </a>
                                    </li>
                                    <li>
                                        <div class="dropdown-divider"></div>
                                    </li>
                                    <li>
                                        <a class="dropdown-item" href="?logout" target="_blank">
                                            <i class="bx bx-power-off me-2"></i>
                                            <span class="align-middle">Log Out</span>
                                        </a>
                                    </li>
                                </ul>
                            </li>
                            <!--/ User -->
                        </ul>
                    </div>

                    <!-- Search Small Screens -->
                    <div class="navbar-search-wrapper search-input-wrapper d-none">
                        <input
                            type="text"
                            class="form-control search-input container-xxl border-0"
                            placeholder="Search..."
                            aria-label="Search..." />
                        <i class="bx bx-x bx-sm search-toggler cursor-pointer"></i>
                    </div>
                </nav>

                <!-- / Navbar -->

                <!-- Content wrapper -->
                <div class="content-wrapper">
                    <!-- Content -->