<?php
require_once '../path.php';
require_once MODEL_PATH . "operations.php";

// Get users with chats (admin <-> user)
$sql_chats = "
SELECT u.user_id, u.user_name, u.user_email, u.user_image,
       c.chat_message, c.chat_timestamp
FROM user u
JOIN (
    SELECT 
        IF(chat_sender_role = 'client', chat_sender_id, chat_receiver_id) AS user_id,
        chat_message,
        chat_timestamp
    FROM chat
    WHERE (chat_sender_role = 'admin' AND chat_receiver_role = 'client')
       OR (chat_sender_role = 'client' AND chat_receiver_role = 'admin')
    ORDER BY chat_timestamp DESC
) c ON u.user_id = c.user_id
GROUP BY u.user_id
ORDER BY c.chat_timestamp DESC
";

$chat_users = select_rows($sql_chats);

// Get all users
$sql_all_users = "SELECT user_id, user_name, user_email, user_image FROM user";
$all_users = select_rows($sql_all_users);

// Filter out chat users from all users to get contacts
$chat_user_ids = array_column($chat_users, 'user_id');
$contacts = array_filter($all_users, function($u) use ($chat_user_ids) {
    return !in_array($u['user_id'], $chat_user_ids);
});

echo json_encode([
    'chats' => $chat_users,
    'contacts' => array_values($contacts),
]);