<?php
$page = 'chat';
include_once 'header.php';
$users = get_all('user');

?>

<div class="container-xxl flex-grow-1 container-p-y">
    <div class="app-chat overflow-hidden card">
        <div class="row g-0">
            <!-- Sidebar Left -->
            <div class="col app-chat-sidebar-left app-sidebar overflow-hidden" id="app-chat-sidebar-left">
                <div
                    class="chat-sidebar-left-user sidebar-header d-flex flex-column justify-content-center align-items-center flex-wrap p-4 mt-2">
                    <div class="avatar avatar-xl avatar-online">
                        <img src="<?= base_url ?>assets/img/avatars/1.png" alt="Avatar" class="rounded-circle" />
                    </div>
                    <h5 class="mt-3 mb-1">John Doe</h5>
                    <small class="text-muted">UI/UX Designer</small>
                    <i
                        class="bx bx-x bx-sm cursor-pointer close-sidebar me-1 fs-4"
                        data-bs-toggle="sidebar"
                        data-overlay
                        data-target="#app-chat-sidebar-left"></i>
                </div>
                <div class="sidebar-body px-4 pb-4">
                    <div class="my-3">
                        <span class="text-muted text-uppercase">About</span>
                        <textarea
                            id="chat-sidebar-left-user-about"
                            class="form-control chat-sidebar-left-user-about mt-2"
                            rows="4"
                            maxlength="120">

                            .</textarea>
                    </div>
                </div>
            </div>
            <!-- /Sidebar Left-->

            <!-- Chat & Contacts -->
            <div
                class="col app-chat-contacts app-sidebar flex-grow-0 overflow-hidden border-end"
                id="app-chat-contacts">
                <div class="sidebar-header pt-3 px-3 mx-1">
                    <div class="d-flex align-items-center me-3 me-lg-0">
                        <div
                            class="flex-shrink-0 avatar avatar-online me-2"
                            data-bs-toggle="sidebar"
                            data-overlay="app-overlay-ex"
                            data-target="#app-chat-sidebar-left">
                            <img
                                class="user-avatar rounded-circle cursor-pointer"
                                src="<?= base_url ?>assets/img/illustrations/admin.png"
                                alt="Avatar" />
                        </div>
                        <div class="flex-grow-1 input-group input-group-merge rounded-pill ms-1">
                            <span class="input-group-text" id="basic-addon-search31"><i class="bx bx-search fs-4"></i></span>
                            <input
                                type="text"
                                class="form-control chat-search-input"
                                placeholder="Search..."
                                aria-label="Search..."
                                aria-describedby="basic-addon-search31" />
                        </div>
                    </div>
                    <i
                        class="bx bx-x cursor-pointer position-absolute top-0 end-0 mt-2 me-1 fs-4 d-lg-none d-block"
                        data-overlay
                        data-bs-toggle="sidebar"
                        data-target="#app-chat-contacts"></i>
                </div>
                <hr class="container-m-nx mt-3 mb-0" />
                <div class="sidebar-body">
                    <!-- Chats -->
                    <ul class="list-unstyled chat-contact-list pt-1" id="chat-list">
                        <li class="chat-contact-list-item chat-contact-list-item-title">
                            <h5 class="text-primary mb-0">Chats</h5>
                        </li>
                        <!-- This is where AJAX will inject chat users -->
                        <li class="chat-contact-list-item chat-list-item-0 d-none">
                            <h6 class="text-muted mb-0">No Chats Found</h6>
                        </li>
                    </ul>

                    <!-- Contacts -->
                    <ul class="list-unstyled chat-contact-list mb-0" id="contact-list">
                        <li class="chat-contact-list-item chat-contact-list-item-title">
                            <h5 class="text-primary mb-0">Contacts</h5>
                        </li>
                        <!-- AJAX will inject contacts here -->
                        <li class="chat-contact-list-item contact-list-item-0 d-none">
                            <h6 class="text-muted mb-0">No Contacts Found</h6>
                        </li>
                    </ul>
                </div>
            </div>
            <!-- /Chat contacts -->

            <!-- Chat History -->
            <div class="col app-chat-history">
                <div class="chat-history-wrapper">
                    <div class="chat-history-header border-bottom">
                        <div class="d-flex justify-content-between align-items-center">
                            <div class="d-flex overflow-hidden align-items-center">
                                <i
                                    class="bx bx-menu bx-sm cursor-pointer d-lg-none d-block me-2"
                                    data-bs-toggle="sidebar"
                                    data-overlay
                                    data-target="#app-chat-contacts"></i>
                                <div class="flex-shrink-0 avatar" id="chat-header-avatar">
                                    <img
                                        src="<?= base_url ?>uploads/images/avt.png"
                                        alt="Avatar"
                                        class="rounded-circle" />
                                </div>
                                <div class="chat-contact-info flex-grow-1 ms-3">
                                    <h6 class="m-0" id="chat-header-name">Select a chat</h6>
                                    <small class="user-status text-muted" id="chat-header-status"></small>
                                </div>
                            </div>
                            <div class="d-flex align-items-center">
                                <i class="bx bx-phone-call cursor-pointer d-sm-block d-none me-3 fs-4"></i>
                                <i class="bx bx-video cursor-pointer d-sm-block d-none me-3 fs-4"></i>
                                <i class="bx bx-search cursor-pointer d-sm-block d-none me-3 fs-4"></i>
                                <div class="dropdown">
                                    <button
                                        class="btn p-0"
                                        type="button"
                                        id="chat-header-actions"
                                        data-bs-toggle="dropdown"
                                        aria-haspopup="true"
                                        aria-expanded="false">
                                        <i class="bx bx-dots-vertical-rounded fs-4"></i>
                                    </button>
                                    <div class="dropdown-menu dropdown-menu-end" aria-labelledby="chat-header-actions">
                                        <a class="dropdown-item" href="javascript:void(0);">View Contact</a>
                                        <a class="dropdown-item" href="javascript:void(0);">Mute Notifications</a>
                                        <a class="dropdown-item" href="javascript:void(0);">Block Contact</a>
                                        <a class="dropdown-item" href="javascript:void(0);">Clear Chat</a>
                                        <a class="dropdown-item" href="javascript:void(0);">Report</a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="chat-history-body">
                        <ul class="list-unstyled chat-history mb-0" id="chat-body">
                            <!-- AJAX will inject chat messages here -->
                        </ul>
                    </div>
                    <!-- Chat message form -->
                    <div class="chat-history-footer">
                        <form class="form-send-message d-flex justify-content-between align-items-center" id="chat-message-form" onsubmit="return false;">
                            <input
                                id="chat-message-input"
                                name="chat_message"
                                class="form-control message-input border-0 me-3 shadow-none"
                                placeholder="Type your message here..."
                                autocomplete="off" />
                            <div class="message-actions d-flex align-items-center">
                                <i class="speech-to-text bx bx-microphone bx-sm cursor-pointer"></i>
                                <label for="attach-doc" class="form-label mb-0">
                                    <i class="bx bx-paperclip bx-sm cursor-pointer mx-3"></i>
                                    <input type="file" id="attach-doc" hidden />
                                </label>
                                <button type="submit" class="btn btn-primary d-flex send-msg-btn">
                                    <i class="bx bx-paper-plane me-md-1 me-0"></i>
                                    <span class="align-middle d-md-inline-block d-none">Send</span>
                                </button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
            <!-- /Chat History -->

            <div class="app-overlay"></div>
        </div>
    </div>
</div>


<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

<script>
    $(document).ready(function() {
        const $chatList = $('#chat-list');
        const $contactList = $('#contact-list');
        const $chatBody = $('#chat-body');
        const $chatHeaderName = $('#chat-header-name');
        const $chatHeaderStatus = $('#chat-header-status');
        const $chatHeaderAvatar = $('#chat-header-avatar img');
        let currentUserId = null;

        let pollingInterval;

        function startPolling() {
            stopPolling(); // Clear any existing interval first
            pollingInterval = setInterval(function() {
                if (currentUserId) {
                    loadChatHistory(currentUserId);
                }
            }, 3000); // 3000ms = every 3 seconds
        }

        function stopPolling() {
            if (pollingInterval) {
                clearInterval(pollingInterval);
            }
        }


        function loadChatUsers() {
            $.get('get_chat_users.php', function(data) {
                data = JSON.parse(data);

                // Clear existing
                $chatList.find('.chat-contact-list-item').not('.chat-contact-list-item-title').remove();
                $contactList.find('.chat-contact-list-item').not('.chat-contact-list-item-title').remove();

                // Chats
                if (data.chats.length > 0) {
                    $.each(data.chats, function(i, user) {
                        const userImg = user.user_image ? user.user_image : 'avt.png';
                        $chatList.append(`
                        <li class="chat-contact-list-item chat-user" data-id="${user.user_id}" data-name="${user.user_name}" data-image="${user.user_image}">
                            <div class="d-flex align-items-center">
                                <img src="../uploads/images/${userImg}" class="avatar rounded-circle me-2" width="40">
                                <div>
                                    <div><strong>${user.user_name}</strong></div>
                                    <div class="text-muted small">${user.chat_message}</div>
                                </div>
                            </div>
                        </li>
                    `);
                    });
                } else {
                    $chatList.find('.chat-list-item-0').removeClass('d-none');
                }

                // Contacts
                if (data.contacts.length > 0) {
                    $.each(data.contacts, function(i, user) {
                        const usrImage = user.user_image ? user.user_image : 'avt.png';

                        $contactList.append(`
                        <li class="chat-contact-list-item contact-user" data-id="${user.user_id}" data-name="${user.user_name}" data-image="${user.user_image}">
                            <div class="d-flex align-items-center">
                                <img src="../uploads/images/${usrImage}" class="avatar rounded-circle me-2" width="40">
                                <div><strong>${user.user_name}</strong></div>
                            </div>
                        </li>
                    `);
                    });
                } else {
                    $contactList.find('.contact-list-item-0').removeClass('d-none');
                }
            });
        }

        function loadChatHistory(userId) {
            $.get('get_chat_history.php?user_id=' + userId, function(data) {
                data = JSON.parse(data);

                currentUserId = userId;
                $chatBody.empty();

                if (data.user) {
                    const userImg = data.user.user_image ? data.user.user_image : 'avt.png';
                    $chatHeaderName.text(data.user.user_name);
                    $chatHeaderAvatar.attr('src', '../uploads/images/' + userImg);
                    $chatHeaderStatus.text(data.user.user_email);
                }

                if (data.messages) {
                    $.each(data.messages, function(i, msg) {
                        const isAdmin = msg.chat_sender_role === 'admin';
                        const userImg = data.user.user_image ? data.user.user_image : 'avt.png';

                        $chatBody.append(`
                    <li class="chat-message ${isAdmin ? ' chat-message-right' : ''}">
                        <div class="d-flex overflow-hidden">
                            <div class="user-avatar flex-shrink-0 me-3">
                                <div class="avatar avatar-sm">
                                    ${isAdmin ? '' : `<img src="../uploads/images/${userImg}" alt="Avatar" class="rounded-circle" />`}
                                </div>
                            </div>
                            <div class="chat-message-wrapper flex-grow-1">
                                <div class="chat-message-text">
                                    <p class="mb-0">${msg.chat_message}</p>
                                </div>
                                <div class="text-muted small">${msg.chat_timestamp}</div>
                            </div>
                        </div>
                    </li>
                `);
                    });

                    $('.chat-history-body').scrollTop($chatBody[0].scrollHeight);
                }
            });
        }


        function sendMessage(message) {
            if (!currentUserId || !message.trim()) return;

            $.post('send_admin_message.php', {
                    user_id: currentUserId,
                    message: message
                })
                .done(function(response) {
                    try {
                        response = JSON.parse(response);
                        if (response.success) {
                            $('#chat-message-input').val('');
                            loadChatHistory(currentUserId);
                            loadChatUsers();
                        } else {
                            alert(response.error || 'Message not sent');
                            console.error('Server error:', response);
                        }
                    } catch (e) {
                        alert('Invalid JSON from server');
                        console.error('Parse error:', e);
                        console.log('Raw response:', response);
                    }
                })
                .fail(function(xhr, status, error) {
                    console.error('AJAX failed:', status, error);
                    alert('Request failed');
                });
        }

        // Initial load
        loadChatUsers();

        // Select chat or contact
        $(document).on('click', '.chat-user, .contact-user', function() {
            const userId = $(this).data('id');
            loadChatHistory(userId);
            startPolling();
        });

        // Send message
        $('#chat-message-form').on('submit', function(e) {
            e.preventDefault();
            const msg = $('#chat-message-input').val();
            sendMessage(msg);
        });
    });
</script>


<?php include_once 'footer.php' ?>