<?php
$page = 'start';
include_once 'header.php';
$bookings = select_rows("SELECT * FROM booking");
// cout($bookings);
$dateCounts = [];
foreach ($bookings as $booking) {
    $date = $booking['booking_date'];
    $dateCounts[$date] = ($dateCounts[$date] ?? 0) + 1;
}

$blockedDates = [];
foreach ($dateCounts as $date => $count) {
    if ($count >= 2) {
        $blockedDates[] = $date;
    }
}
?>

<div class="container-xxl flex-grow-1 container-p-y">


    <div class="card app-calendar-wrapper">
        <div class="row g-0">
            <!-- Calendar Sidebar -->
            <div class="col app-calendar-sidebar" id="app-calendar-sidebar">
                <div class="border-bottom p-4 my-sm-0 mb-3">
                    <div class="d-grid">
                        <button
                            class="btn btn-primary btn-toggle-sidebar"
                            data-bs-toggle="offcanvas"
                            data-bs-target="#addEventSidebar"
                            aria-controls="addEventSidebar">
                            <i class="bx bx-plus me-1"></i>
                            <span class="align-middle">Add Event</span>
                        </button>
                    </div>
                </div>
                <div class="p-4">
                    <!-- inline calendar (flatpicker) -->
                    <div class="ms-n2">
                        <div class="inline-calendar"></div>
                    </div>

                    <hr class="container-m-nx my-4" />

                    <!-- Filter -->
                    <div class="mb-4">
                        <small class="text-small text-muted text-uppercase align-middle">Filter</small>
                    </div>

                    <div class="form-check mb-2">
                        <input
                            class="form-check-input select-all"
                            type="checkbox"
                            id="selectAll"
                            data-value="all"
                            checked />
                        <label class="form-check-label" for="selectAll">View All</label>
                    </div>

                    <div class="app-calendar-events-filter" style="visibility: hidden;">

                        <div class="form-check mb-2">
                            <input
                                class="form-check-input input-filter"
                                type="checkbox"
                                id="select-business"
                                data-value="business"
                                checked />
                            <label class="form-check-label" for="select-business">Business</label>
                        </div>

                    </div>
                </div>
            </div>
            <!-- /Calendar Sidebar -->

            <!-- Calendar & Modal -->
            <div class="col app-calendar-content">
                <div class="card shadow-none border-0">
                    <div class="card-body pb-0">
                        <!-- FullCalendar -->
                        <div id="calendar"></div>
                    </div>
                </div>
                <div class="app-overlay"></div>
                <!-- FullCalendar Offcanvas -->
                <div
                    class="offcanvas offcanvas-end event-sidebar"
                    tabindex="-1"
                    id="addEventSidebar"
                    aria-labelledby="addEventSidebarLabel">
                    <div class="offcanvas-header border-bottom">
                        <h5 class="offcanvas-title mb-2" id="addEventSidebarLabel">Add Booking</h5>
                        <button
                            type="button"
                            class="btn-close text-reset"
                            data-bs-dismiss="offcanvas"
                            aria-label="Close"></button>
                    </div>
                    <div class="offcanvas-body">
                        <form class="event-form pt-0" method="POST" action="<?= model_url ?>booking">
                            <input type="hidden" name="eventId" id="eventId">

                            <div class="mb-3">
                                <label class="form-label" for="eventTitle">Title</label>
                                <input
                                    type="text"
                                    class="form-control"
                                    id="eventTitle"
                                    name="booking_title"
                                    placeholder="Event Title" />
                            </div>

                            <div class="mb-3">
                                <label class="form-label" for="eventStartDate">Start Date</label>
                                <input
                                    type="text"
                                    class="form-control"
                                    id="eventStartDate"
                                    name="booking_date"
                                    placeholder="Start Date" />
                            </div>


                            <div class="mb-3">
                                <label class="form-label" for="eventDescription">M-Pesa Transaction ID</label>
                                <textarea class="form-control" name="booking_description" id="eventDescription"></textarea>
                            </div>
                            <div class="mb-3 d-flex justify-content-sm-between justify-content-start my-4">
                                <div>
                                    <button type="submit" class="btn btn-primary btn-add-event me-sm-3 me-1">Add</button>
                                    <a class="btn btn-label-secondary btn-cancel me-sm-0 me-1">
                                        Cancel
                                    </a>
                                </div>
                                <div>
                                    <button type="button" style="visibility: hidden;" id="deleteBookingBtn" data-id="eventId" class="btn btn-label-danger btn-delete-event d-none">Delete</button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
            <!-- /Calendar & Modal -->
        </div>
    </div>
</div>
<!-- / Content -->

<script>
    let date = new Date();
    let nextDay = new Date(new Date().getTime() + 24 * 60 * 60 * 1000);
    // prettier-ignore
    let nextMonth = date.getMonth() === 11 ? new Date(date.getFullYear() + 1, 0, 1) : new Date(date.getFullYear(), date.getMonth() + 1, 1);
    // prettier-ignore
    let prevMonth = date.getMonth() === 11 ? new Date(date.getFullYear() - 1, 0, 1) : new Date(date.getFullYear(), date.getMonth() - 1, 1);

    let events = [
        <?php foreach ($bookings as $index => $booking): ?> {
                id: <?= json_encode($booking['booking_id']) ?>,
                url: '', // you can set this to a booking details page if needed
                title: <?= json_encode($booking['booking_title']) ?>,
                start: new Date("<?= $booking['booking_date'] . 'T' . $booking['booking_time'] ?>"),
                end: new Date("<?= $booking['booking_date'] . 'T' . $booking['booking_time'] ?>"),
                description: <?= json_encode($booking['booking_description']) ?>,
                allDay: false,
                extendedProps: {
                    calendar: 'Business',
                }
            }
            <?= $index + 1 < count($bookings) ? ',' : '' ?>
        <?php endforeach; ?>
    ];


    document.getElementById('deleteBookingBtn').addEventListener('click', function() {
        const bookingId = this.getAttribute('data-id');

        if (!bookingId) {
            alert('No event selected.');
            return;
        }

        if (confirm('Are you sure you want to delete this booking?')) {
            // Redirect to delete URL
            window.location.href = `<?= delete_url ?>id=${bookingId}&table=booking&page=calendar&method=simple_admin&isClient=true`;
        }
    });
</script>

<script>
    let direction = 'ltr';
    let blockedDates = <?= json_encode($blockedDates) ?>;

    document.addEventListener('DOMContentLoaded', function() {
        (function() {
            const calendarEl = document.getElementById('calendar'),
                appCalendarSidebar = document.querySelector('.app-calendar-sidebar'),
                addEventSidebar = document.getElementById('addEventSidebar'),
                appOverlay = document.querySelector('.app-overlay'),
                calendarsColor = {
                    Business: 'primary',
                    Holiday: 'success',
                    Personal: 'danger',
                    Family: 'warning',
                    ETC: 'info'
                },
                offcanvasTitle = document.querySelector('.offcanvas-title'),
                btnToggleSidebar = document.querySelector('.btn-toggle-sidebar'),
                btnSubmit = document.querySelector('button[type="submit"]'),
                btnDeleteEvent = document.querySelector('.btn-delete-event'),
                btnCancel = document.querySelector('.btn-cancel'),
                eventTitle = document.querySelector('#eventTitle'),
                eventStartDate = document.querySelector('#eventStartDate'),
                eventEndDate = document.querySelector('#eventEndDate'),
                eventUrl = document.querySelector('#eventURL'),
                eventLabel = $('#eventLabel'), // ! Using jquery vars due to select2 jQuery dependency
                eventGuests = $('#eventGuests'), // ! Using jquery vars due to select2 jQuery dependency
                eventLocation = document.querySelector('#eventLocation'),
                eventDescription = document.querySelector('#eventDescription'),
                eventId = document.querySelector('#eventId'),
                allDaySwitch = document.querySelector('.allDay-switch'),
                selectAll = document.querySelector('.select-all'),
                filterInput = [].slice.call(document.querySelectorAll('.input-filter')),
                inlineCalendar = document.querySelector('.inline-calendar');

            let eventToUpdate,
                currentEvents = events,
                isFormValid = false,
                inlineCalInstance;

            const bsAddEventSidebar = new bootstrap.Offcanvas(addEventSidebar);

            if (eventLabel.length) {
                function renderBadges(option) {
                    if (!option.id) {
                        return option.text;
                    }
                    var $badge =
                        "<span class='badge badge-dot bg-" + $(option.element).data('label') + " me-2'> " + '</span>' + option.text;

                    return $badge;
                }
                eventLabel.wrap('<div class="position-relative"></div>').select2({
                    placeholder: 'Select value',
                    dropdownParent: eventLabel.parent(),
                    templateResult: renderBadges,
                    templateSelection: renderBadges,
                    minimumResultsForSearch: -1,
                    escapeMarkup: function(es) {
                        return es;
                    }
                });
            }

            // Event start (flatpicker)
            if (eventStartDate) {
                var start = eventStartDate.flatpickr({
                    enableTime: true,
                    altFormat: 'Y-m-dTH:i:S',
                    onReady: function(selectedDates, dateStr, instance) {
                        if (instance.isMobile) {
                            instance.mobileInput.setAttribute('step', null);
                        }
                    }
                });
            }



            // Inline sidebar calendar (flatpicker)
            if (inlineCalendar) {
                inlineCalInstance = inlineCalendar.flatpickr({
                    monthSelectorType: 'static',
                    inline: true
                });
            }

            // Event click function
            function eventClick(info) {

                eventToUpdate = info.event;

                console.log('Clicked Event:', eventToUpdate);
                console.log('Extended Props:', eventToUpdate.extendedProps);
                console.log('Description (root):', eventToUpdate.description);


                console.log(eventToUpdate)
                bsAddEventSidebar.show();
                // For update event set offcanvas title text: Update Event
                if (offcanvasTitle) {
                    offcanvasTitle.innerHTML = 'Update Event';
                }
                btnSubmit.innerHTML = 'Update';
                btnSubmit.classList.add('btn-update-event');
                btnSubmit.classList.remove('btn-add-event');
                btnDeleteEvent.classList.remove('d-none');

                btnCancel.innerHTML = 'View Booking';
                btnCancel.setAttribute('href', `booking?id=${eventToUpdate.id}`);
                btnCancel.setAttribute('target', '_blank'); // optional: opens in new tab

                const deleteBtn = document.getElementById('deleteBookingBtn');
                deleteBtn.setAttribute('data-id', info.event.id);
                deleteBtn.classList.remove('d-none'); // show it

                eventTitle.value = eventToUpdate.title;
                start.setDate(eventToUpdate.start, true, 'Y-m-d');

                eventLabel.val(eventToUpdate.extendedProps.calendar).trigger('change');
                eventDescription.value = eventToUpdate.extendedProps['description'] || '';
                eventId.value = eventToUpdate.extendedProps.publicId || eventToUpdate.id;
                console.log('Event ID is:', eventId.value);
            }

            // Modify sidebar toggler
            function modifyToggler() {
                const fcSidebarToggleButton = document.querySelector('.fc-sidebarToggle-button');
                fcSidebarToggleButton.classList.remove('fc-button-primary');
                fcSidebarToggleButton.classList.add('d-lg-none', 'd-inline-block', 'ps-0');
                while (fcSidebarToggleButton.firstChild) {
                    fcSidebarToggleButton.firstChild.remove();
                }
                fcSidebarToggleButton.setAttribute('data-bs-toggle', 'sidebar');
                fcSidebarToggleButton.setAttribute('data-overlay', '');
                fcSidebarToggleButton.setAttribute('data-target', '#app-calendar-sidebar');
                fcSidebarToggleButton.insertAdjacentHTML('beforeend', '<i class="bx bx-menu bx-sm text-body"></i>');
            }

            // Filter events by calender
            function selectedCalendars() {
                let selected = [],
                    filterInputChecked = [].slice.call(document.querySelectorAll('.input-filter:checked'));

                filterInputChecked.forEach(item => {
                    selected.push(item.getAttribute('data-value'));
                });

                return selected;
            }


            function fetchEvents(info, successCallback) {
                let calendars = selectedCalendars();

                // Add grey background events for blocked dates
                const backgroundBlocks = blockedDates.map(date => ({
                    start: date,
                    end: date,
                    display: 'background',
                    backgroundColor: '#ff0040', // light grey
                    rendering: 'background'
                }));

                let selectedEvents = currentEvents.filter(event =>
                    calendars.includes(event.extendedProps.calendar.toLowerCase())
                );

                // Combine regular + background events
                successCallback([...selectedEvents, ...backgroundBlocks]);
            }

            // Init FullCalendar
            // ------------------------------------------------
            let calendar = new Calendar(calendarEl, {
                initialView: 'dayGridMonth',
                events: fetchEvents,
                plugins: [dayGridPlugin, interactionPlugin, listPlugin, timegridPlugin],
                editable: true,
                dragScroll: true,
                dayMaxEvents: 2,
                eventResizableFromStart: true,
                customButtons: {
                    sidebarToggle: {
                        text: 'Sidebar'
                    }
                },
                headerToolbar: {
                    start: 'sidebarToggle, prev,next, title',
                    end: 'dayGridMonth,timeGridWeek,timeGridDay,listMonth'
                },
                direction: direction,
                initialDate: new Date(),
                navLinks: true, // can click day/week names to navigate views
                eventClassNames: function({
                    event: calendarEvent
                }) {
                    const colorName = calendarsColor[calendarEvent._def.extendedProps.calendar];
                    return ['fc-event-' + colorName];
                },
                dateClick: function(info) {
                    let clickedDate = moment(info.date).format('YYYY-MM-DD');

                    // Normalize all blocked dates to YYYY-MM-DD for strict comparison
                    const normalizedBlockedDates = blockedDates.map(date => moment(date).format('YYYY-MM-DD'));

                    if (normalizedBlockedDates.includes(clickedDate)) {
                        console.log('Blocked date clicked, ignoring:', clickedDate);
                        return;
                    }

                    resetValues();
                    bsAddEventSidebar.show();

                    if (offcanvasTitle) {
                        offcanvasTitle.innerHTML = 'Add Event';
                    }
                    btnSubmit.innerHTML = 'Add';
                    btnSubmit.classList.remove('btn-update-event');
                    btnSubmit.classList.add('btn-add-event');
                    btnDeleteEvent.classList.add('d-none');
                    eventStartDate.value = clickedDate;
                    eventEndDate.value = clickedDate;
                    btnCancel.innerHTML = 'Cancel';
                    btnCancel.removeAttribute('href');
                    btnCancel.removeAttribute('target');
                },
                eventClick: function(info) {
                    eventClick(info);
                },
                datesSet: function() {
                    modifyToggler();
                },
                viewDidMount: function() {
                    modifyToggler();
                }
            });

            calendar.render();
            modifyToggler();

            const eventForm = document.getElementById('eventForm');
            const fv = FormValidation.formValidation(eventForm, {
                    fields: {
                        eventTitle: {
                            validators: {
                                notEmpty: {
                                    message: 'Please enter event title '
                                }
                            }
                        },
                        eventStartDate: {
                            validators: {
                                notEmpty: {
                                    message: 'Please enter start date '
                                }
                            }
                        },
                        eventEndDate: {
                            validators: {
                                notEmpty: {
                                    message: 'Please enter end date '
                                }
                            }
                        }
                    },
                    plugins: {
                        trigger: new FormValidation.plugins.Trigger(),
                        bootstrap5: new FormValidation.plugins.Bootstrap5({
                            eleValidClass: '',
                            rowSelector: function(field, ele) {
                                return '.mb-3';
                            }
                        }),
                        submitButton: new FormValidation.plugins.SubmitButton(),
                        autoFocus: new FormValidation.plugins.AutoFocus()
                    }
                })
                .on('core.form.valid', function() {
                    isFormValid = true;
                })
                .on('core.form.invalid', function() {
                    isFormValid = false;
                });

            // Sidebar Toggle Btn
            if (btnToggleSidebar) {
                btnToggleSidebar.addEventListener('click', e => {
                    btnCancel.classList.remove('d-none');
                });
            }

            // Add Event
            // ------------------------------------------------
            function addEvent(eventData) {
                // ? Add new event data to current events object and refetch it to display on calender
                // ? You can write below code to AJAX call success response

                currentEvents.push(eventData);
                calendar.refetchEvents();

                // ? To add event directly to calender (won't update currentEvents object)
                // calendar.addEvent(eventData);
            }

            // Update Event
            // ------------------------------------------------
            function updateEvent(eventData) {
                eventData.id = parseInt(eventData.id);
                currentEvents[currentEvents.findIndex(el => el.id === eventData.id)] = eventData; // Update event by id
                calendar.refetchEvents();
            }



            // (Update Event In Calendar (UI Only)
            // ------------------------------------------------
            const updateEventInCalendar = (updatedEventData, propsToUpdate, extendedPropsToUpdate) => {
                const existingEvent = calendar.getEventById(updatedEventData.id);

                // --- Set event properties except date related ----- //
                // ? Docs: https://fullcalendar.io/docs/Event-setProp
                // dateRelatedProps => ['start', 'end', 'allDay']
                // eslint-disable-next-line no-plusplus
                for (var index = 0; index < propsToUpdate.length; index++) {
                    var propName = propsToUpdate[index];
                    existingEvent.setProp(propName, updatedEventData[propName]);
                }

                // --- Set date related props ----- //
                // ? Docs: https://fullcalendar.io/docs/Event-setDates
                existingEvent.setDates(updatedEventData.start, updatedEventData.end, {
                    allDay: updatedEventData.allDay
                });

                // --- Set event's extendedProps ----- //
                // ? Docs: https://fullcalendar.io/docs/Event-setExtendedProp
                // eslint-disable-next-line no-plusplus
                for (var index = 0; index < extendedPropsToUpdate.length; index++) {
                    var propName = extendedPropsToUpdate[index];
                    existingEvent.setExtendedProp(propName, updatedEventData.extendedProps[propName]);
                }
            };

            // Remove Event In Calendar (UI Only)
            // ------------------------------------------------
            function removeEventInCalendar(eventId) {
                calendar.getEventById(eventId).remove();
            }

            // Add new event
            // ------------------------------------------------
            btnSubmit.addEventListener('click', e => {
                if (btnSubmit.classList.contains('btn-add-event')) {
                    if (isFormValid) {
                        let newEvent = {
                            id: calendar.getEvents().length + 1,
                            title: eventTitle.value,
                            start: eventStartDate.value,
                            end: eventEndDate.value,
                            startStr: eventStartDate.value,
                            endStr: eventEndDate.value,
                            description: eventDescription.value,
                            display: 'block',
                            extendedProps: {
                                calendar: eventLabel.val(),
                            }
                        };
                        if (eventUrl.value) {
                            newEvent.url = eventUrl.value;
                        }
                        if (allDaySwitch.checked) {
                            newEvent.allDay = true;
                        }
                        addEvent(newEvent);
                        bsAddEventSidebar.hide();
                    }
                } else {
                    // Update event
                    // ------------------------------------------------
                    if (isFormValid) {
                        let eventData = {
                            id: eventToUpdate.id,
                            title: eventTitle.value,
                            start: eventStartDate.value,
                            end: eventEndDate.value,
                            url: eventUrl.value,
                            description: eventDescription.value,
                            extendedProps: {
                                calendar: eventLabel.val(),
                            },
                            display: 'block',
                            allDay: allDaySwitch.checked ? true : false
                        };

                        updateEvent(eventData);
                        bsAddEventSidebar.hide();
                    }
                }
            });

            // Call removeEvent function
            btnDeleteEvent.addEventListener('click', e => {
                removeEvent(parseInt(eventToUpdate.id));
                // eventToUpdate.remove();
                bsAddEventSidebar.hide();
            });

            // Reset event form inputs values
            // ------------------------------------------------
            function resetValues() {
                eventTitle.value = '';
                eventStartDate.value = '';
                eventLabel.value = '';
                eventDescription.value = '';
                if (eventId) eventId.value = ''; // if you're using a hidden ID field
            }

            // When modal hides reset input values
            addEventSidebar.addEventListener('hidden.bs.offcanvas', function() {
                resetValues();
            });

            // Hide left sidebar if the right sidebar is open
            btnToggleSidebar.addEventListener('click', e => {
                if (offcanvasTitle) {
                    offcanvasTitle.innerHTML = 'Add Event';
                }
                btnSubmit.innerHTML = 'Add';
                btnSubmit.classList.remove('btn-update-event');
                btnSubmit.classList.add('btn-add-event');
                btnDeleteEvent.classList.add('d-none');
                appCalendarSidebar.classList.remove('show');
                appOverlay.classList.remove('show');
            });

            // Calender filter functionality
            // ------------------------------------------------
            if (selectAll) {
                selectAll.addEventListener('click', e => {
                    if (e.currentTarget.checked) {
                        document.querySelectorAll('.input-filter').forEach(c => (c.checked = 1));
                    } else {
                        document.querySelectorAll('.input-filter').forEach(c => (c.checked = 0));
                    }
                    calendar.refetchEvents();
                });
            }

            if (filterInput) {
                filterInput.forEach(item => {
                    item.addEventListener('click', () => {
                        document.querySelectorAll('.input-filter:checked').length < document.querySelectorAll('.input-filter').length ?
                            (selectAll.checked = false) :
                            (selectAll.checked = true);
                        calendar.refetchEvents();
                    });
                });
            }

            // Jump to date on sidebar(inline) calendar change
            inlineCalInstance.config.onChange.push(function(date) {
                calendar.changeView(calendar.view.type, moment(date[0]).format('YYYY-MM-DD'));
                modifyToggler();
                appCalendarSidebar.classList.remove('show');
                appOverlay.classList.remove('show');
            });
        })();
    });
</script>


<?php include_once 'footer.php' ?>